/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt.base.incremental;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt.base.incremental.RuntimeProcType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J:\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00180\u001bJ\f\u0010\u001d\u001a\u00020\f*\u00020\u0006H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0002J\"\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u001bJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\b0\u0018J,\u0010#\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00180\u001bJ,\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\u001e\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00180\u001bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/kapt/base/incremental/IncrementalAptCache;", "Ljava/io/Serializable;", "<init>", "()V", "aggregatingGenerated", "", "Ljava/io/File;", "aggregatedTypes", "", "isolatingMapping", "", "value", "", "isIncremental", "()Z", "updateCache", "processors", "", "Lorg/jetbrains/kotlin/kapt/base/incremental/IncrementalProcessor;", "failedToAnalyzeSources", "invalidateAggregating", "", "invalidateIsolatingForOriginTypes", "originatingTypes", "", "getIsolatingGeneratedTypesForOrigins", "typeInfoProvider", "Lkotlin/Function1;", "", "isJavaFileOrClass", "invalidateCache", "getOriginForGeneratedIsolatingType", "generatedType", "sourceFileProvider", "getAggregatingOrigins", "getAggregatingGeneratedTypes", "getIsolatingGeneratedTypes", "kotlin-annotation-processing-base"})
@SourceDebugExtension(value={"SMAP\nIncrementalAptCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalAptCache.kt\norg/jetbrains/kotlin/kapt/base/incremental/IncrementalAptCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,148:1\n1869#2,2:149\n1869#2,2:151\n1374#2:153\n1460#2,5:154\n1869#2:159\n1870#2:162\n1869#2,2:163\n1869#2,2:167\n1869#2,2:171\n1869#2,2:173\n216#3,2:160\n216#3,2:165\n216#3,2:169\n*S KotlinDebug\n*F\n+ 1 IncrementalAptCache.kt\norg/jetbrains/kotlin/kapt/base/incremental/IncrementalAptCache\n*L\n29#1:149,2\n43#1:151,2\n48#1:153\n48#1:154,5\n50#1:159\n50#1:162\n64#1:163,2\n81#1:167,2\n129#1:171,2\n141#1:173,2\n51#1:160,2\n75#1:165,2\n97#1:169,2\n*E\n"})
public final class IncrementalAptCache
implements Serializable {
    @NotNull
    private final Set<File> aggregatingGenerated = new LinkedHashSet();
    @NotNull
    private final Set<String> aggregatedTypes = new LinkedHashSet();
    @NotNull
    private final Map<File, String> isolatingMapping = new LinkedHashMap();
    private boolean isIncremental = true;

    public final boolean isIncremental() {
        return this.isIncremental;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean updateCache(@NotNull List<IncrementalProcessor> processors, boolean failedToAnalyzeSources) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        IncrementalProcessor it;
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        if (failedToAnalyzeSources) {
            this.invalidateCache();
            return false;
        }
        List aggregating = new ArrayList();
        List isolating = new ArrayList();
        List nonIncremental = new ArrayList();
        Iterable $this$forEach$iv = processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IncrementalProcessor)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getRuntimeType().ordinal()]) {
                case 1: {
                    boolean bl2 = aggregating.add(it);
                    break;
                }
                case 2: {
                    boolean bl2 = isolating.add(it);
                    break;
                }
                case 3: {
                    boolean bl2 = nonIncremental.add(it);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (!((Collection)nonIncremental).isEmpty()) {
            this.invalidateCache();
            return false;
        }
        this.aggregatingGenerated.clear();
        $this$forEach$iv = aggregating;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IncrementalProcessor)element$iv;
            boolean bl = false;
            this.aggregatingGenerated.addAll((Collection<File>)it.getGeneratedToSources().keySet());
        }
        this.aggregatedTypes.clear();
        $this$forEach$iv = aggregating;
        Set<String> set = this.aggregatedTypes;
        boolean $i$f$flatMap = false;
        Iterator iterator = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IncrementalProcessor it2 = (IncrementalProcessor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it2.getAggregatedTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        set.addAll((List)destination$iv$iv);
        $this$forEach$iv = isolating;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IncrementalProcessor it3 = (IncrementalProcessor)element$iv;
            boolean bl = false;
            Map<File, String> $this$forEach$iv2 = it3.getGeneratedToSources();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<File, String>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                String type;
                Map.Entry<File, String> element$iv2;
                Map.Entry<File, String> entry = element$iv2 = iterator2.next();
                boolean bl3 = false;
                File file = entry.getKey();
                String string = type = entry.getValue();
                Intrinsics.checkNotNull((Object)string);
                this.isolatingMapping.put(file, string);
            }
        }
        return true;
    }

    public final void invalidateAggregating() {
        Iterable $this$forEach$iv = this.aggregatingGenerated;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            it.delete();
        }
        this.aggregatingGenerated.clear();
        this.aggregatedTypes.clear();
    }

    public final void invalidateIsolatingForOriginTypes(@NotNull Set<String> originatingTypes) {
        Map.Entry<File, String> element$iv;
        Intrinsics.checkNotNullParameter(originatingTypes, (String)"originatingTypes");
        Set isolatingGenerated = new LinkedHashSet();
        Object $this$forEach$iv = this.isolatingMapping;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<File, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, String> entry = element$iv = iterator.next();
            boolean bl = false;
            File file = entry.getKey();
            String type = entry.getValue();
            if (!originatingTypes.contains(type)) continue;
            isolatingGenerated.add(file);
        }
        $this$forEach$iv = isolatingGenerated;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            File it = (File)((Object)element$iv);
            boolean bl = false;
            this.isolatingMapping.remove(it);
            it.delete();
        }
    }

    @NotNull
    public final List<String> getIsolatingGeneratedTypesForOrigins(@NotNull Set<String> originatingTypes, @NotNull Function1<? super Collection<? extends File>, ? extends Set<String>> typeInfoProvider) {
        Intrinsics.checkNotNullParameter(originatingTypes, (String)"originatingTypes");
        Intrinsics.checkNotNullParameter(typeInfoProvider, (String)"typeInfoProvider");
        List allGeneratedTypes = new ArrayList();
        Object currentOrigins = null;
        currentOrigins = CollectionsKt.toSet((Iterable)originatingTypes);
        while (!((Collection)currentOrigins).isEmpty()) {
            Set generated = new LinkedHashSet();
            Map<File, String> $this$forEach$iv = this.isolatingMapping;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<File, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, String> element$iv;
                Map.Entry<File, String> entry = element$iv = iterator.next();
                boolean bl = false;
                File file = entry.getKey();
                String origin = entry.getValue();
                if (!((Set)currentOrigins).contains(origin)) continue;
                generated.add(file);
            }
            currentOrigins = typeInfoProvider.invoke((Object)generated);
            allGeneratedTypes.addAll((Collection)currentOrigins);
        }
        return allGeneratedTypes;
    }

    private final boolean isJavaFileOrClass(File $this$isJavaFileOrClass) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isJavaFileOrClass), (Object)"java") || Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$isJavaFileOrClass), (Object)"class");
    }

    private final void invalidateCache() {
        this.isIncremental = false;
        this.aggregatingGenerated.clear();
        this.isolatingMapping.clear();
        this.aggregatedTypes.clear();
    }

    @NotNull
    public final String getOriginForGeneratedIsolatingType(@NotNull String generatedType, @NotNull Function1<? super String, ? extends File> sourceFileProvider) {
        Intrinsics.checkNotNullParameter((Object)generatedType, (String)"generatedType");
        Intrinsics.checkNotNullParameter(sourceFileProvider, (String)"sourceFileProvider");
        File generatedFile = (File)sourceFileProvider.invoke((Object)generatedType);
        return (String)MapsKt.getValue(this.isolatingMapping, (Object)generatedFile);
    }

    @NotNull
    public final Set<String> getAggregatingOrigins() {
        return this.aggregatedTypes;
    }

    @NotNull
    public final Set<String> getAggregatingGeneratedTypes(@NotNull Function1<? super Collection<? extends File>, ? extends Set<String>> typeInfoProvider) {
        Intrinsics.checkNotNullParameter(typeInfoProvider, (String)"typeInfoProvider");
        Set generatedAggregating = new HashSet(this.aggregatingGenerated.size());
        Iterable $this$forEach$iv = this.aggregatingGenerated;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!this.isJavaFileOrClass(it)) continue;
            generatedAggregating.add(it);
        }
        return (Set)typeInfoProvider.invoke((Object)generatedAggregating);
    }

    @NotNull
    public final Set<String> getIsolatingGeneratedTypes(@NotNull Function1<? super Collection<? extends File>, ? extends Set<String>> typeInfoProvider) {
        Intrinsics.checkNotNullParameter(typeInfoProvider, (String)"typeInfoProvider");
        Set generatedIsolating = new HashSet(this.isolatingMapping.size());
        Iterable $this$forEach$iv = this.isolatingMapping.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!this.isJavaFileOrClass(it)) continue;
            generatedIsolating.add(it);
        }
        return (Set)typeInfoProvider.invoke((Object)generatedIsolating);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RuntimeProcType.values().length];
            try {
                nArray[RuntimeProcType.AGGREGATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeProcType.ISOLATING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeProcType.NON_INCREMENTAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

