/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.io;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Nullable;

public class IdeFileUtils {
    @Nullable
    public static Path getDesktopDirectory() {
        String path;
        Path desktop = Paths.get(SystemProperties.getUserHome(), "Desktop");
        if (!Files.isDirectory(desktop, new LinkOption[0]) && SystemInfo.hasXdgOpen() && (path = ExecUtil.execAndReadLine((GeneralCommandLine)new GeneralCommandLine(new String[]{"xdg-user-dir", "DESKTOP"}))) != null) {
            desktop = Paths.get(path, new String[0]);
        }
        return Files.isDirectory(desktop, new LinkOption[0]) ? desktop : null;
    }

    @Nullable
    public static VirtualFile getDesktopDirectoryVirtualFile() {
        Path desktop = IdeFileUtils.getDesktopDirectory();
        return desktop == null ? null : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(desktop.toFile());
    }
}

