/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.cloudresourcemanager;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequest;
import com.google.api.services.cloudresourcemanager.CloudResourceManagerRequestInitializer;
import com.google.api.services.cloudresourcemanager.model.Empty;
import com.google.api.services.cloudresourcemanager.model.GetAncestryRequest;
import com.google.api.services.cloudresourcemanager.model.GetAncestryResponse;
import com.google.api.services.cloudresourcemanager.model.GetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.ListOrganizationsResponse;
import com.google.api.services.cloudresourcemanager.model.ListProjectsResponse;
import com.google.api.services.cloudresourcemanager.model.Organization;
import com.google.api.services.cloudresourcemanager.model.Policy;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.cloudresourcemanager.model.SetIamPolicyRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsRequest;
import com.google.api.services.cloudresourcemanager.model.TestIamPermissionsResponse;
import com.google.api.services.cloudresourcemanager.model.UndeleteProjectRequest;
import java.io.IOException;
import java.util.regex.Pattern;

public class CloudResourceManager
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://cloudresourcemanager.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://cloudresourcemanager.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://cloudresourcemanager.googleapis.com/";

    public CloudResourceManager(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    CloudResourceManager(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Resource Manager API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return CloudResourceManager.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://cloudresourcemanager.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), CloudResourceManager.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(CloudResourceManager.DEFAULT_BATCH_PATH);
        }

        public CloudResourceManager build() {
            return new CloudResourceManager(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setCloudResourceManagerRequestInitializer(CloudResourceManagerRequestInitializer cloudresourcemanagerRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)cloudresourcemanagerRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Create create(Project content) throws IOException {
            Create result = new Create(content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String projectId) throws IOException {
            Delete result = new Delete(projectId);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String projectId) throws IOException {
            Get result = new Get(projectId);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetAncestry getAncestry(String projectId, GetAncestryRequest content) throws IOException {
            GetAncestry result = new GetAncestry(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Undelete undelete(String projectId, UndeleteProjectRequest content) throws IOException {
            Undelete result = new Undelete(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String projectId, Project content) throws IOException {
            Update result = new Update(projectId, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Update(String projectId, Project content) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)content, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Update setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Undelete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}:undelete";
            @Key
            private String projectId;

            protected Undelete(String projectId, UndeleteProjectRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Undelete set$Xgafv(String $Xgafv) {
                return (Undelete)super.set$Xgafv($Xgafv);
            }

            public Undelete setAccessToken(String accessToken) {
                return (Undelete)super.setAccessToken(accessToken);
            }

            public Undelete setAlt(String alt) {
                return (Undelete)super.setAlt(alt);
            }

            public Undelete setCallback(String callback) {
                return (Undelete)super.setCallback(callback);
            }

            public Undelete setFields(String fields) {
                return (Undelete)super.setFields(fields);
            }

            public Undelete setKey(String key) {
                return (Undelete)super.setKey(key);
            }

            public Undelete setOauthToken(String oauthToken) {
                return (Undelete)super.setOauthToken(oauthToken);
            }

            public Undelete setPrettyPrint(Boolean prettyPrint) {
                return (Undelete)super.setPrettyPrint(prettyPrint);
            }

            public Undelete setQuotaUser(String quotaUser) {
                return (Undelete)super.setQuotaUser(quotaUser);
            }

            public Undelete setUploadType(String uploadType) {
                return (Undelete)super.setUploadType(uploadType);
            }

            public Undelete setUploadProtocol(String uploadProtocol) {
                return (Undelete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Undelete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Undelete set(String parameterName, Object value) {
                return (Undelete)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:testIamPermissions";
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:setIamPolicy";
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudResourceManagerRequest<ListProjectsResponse> {
            private static final String REST_PATH = "v1beta1/projects";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListProjectsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/projects/{resource}:getIamPolicy";
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class GetAncestry
        extends CloudResourceManagerRequest<GetAncestryResponse> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}:getAncestry";
            @Key
            private String projectId;

            protected GetAncestry(String projectId, GetAncestryRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, GetAncestryResponse.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public GetAncestry set$Xgafv(String $Xgafv) {
                return (GetAncestry)super.set$Xgafv($Xgafv);
            }

            public GetAncestry setAccessToken(String accessToken) {
                return (GetAncestry)super.setAccessToken(accessToken);
            }

            public GetAncestry setAlt(String alt) {
                return (GetAncestry)super.setAlt(alt);
            }

            public GetAncestry setCallback(String callback) {
                return (GetAncestry)super.setCallback(callback);
            }

            public GetAncestry setFields(String fields) {
                return (GetAncestry)super.setFields(fields);
            }

            public GetAncestry setKey(String key) {
                return (GetAncestry)super.setKey(key);
            }

            public GetAncestry setOauthToken(String oauthToken) {
                return (GetAncestry)super.setOauthToken(oauthToken);
            }

            public GetAncestry setPrettyPrint(Boolean prettyPrint) {
                return (GetAncestry)super.setPrettyPrint(prettyPrint);
            }

            public GetAncestry setQuotaUser(String quotaUser) {
                return (GetAncestry)super.setQuotaUser(quotaUser);
            }

            public GetAncestry setUploadType(String uploadType) {
                return (GetAncestry)super.setUploadType(uploadType);
            }

            public GetAncestry setUploadProtocol(String uploadProtocol) {
                return (GetAncestry)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetAncestry setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetAncestry set(String parameterName, Object value) {
                return (GetAncestry)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Get(String projectId) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Project.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Get setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends CloudResourceManagerRequest<Empty> {
            private static final String REST_PATH = "v1beta1/projects/{projectId}";
            @Key
            private String projectId;

            protected Delete(String projectId) {
                super(CloudResourceManager.this, "DELETE", REST_PATH, null, Empty.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public Delete setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Create
        extends CloudResourceManagerRequest<Project> {
            private static final String REST_PATH = "v1beta1/projects";
            @Key
            private Boolean useLegacyStack;

            protected Create(Project content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Project.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public Boolean getUseLegacyStack() {
                return this.useLegacyStack;
            }

            public Create setUseLegacyStack(Boolean useLegacyStack) {
                this.useLegacyStack = useLegacyStack;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }

    public class Organizations {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetIamPolicy getIamPolicy(String resource, GetIamPolicyRequest content) throws IOException {
            GetIamPolicy result = new GetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SetIamPolicy setIamPolicy(String resource, SetIamPolicyRequest content) throws IOException {
            SetIamPolicy result = new SetIamPolicy(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public TestIamPermissions testIamPermissions(String resource, TestIamPermissionsRequest content) throws IOException {
            TestIamPermissions result = new TestIamPermissions(resource, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String name, Organization content) throws IOException {
            Update result = new Update(name, content);
            CloudResourceManager.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Update(String name, Organization content) {
                super(CloudResourceManager.this, "PUT", REST_PATH, (Object)content, Organization.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Update setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class TestIamPermissions
        extends CloudResourceManagerRequest<TestIamPermissionsResponse> {
            private static final String REST_PATH = "v1beta1/{+resource}:testIamPermissions";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected TestIamPermissions(String resource, TestIamPermissionsRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, TestIamPermissionsResponse.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public TestIamPermissions set$Xgafv(String $Xgafv) {
                return (TestIamPermissions)super.set$Xgafv($Xgafv);
            }

            public TestIamPermissions setAccessToken(String accessToken) {
                return (TestIamPermissions)super.setAccessToken(accessToken);
            }

            public TestIamPermissions setAlt(String alt) {
                return (TestIamPermissions)super.setAlt(alt);
            }

            public TestIamPermissions setCallback(String callback) {
                return (TestIamPermissions)super.setCallback(callback);
            }

            public TestIamPermissions setFields(String fields) {
                return (TestIamPermissions)super.setFields(fields);
            }

            public TestIamPermissions setKey(String key) {
                return (TestIamPermissions)super.setKey(key);
            }

            public TestIamPermissions setOauthToken(String oauthToken) {
                return (TestIamPermissions)super.setOauthToken(oauthToken);
            }

            public TestIamPermissions setPrettyPrint(Boolean prettyPrint) {
                return (TestIamPermissions)super.setPrettyPrint(prettyPrint);
            }

            public TestIamPermissions setQuotaUser(String quotaUser) {
                return (TestIamPermissions)super.setQuotaUser(quotaUser);
            }

            public TestIamPermissions setUploadType(String uploadType) {
                return (TestIamPermissions)super.setUploadType(uploadType);
            }

            public TestIamPermissions setUploadProtocol(String uploadProtocol) {
                return (TestIamPermissions)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public TestIamPermissions setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public TestIamPermissions set(String parameterName, Object value) {
                return (TestIamPermissions)super.set(parameterName, value);
            }
        }

        public class SetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/{+resource}:setIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected SetIamPolicy(String resource, SetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public SetIamPolicy set$Xgafv(String $Xgafv) {
                return (SetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public SetIamPolicy setAccessToken(String accessToken) {
                return (SetIamPolicy)super.setAccessToken(accessToken);
            }

            public SetIamPolicy setAlt(String alt) {
                return (SetIamPolicy)super.setAlt(alt);
            }

            public SetIamPolicy setCallback(String callback) {
                return (SetIamPolicy)super.setCallback(callback);
            }

            public SetIamPolicy setFields(String fields) {
                return (SetIamPolicy)super.setFields(fields);
            }

            public SetIamPolicy setKey(String key) {
                return (SetIamPolicy)super.setKey(key);
            }

            public SetIamPolicy setOauthToken(String oauthToken) {
                return (SetIamPolicy)super.setOauthToken(oauthToken);
            }

            public SetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (SetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public SetIamPolicy setQuotaUser(String quotaUser) {
                return (SetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public SetIamPolicy setUploadType(String uploadType) {
                return (SetIamPolicy)super.setUploadType(uploadType);
            }

            public SetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (SetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public SetIamPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public SetIamPolicy set(String parameterName, Object value) {
                return (SetIamPolicy)super.set(parameterName, value);
            }
        }

        public class List
        extends CloudResourceManagerRequest<ListOrganizationsResponse> {
            private static final String REST_PATH = "v1beta1/organizations";
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List() {
                super(CloudResourceManager.this, "GET", REST_PATH, null, ListOrganizationsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetIamPolicy
        extends CloudResourceManagerRequest<Policy> {
            private static final String REST_PATH = "v1beta1/{+resource}:getIamPolicy";
            private final Pattern RESOURCE_PATTERN;
            @Key
            private String resource;

            protected GetIamPolicy(String resource, GetIamPolicyRequest content) {
                super(CloudResourceManager.this, "POST", REST_PATH, (Object)content, Policy.class);
                this.RESOURCE_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.resource = (String)Preconditions.checkNotNull((Object)resource, (Object)"Required parameter resource must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public GetIamPolicy set$Xgafv(String $Xgafv) {
                return (GetIamPolicy)super.set$Xgafv($Xgafv);
            }

            public GetIamPolicy setAccessToken(String accessToken) {
                return (GetIamPolicy)super.setAccessToken(accessToken);
            }

            public GetIamPolicy setAlt(String alt) {
                return (GetIamPolicy)super.setAlt(alt);
            }

            public GetIamPolicy setCallback(String callback) {
                return (GetIamPolicy)super.setCallback(callback);
            }

            public GetIamPolicy setFields(String fields) {
                return (GetIamPolicy)super.setFields(fields);
            }

            public GetIamPolicy setKey(String key) {
                return (GetIamPolicy)super.setKey(key);
            }

            public GetIamPolicy setOauthToken(String oauthToken) {
                return (GetIamPolicy)super.setOauthToken(oauthToken);
            }

            public GetIamPolicy setPrettyPrint(Boolean prettyPrint) {
                return (GetIamPolicy)super.setPrettyPrint(prettyPrint);
            }

            public GetIamPolicy setQuotaUser(String quotaUser) {
                return (GetIamPolicy)super.setQuotaUser(quotaUser);
            }

            public GetIamPolicy setUploadType(String uploadType) {
                return (GetIamPolicy)super.setUploadType(uploadType);
            }

            public GetIamPolicy setUploadProtocol(String uploadProtocol) {
                return (GetIamPolicy)super.setUploadProtocol(uploadProtocol);
            }

            public String getResource() {
                return this.resource;
            }

            public GetIamPolicy setResource(String resource) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(resource).matches(), (Object)"Parameter resource must conform to the pattern ^organizations/[^/]+$");
                }
                this.resource = resource;
                return this;
            }

            @Override
            public GetIamPolicy set(String parameterName, Object value) {
                return (GetIamPolicy)super.set(parameterName, value);
            }
        }

        public class Get
        extends CloudResourceManagerRequest<Organization> {
            private static final String REST_PATH = "v1beta1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String organizationId;

            protected Get(String name) {
                super(CloudResourceManager.this, "GET", REST_PATH, null, Organization.class);
                this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!CloudResourceManager.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getOrganizationId() {
                return this.organizationId;
            }

            public Get setOrganizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }
}

