/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.okhttp;

import aida.io.grpc.ChannelCredentials;
import aida.io.grpc.Internal;
import aida.io.grpc.InternalServiceProviders;
import aida.io.grpc.ManagedChannelProvider;
import aida.io.grpc.okhttp.OkHttpChannelBuilder;
import java.net.SocketAddress;
import java.util.Collection;

@Internal
public final class OkHttpChannelProvider
extends ManagedChannelProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return InternalServiceProviders.isAndroid(this.getClass().getClassLoader()) ? 8 : 3;
    }

    public OkHttpChannelBuilder builderForAddress(String name, int port) {
        return OkHttpChannelBuilder.forAddress(name, port);
    }

    public OkHttpChannelBuilder builderForTarget(String target) {
        return OkHttpChannelBuilder.forTarget(target);
    }

    @Override
    public ManagedChannelProvider.NewChannelBuilderResult newChannelBuilder(String target, ChannelCredentials creds) {
        OkHttpChannelBuilder.SslSocketFactoryResult result = OkHttpChannelBuilder.sslSocketFactoryFrom(creds);
        if (result.error != null) {
            return ManagedChannelProvider.NewChannelBuilderResult.error(result.error);
        }
        return ManagedChannelProvider.NewChannelBuilderResult.channelBuilder(new OkHttpChannelBuilder(target, creds, result.callCredentials, result.factory));
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getSupportedSocketAddressTypes() {
        return OkHttpChannelBuilder.getSupportedSocketAddressTypes();
    }
}

