/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.CidrPluginPathMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrPathManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + CidrPathManager.class.getPackage().getName()));
    private static volatile Path ourCidrRootPath;
    private static final Map<Class<?>, Ref<Path>> ourPluginPathsCache;
    private static final Map<String, Ref<Path>> ourPluginPathsByIdCache;
    private static final Set<Path> ourFileWithExecutableUpdated;

    public static Path getCidrSourcesRoot() {
        if (ourCidrRootPath == null) {
            String homePath = null;
            if (AppMode.isDevServer()) {
                homePath = AppMode.getDevIdeaProjectDir();
            }
            if (homePath == null) {
                homePath = PathManager.getHomePath();
            }
            ourCidrRootPath = Paths.get(homePath, System.getProperty("cidr.root.path", "CIDR")).normalize();
        }
        return ourCidrRootPath;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath, boolean archSpecific) {
        if (platformPath == null) {
            CidrPathManager.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(1);
        }
        String string = platformPath + "/" + (String)(archSpecific ? (CpuArch.isArm64() ? "aarch64" : "x64") + "/" : "") + relativePath;
        if (string == null) {
            CidrPathManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String platformPath, @NonNls @NotNull String relativePath) {
        if (platformPath == null) {
            CidrPathManager.$$$reportNull$$$0(3);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(4);
        }
        return CidrPathManager.getPlatformRelativePath(platformPath, relativePath, true);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath, boolean archSpecific) {
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(5);
        }
        return CidrPathManager.getPlatformRelativePath(SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "mac" : "linux"), relativePath, archSpecific);
    }

    @NlsSafe
    @NotNull
    public static String getPlatformRelativePath(@NonNls @NotNull String relativePath) {
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(6);
        }
        return CidrPathManager.getPlatformRelativePath(relativePath, true);
    }

    @NotNull
    public static File getBinFile(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        if (clazz == null) {
            CidrPathManager.$$$reportNull$$$0(7);
        }
        if (inSourcesPath == null) {
            CidrPathManager.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(9);
        }
        File file = CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries).toFile();
        if (file == null) {
            CidrPathManager.$$$reportNull$$$0(10);
        }
        return file;
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries) {
        if (clazz == null) {
            CidrPathManager.$$$reportNull$$$0(11);
        }
        if (inSourcesPath == null) {
            CidrPathManager.$$$reportNull$$$0(12);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(13);
        }
        return CidrPathManager.getBinPath(clazz, inSourcesPath, relativePath, relativePathToAdditionalBinaries, true);
    }

    @NotNull
    public static Path getBinPath(@NotNull Class<?> clazz, @NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @NonNls @Nullable String relativePathToAdditionalBinaries, boolean ensureIsExecutable) {
        if (clazz == null) {
            CidrPathManager.$$$reportNull$$$0(14);
        }
        if (inSourcesPath == null) {
            CidrPathManager.$$$reportNull$$$0(15);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(16);
        }
        Path pluginPath = null;
        if (CidrPathManager.lookForBinariesInsidePlugin()) {
            pluginPath = CidrPathManager.getPluginPath(clazz);
        }
        Path basePath = null;
        if (pluginPath != null) {
            basePath = pluginPath.resolve("bin");
        } else if (PluginManagerCore.isRunningFromSources() || AppMode.isDevServer()) {
            basePath = CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
        }
        if ((basePath == null || !Files.isDirectory(basePath, new LinkOption[0])) && CidrPathManager.lookForBinariesInsidePlugin()) {
            String pluginId = CidrPathManager.getMappedPluginId(clazz);
            if (pluginId != null && (pluginPath = CidrPathManager.getPluginPath(pluginId)) != null) {
                basePath = pluginPath.resolve("bin");
            }
            basePath = CidrPathManager.getCidrFallbackPathIfResourceNotFound(inSourcesPath, relativePath, basePath);
        }
        if (basePath != null) {
            Path result = basePath.resolve(relativePath);
            if (ensureIsExecutable) {
                CidrPathManager.ensureFileIsExecutable(result);
                if (relativePathToAdditionalBinaries != null) {
                    CidrPathManager.ensureFilesInDirAreExecutable(basePath.resolve(relativePathToAdditionalBinaries));
                }
            }
            Path path = result;
            if (path == null) {
                CidrPathManager.$$$reportNull$$$0(17);
            }
            return path;
        }
        Path path = Paths.get(PathManager.getBinPath(), relativePath);
        if (path == null) {
            CidrPathManager.$$$reportNull$$$0(18);
        }
        return path;
    }

    private static Path getCidrFallbackPathIfResourceNotFound(@NonNls @NotNull String inSourcesPath, @NonNls @NotNull String relativePath, @Nullable Path basePath) {
        if (inSourcesPath == null) {
            CidrPathManager.$$$reportNull$$$0(19);
        }
        if (relativePath == null) {
            CidrPathManager.$$$reportNull$$$0(20);
        }
        if (basePath != null && Files.exists(basePath.resolve(relativePath), new LinkOption[0])) {
            return basePath;
        }
        basePath = Paths.get(PathManager.getHomePath((boolean)false), new String[0]).resolve("CIDR").resolve(inSourcesPath);
        if (Files.exists(basePath.resolve(relativePath), new LinkOption[0])) {
            return basePath;
        }
        return CidrPathManager.getCidrSourcesRoot().resolve(inSourcesPath);
    }

    private static void ensureFilesInDirAreExecutable(@NotNull Path dir) {
        if (dir == null) {
            CidrPathManager.$$$reportNull$$$0(21);
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path child : stream) {
                CidrPathManager.ensureFileIsExecutable(child);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static Path ensureFileIsExecutable(@NotNull Path file) {
        if (file == null) {
            CidrPathManager.$$$reportNull$$$0(22);
        }
        if (ourFileWithExecutableUpdated.contains(file)) {
            Path path = file;
            if (path == null) {
                CidrPathManager.$$$reportNull$$$0(23);
            }
            return path;
        }
        if (Files.isRegularFile(file, new LinkOption[0]) && !Files.isExecutable(file)) {
            LOG.info("Setting executable flag for " + file);
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.GROUP_EXECUTE);
            try {
                perms.addAll(Files.getPosixFilePermissions(file, new LinkOption[0]));
                Files.setPosixFilePermissions(file, perms);
            }
            catch (IOException e) {
                LOG.warn("Cannot set executable flag for " + file, (Throwable)e);
            }
        }
        ourFileWithExecutableUpdated.add(file);
        Path path = file;
        if (path == null) {
            CidrPathManager.$$$reportNull$$$0(24);
        }
        return path;
    }

    private static boolean lookForBinariesInsidePlugin() {
        return !PlatformUtils.isCidr() && !PlatformUtils.isRustRover();
    }

    @Nullable
    private static Path getPluginPath(@NotNull Class<?> clazz) {
        Ref result;
        if (clazz == null) {
            CidrPathManager.$$$reportNull$$$0(25);
        }
        if ((result = ourPluginPathsCache.get(clazz)) == null) {
            PluginId id;
            IdeaPluginDescriptor plugin;
            result = new Ref();
            ClassLoader loader = clazz.getClassLoader();
            if (loader instanceof PluginAwareClassLoader && (plugin = PluginManagerCore.getPlugin((PluginId)(id = ((PluginAwareClassLoader)loader).getPluginId()))) != null) {
                result.set((Object)plugin.getPluginPath());
            }
            ourPluginPathsCache.putIfAbsent(clazz, (Ref<Path>)result);
        }
        return (Path)result.get();
    }

    @Nullable
    private static String getMappedPluginId(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrPathManager.$$$reportNull$$$0(26);
        }
        for (CidrPluginPathMapper mapper : CidrPluginPathMapper.EP_NAME.getExtensionList()) {
            String pluginId = mapper.getPluginId(clazz);
            if (pluginId == null) continue;
            return pluginId;
        }
        return null;
    }

    private static Path getPluginPath(@NotNull String pluginId) {
        Ref result;
        if (pluginId == null) {
            CidrPathManager.$$$reportNull$$$0(27);
        }
        if ((result = ourPluginPathsByIdCache.get(pluginId)) == null) {
            result = new Ref();
            IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)pluginId));
            if (plugin != null) {
                result.set((Object)plugin.getPluginPath());
            }
            ourPluginPathsByIdCache.putIfAbsent(pluginId, (Ref<Path>)result);
        }
        return (Path)result.get();
    }

    static {
        ourPluginPathsCache = new ConcurrentHashMap();
        ourPluginPathsByIdCache = new ConcurrentHashMap<String, Ref<Path>>();
        ourFileWithExecutableUpdated = ConcurrentCollectionFactory.createConcurrentSet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 17, 18, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 8: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inSourcesPath";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrPathManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformRelativePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinPath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFileIsExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformRelativePath";
                break;
            }
            case 2: 
            case 10: 
            case 17: 
            case 18: 
            case 23: 
            case 24: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBinFile";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getBinPath";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCidrFallbackPathIfResourceNotFound";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesInDirAreExecutable";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ensureFileIsExecutable";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getPluginPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMappedPluginId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 17, 18, 23, 24 -> new IllegalStateException(string);
        };
    }
}

