/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Alarm;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModuleMemory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtilKt;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerDisasmDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrDisasmOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.disasm.CidrDisasmRegion;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegionFactory;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpFileType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\tH\u0086\u0002R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModuleMemory;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/openapi/Disposable;)V", "disasmDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "getDisasmDoc", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "disasmDoc$delegate", "Lkotlin/Lazy;", "hexdumpDoc", "", "getHexdumpDoc", "hexdumpDoc$delegate", "contains", "", "memoryDoc", "Companion", "intellij.cidr.debugger"})
public final class CidrDebuggerModuleMemory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy disasmDoc$delegate;
    @NotNull
    private final Lazy hexdumpDoc$delegate;
    @JvmField
    @NotNull
    public static final Key<String> DISASM_ARCH;
    @JvmField
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> MEMORY_DOCS_ENABLED;

    public CidrDebuggerModuleMemory(@NotNull CidrDebugProcess process, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.disasmDoc$delegate = LazyKt.lazy(() -> CidrDebuggerModuleMemory.disasmDoc_delegate$lambda$1(process, parentDisposable));
        this.hexdumpDoc$delegate = LazyKt.lazy(() -> CidrDebuggerModuleMemory.hexdumpDoc_delegate$lambda$3(process, parentDisposable));
    }

    @NotNull
    public final CidrMemoryDoc<LLInstruction> getDisasmDoc() {
        Lazy lazy = this.disasmDoc$delegate;
        return (CidrMemoryDoc)lazy.getValue();
    }

    @NotNull
    public final CidrMemoryDoc<Byte> getHexdumpDoc() {
        Lazy lazy = this.hexdumpDoc$delegate;
        return (CidrMemoryDoc)lazy.getValue();
    }

    public final boolean contains(@NotNull CidrMemoryDoc<?> memoryDoc) {
        Intrinsics.checkNotNullParameter(memoryDoc, (String)"memoryDoc");
        return memoryDoc == this.getDisasmDoc() || memoryDoc == this.getHexdumpDoc();
    }

    private static final CidrMemoryDoc disasmDoc_delegate$lambda$1(CidrDebugProcess $process, Disposable $parentDisposable) {
        CidrMemoryDoc<LLInstruction> cidrMemoryDoc;
        Project project = $process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        Project project2 = project;
        XDebugSession xDebugSession = $process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session = xDebugSession;
        CidrMemoryData.DataProvider dataProvider = new CidrDebuggerDisasmDataProvider($process);
        CidrMemoryDoc.DocRegionFactory docRegionFactory = CidrDisasmRegion.Companion;
        DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)disasmFileType), (String)"INSTANCE");
        FileType fileType = (FileType)disasmFileType;
        String string = session.getSessionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
        String string2 = CidrDebuggerBundle.message("debug.disasm.editorTabDescription", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CidrMemoryDoc<LLInstruction> memoryDoc = cidrMemoryDoc = new CidrMemoryDoc<LLInstruction>(project2, $parentDisposable, dataProvider, docRegionFactory, fileType, string, string2, new CidrDisasmOptions(session));
        boolean bl = false;
        memoryDoc.getVirtualFile().putUserData(CidrDebugProcess.DEBUG_PROCESS_KEY, $process);
        if (Companion.memoryDocsEnabled(session)) {
            session.addSessionListener(new XDebugSessionListener(memoryDoc, project2, $process){
                final /* synthetic */ CidrMemoryDoc<LLInstruction> $memoryDoc;
                final /* synthetic */ Project $project;
                final /* synthetic */ CidrDebugProcess $process;
                {
                    this.$memoryDoc = $memoryDoc;
                    this.$project = $project;
                    this.$process = $process;
                }

                public void sessionResumed() {
                    CidrMemoryDoc.cleanupErrors$default(this.$memoryDoc, null, 1, null);
                    this.update();
                }

                public void sessionStopped() {
                    if (!this.$project.isDisposed()) {
                        FileEditorManager.getInstance((Project)this.$project).updateFilePresentation((VirtualFile)this.$memoryDoc.getVirtualFile());
                        this.update();
                    }
                }

                public void sessionPaused() {
                    this.initDisasmArch();
                    this.update();
                }

                private final void initDisasmArch() {
                    String arch = (String)CidrDebuggerModuleMemory.DISASM_ARCH.get((UserDataHolder)this.$memoryDoc.getVirtualFile());
                    if (arch == null) {
                        this.$process.postCommand(arg_0 -> disasmDoc.2.1.1.initDisasmArch$lambda$0(this.$memoryDoc, arg_0));
                    }
                }

                public void stackFrameChanged() {
                    this.update();
                }

                public void settingsChanged() {
                    this.update();
                }

                private final void update() {
                    EditorNotifications.getInstance((Project)this.$project).updateNotifications((VirtualFile)this.$memoryDoc.getVirtualFile());
                }

                private static final Unit initDisasmArch$lambda$0(CidrMemoryDoc $memoryDoc, DebuggerDriver driver) {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                    try {
                        string = driver.getArchitecture();
                    }
                    catch (DebuggerCommandException e) {
                        CidrDebuggerLog.LOG.warn("Failed to initialize architecture for disasm", (Throwable)e);
                        string = null;
                    }
                    String processArch = string;
                    UserDataHolder userDataHolder = (UserDataHolder)$memoryDoc.getVirtualFile();
                    String string2 = processArch;
                    if (string2 == null) {
                        string2 = "";
                    }
                    CidrDebuggerModuleMemory.DISASM_ARCH.set(userDataHolder, (Object)string2);
                    CidrDebuggerUsagesCollector.INSTANCE.logProcessArchitecture(processArch);
                    return Unit.INSTANCE;
                }
            }, $parentDisposable);
            if ($process.supportsRegisters()) {
                MessageBusConnection messageBusConnection = session.getProject().getMessageBus().connect($parentDisposable);
                Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
                Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
                messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(memoryDoc, session){
                    final /* synthetic */ CidrMemoryDoc<LLInstruction> $memoryDoc;
                    final /* synthetic */ XDebugSession $session;
                    {
                        this.$memoryDoc = $memoryDoc;
                        this.$session = $session;
                    }

                    public void fileClosed(FileEditorManager source, VirtualFile file) {
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        if (Intrinsics.areEqual((Object)file, (Object)((Object)this.$memoryDoc.getVirtualFile()))) {
                            CidrStackFrame cidrStackFrame = CidrDebuggerUtilKt.getCidrCurrentStackFrame(this.$session);
                            if (cidrStackFrame == null) {
                                return;
                            }
                            CidrStackFrame frame = cidrStackFrame;
                            frame.setShowsRegisters(false);
                        }
                    }

                    public void selectionChanged(FileEditorManagerEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        if (!Intrinsics.areEqual((Object)event.getNewFile(), (Object)((Object)this.$memoryDoc.getVirtualFile()))) {
                            return;
                        }
                        if (!this.$session.isSuspended()) {
                            return;
                        }
                        CidrStackFrame cidrStackFrame = CidrDebuggerUtilKt.getCidrCurrentStackFrame(this.$session);
                        if (cidrStackFrame == null) {
                            return;
                        }
                        CidrStackFrame frame = cidrStackFrame;
                        if (!frame.isShowsRegisters() || Registry.Companion.is("cidr.debugger.showInlineRegistersInDisasm")) {
                            this.$session.rebuildViews();
                        }
                    }
                });
            }
        }
        return cidrMemoryDoc;
    }

    private static final CidrMemoryDoc hexdumpDoc_delegate$lambda$3(CidrDebugProcess $process, Disposable $parentDisposable) {
        CidrMemoryDoc<Byte> cidrMemoryDoc;
        CidrHexdumpRegionFactory hexdumpRegionFactory = new CidrHexdumpRegionFactory();
        Project project = $process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        CidrMemoryData.DataProvider dataProvider = new CidrDebuggerHexdumpDataProvider($process);
        CidrMemoryDoc.DocRegionFactory docRegionFactory = hexdumpRegionFactory;
        HexdumpFileType hexdumpFileType = HexdumpFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)hexdumpFileType), (String)"INSTANCE");
        FileType fileType = (FileType)hexdumpFileType;
        String string = $process.getSession().getSessionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSessionName(...)");
        String string2 = CidrDebuggerBundle.message("debug.hexdump.editorTabDescription", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        CidrMemoryDoc<Byte> memoryDoc = cidrMemoryDoc = new CidrMemoryDoc<Byte>(project, $parentDisposable, dataProvider, docRegionFactory, fileType, string, string2, new CidrHexdumpOptions());
        boolean bl = false;
        memoryDoc.getVirtualFile().putUserData(CidrDebugProcess.DEBUG_PROCESS_KEY, $process);
        XDebugSession xDebugSession = $process.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        if (Companion.memoryDocsEnabled(xDebugSession)) {
            $process.getSession().addSessionListener(new XDebugSessionListener($parentDisposable, memoryDoc, hexdumpRegionFactory, $process){
                private final int MARK_OUTDATED_DELAY_MS;
                private final Alarm alarm;
                final /* synthetic */ CidrMemoryDoc<Byte> $memoryDoc;
                final /* synthetic */ CidrHexdumpRegionFactory $hexdumpRegionFactory;
                final /* synthetic */ CidrDebugProcess $process;
                {
                    this.$memoryDoc = $memoryDoc;
                    this.$hexdumpRegionFactory = $hexdumpRegionFactory;
                    this.$process = $process;
                    this.MARK_OUTDATED_DELAY_MS = 300;
                    this.alarm = new Alarm($parentDisposable);
                }

                public final int getMARK_OUTDATED_DELAY_MS() {
                    return this.MARK_OUTDATED_DELAY_MS;
                }

                public final Alarm getAlarm() {
                    return this.alarm;
                }

                public void sessionResumed() {
                    CidrMemoryDoc.cleanupErrors$default(this.$memoryDoc, null, 1, null);
                    this.alarm.addRequest(() -> hexdumpDoc.2.1.1.sessionResumed$lambda$0(this.$memoryDoc), this.MARK_OUTDATED_DELAY_MS);
                }

                public void sessionPaused() {
                    this.$hexdumpRegionFactory.startHighlightingSession();
                    this.alarm.cancelAllRequests();
                }

                public void sessionStopped() {
                    if (!this.$process.getProject().isDisposed()) {
                        FileEditorManager.getInstance((Project)this.$process.getProject()).updateFilePresentation((VirtualFile)this.$memoryDoc.getVirtualFile());
                    }
                }

                private static final void sessionResumed$lambda$0(CidrMemoryDoc $memoryDoc) {
                    CidrMemoryDoc.markOutdated$default($memoryDoc, null, 1, null);
                }
            });
        }
        return cidrMemoryDoc;
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean memoryDocsEnabled(@NotNull XDebugSession $this$memoryDocsEnabled) {
        return Companion.memoryDocsEnabled($this$memoryDocsEnabled);
    }

    static {
        Key key = Key.create((String)"cidr.debugger.disasm.arch");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        DISASM_ARCH = key;
        Key key2 = Key.create((String)"Disasm functionality switcher");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        MEMORY_DOCS_ENABLED = key2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0007R\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModuleMemory$Companion;", "", "<init>", "()V", "DISASM_ARCH", "Lcom/intellij/openapi/util/Key;", "", "MEMORY_DOCS_ENABLED", "", "memoryDocsEnabled", "Lcom/intellij/xdebugger/XDebugSession;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @ApiStatus.Internal
        public final boolean memoryDocsEnabled(@NotNull XDebugSession $this$memoryDocsEnabled) {
            ExecutionEnvironment env;
            Intrinsics.checkNotNullParameter((Object)$this$memoryDocsEnabled, (String)"<this>");
            XDebugSessionImpl xDebugSessionImpl = $this$memoryDocsEnabled instanceof XDebugSessionImpl ? (XDebugSessionImpl)$this$memoryDocsEnabled : null;
            ExecutionEnvironment executionEnvironment = env = xDebugSessionImpl != null ? xDebugSessionImpl.getExecutionEnvironment() : null;
            return !(executionEnvironment != null ? Intrinsics.areEqual((Object)executionEnvironment.getUserData(MEMORY_DOCS_ENABLED), (Object)false) : false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

