/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.CidrPathManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrDebuggerPathManager {
    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePathToMainFile, @Nullable String relativePathToAdditionalBinaries, boolean archSpecific) {
        if (relativePathToMainFile == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(0);
        }
        return CidrDebuggerPathManager.getBinFile("lldb/" + CidrPathManager.getPlatformRelativePath(relativePathToMainFile, archSpecific), relativePathToAdditionalBinaries == null ? null : "lldb/" + CidrPathManager.getPlatformRelativePath(relativePathToAdditionalBinaries, archSpecific));
    }

    @NotNull
    public static File getLLDBBinFile(@NotNull String relativePathToMainFile, @Nullable String relativePathToAdditionalBinaries) {
        if (relativePathToMainFile == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(1);
        }
        return CidrDebuggerPathManager.getLLDBBinFile(relativePathToMainFile, relativePathToAdditionalBinaries, false);
    }

    @NotNull
    public static File getBundledLLDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("lldb/renderers");
    }

    @NotNull
    public static File getBundledGDBBinary() {
        String platformBin = "gdb/" + CidrPathManager.getPlatformRelativePath("bin");
        return CidrDebuggerPathManager.getBinFile(platformBin + "/" + (SystemInfo.isWindows ? "gdb.exe" : "gdb"), platformBin);
    }

    @NotNull
    public static File getWinbreakFile(@NotNull String name) {
        if (name == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(2);
        }
        return CidrDebuggerPathManager.getBinFile("gdb/" + CidrPathManager.getPlatformRelativePath("bin") + "/" + name);
    }

    @NotNull
    public static File getBundledGDBSTLPrettyPrinters() {
        return CidrDebuggerPathManager.getBinFile("gdb/renderers");
    }

    @NotNull
    public static File getBundledQtPrinters() {
        return CidrDebuggerPathManager.getBinFile("qt");
    }

    @NotNull
    private static File getBinFile(String relativePath) {
        return CidrDebuggerPathManager.getBinFile(relativePath, null);
    }

    @NotNull
    private static File getBinFile(String relativePath, @Nullable String relativePathToAdditionalBinaries) {
        File file = CidrPathManager.getBinPath(CidrDebuggerPathManager.class, "cidr-debugger/bin", relativePath, relativePathToAdditionalBinaries).toFile();
        if (file == null) {
            CidrDebuggerPathManager.$$$reportNull$$$0(3);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePathToMainFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrDebuggerPathManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLLDBBinFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWinbreakFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

