/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerModulesHandler;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerQtSupportKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.LLModule;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerQtModulesDetector;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerModulesHandler;", "<init>", "()V", "handleModulesLoaded", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "modules", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLModule;", "isQtModule", "", "module", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrDebuggerQtSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDebuggerQtSupport.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebuggerQtModulesDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1755#2,3:35\n*S KotlinDebug\n*F\n+ 1 CidrDebuggerQtSupport.kt\ncom/jetbrains/cidr/execution/debugger/CidrDebuggerQtModulesDetector\n*L\n17#1:35,3\n*E\n"})
public final class CidrDebuggerQtModulesDetector
implements CidrDebuggerModulesHandler {
    @Override
    public void handleModulesLoaded(@NotNull CidrDebugProcess process, @NotNull List<LLModule> modules) {
        boolean qtModuleLoaded;
        block4: {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Iterable $this$any$iv = modules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LLModule it = (LLModule)element$iv;
                    boolean bl = false;
                    if (!this.isQtModule(it)) continue;
                    v0 = true;
                    break block4;
                }
                v0 = qtModuleLoaded = false;
            }
        }
        if (!qtModuleLoaded) {
            return;
        }
        boolean isSupported = process.supportsQtRenderers();
        boolean isEnabled = CidrDebuggerSettings.getInstance().isQtRenderersEnabled();
        Project project = process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        String string = process.getDriverName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDriverName(...)");
        CidrDebuggerUsagesCollector.logQtLibraryDetected(project, string, isSupported, isEnabled, true);
    }

    private final boolean isQtModule(LLModule module) {
        String path = module.getPath();
        return CidrDebuggerQtSupportKt.access$getLibQtLinuxPattern$p().matches((CharSequence)path) || StringsKt.endsWith$default((String)path, (String)"\\Qt5Core.dll", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"\\Qt6Core.dll", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)path, (String)"/QtCore", (boolean)false, (int)2, null);
    }
}

