/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.DslConfigurableBase;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.MutableProperty;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.util.UiSizeUtilKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettingsConfigurableKt;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J:\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0004\u0012\u00020\u000e0\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettingsConfigurable;", "Lcom/intellij/openapi/options/DslConfigurableBase;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "settings", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;)V", "getDisplayName", "", "getHelpTopic", "getId", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "buildDirectoriesTable", "", "Lcom/intellij/ui/dsl/builder/Row;", "getValuesFromSettings", "Lkotlin/Function0;", "", "Ljava/nio/file/Path;", "saveValuesToSettings", "Lkotlin/Function1;", "showSelectDirectoryDialog", "parent", "Ljava/awt/Component;", "intellij.cidr.debugger"})
public final class CidrDebuggerSettingsConfigurable
extends DslConfigurableBase
implements SearchableConfigurable {
    @NotNull
    private final CidrDebuggerSettings settings;

    public CidrDebuggerSettingsConfigurable(@NotNull CidrDebuggerSettings settings) {
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.settings = settings;
    }

    @NotNull
    public String getDisplayName() {
        String string;
        boolean bl = CidrDebuggerSettingsConfigurableKt.access$getPRESENT_AS_OBJC$p();
        if (bl) {
            String string2 = CidrDebuggerBundle.message("debug.settings.name.objective.c", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (!bl) {
            String string3 = CidrDebuggerBundle.message("debug.settings.name.c.cpp", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getHelpTopic() {
        String string;
        boolean bl = CidrDebuggerSettingsConfigurableKt.access$getPRESENT_AS_OBJC$p();
        if (bl) {
            string = "reference.idesettings.debugger.objectivec";
        } else if (!bl) {
            string = "reference.idesettings.debugger.cpp";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @NotNull
    public String getId() {
        return "Debugger.ObjectiveC";
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32(this, arg_0));
    }

    private final void buildDirectoriesTable(Row $this$buildDirectoriesTable, Function0<? extends List<? extends Path>> getValuesFromSettings, Function1<? super List<? extends Path>, Unit> saveValuesToSettings) {
        CollectionListModel model = new CollectionListModel((List)getValuesFromSettings.invoke());
        JBList list = new JBList((ListModel)model);
        list.setEmptyText(CidrDebuggerBundle.message("debug.settings.enableLLDBNatvisRenderers.noCustomLocations", new Object[0]));
        JPanel jPanel = ToolbarDecorator.createDecorator((JList)((JList)list)).setAddAction(arg_0 -> CidrDebuggerSettingsConfigurable.buildDirectoriesTable$lambda$33(this, list, model, arg_0)).setRemoveAction(arg_0 -> CidrDebuggerSettingsConfigurable.buildDirectoriesTable$lambda$34(model, list, arg_0)).setPreferredSize(new Dimension(UiSizeUtilKt.getPreferredWidth((JComponent)((JComponent)list)), JBUI.scale((int)60))).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel component = jPanel;
        $this$buildDirectoriesTable.cell((JComponent)component).align(Align.FILL).onApply(() -> CidrDebuggerSettingsConfigurable.buildDirectoriesTable$lambda$35(saveValuesToSettings, model)).onIsModified(() -> CidrDebuggerSettingsConfigurable.buildDirectoriesTable$lambda$36(getValuesFromSettings, model)).onReset(() -> CidrDebuggerSettingsConfigurable.buildDirectoriesTable$lambda$37(model, getValuesFromSettings));
    }

    private final Path showSelectDirectoryDialog(Component parent) {
        VirtualFile chosenFile;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(CidrDebuggerBundle.message("debug.settings.selectDirectoryDialog.title", new Object[0]));
        VirtualFile virtualFile = chosenFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Component)parent, null, null);
        return virtualFile != null ? virtualFile.toNioPath() : null;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$0(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableGNUSTLRenderers.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isStlRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setStlRenderersEnabled(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$1(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.qtRenderers.enableQtRenderers", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isQtRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setQtRenderersEnabled(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$2(Ref.ObjectRef $natvisRenderers, CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableLLDBNatvisRenderers.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $natvisRenderers.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string).gap(RightGap.SMALL), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isLLDBNatvisRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setLLDBNatvisRenderersEnabled(p0);
            }
        }));
        Object[] objectArray = new Object[]{ApplicationNamesInfo.getInstance().getProductName()};
        String string2 = CidrDebuggerBundle.message("debug.settings.enableLLDBNatvisRenderers.checkbox.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.contextHelp$default((Row)$this$row, (String)string2, null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableLLDBNatvisRenderers.customLocations", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final List createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6$lambda$4(NatvisSettings $natvisSettings) {
        return $natvisSettings.getSearchPaths();
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6$lambda$5(NatvisSettings $natvisSettings, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $natvisSettings.setSearchPaths(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        NatvisSettings natvisSettings = NatvisSettings.Companion.getInstance();
        this$0.buildDirectoriesTable($this$row, (Function0<? extends List<? extends Path>>)((Function0)() -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6$lambda$4(natvisSettings)), (Function1<? super List<? extends Path>, Unit>)((Function1)arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6$lambda$5(natvisSettings, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$7(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableLLDBNatvisRenderers.diagnostics", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string).gap(RightGap.SMALL);
        ComboBoxKt.bindItem((Cell)Row.comboBox$default((Row)$this$row, (ComboBoxModel)((ComboBoxModel)new EnumComboBoxModel(LLDBNatvisDiagnosticsLevel.class)), null, (int)2, null), (MutableProperty)MutablePropertyKt.MutableProperty((Function0)((Function0)new Function0<LLDBNatvisDiagnosticsLevel>((Object)this$0.settings){

            public final LLDBNatvisDiagnosticsLevel invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).getLLDBNatvisDiagnosticsLevel();
            }
        }), (Function1)((Function1)new Function1<LLDBNatvisDiagnosticsLevel, Unit>((Object)this$0.settings){

            public final void invoke(LLDBNatvisDiagnosticsLevel p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setLLDBNatvisDiagnosticsLevel(p0);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8(CidrDebuggerSettingsConfigurable this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, CidrDebuggerSettingsConfigurable::createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$3, (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$6(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8$lambda$7(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$9(Ref.ObjectRef $natvisRenderers, CidrDebuggerSettingsConfigurable this$0, Panel $this$rowsRange) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$2($natvisRenderers, this$0, arg_0), (int)1, null);
        RowsRange rowsRange = $this$rowsRange.indent(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9$lambda$8(this$0, arg_0));
        if ($natvisRenderers.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"natvisRenderers");
            cell = null;
        } else {
            cell = (Cell)$natvisRenderers.element;
        }
        rowsRange.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$10(Ref.ObjectRef $renderers, CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableValueRenderers.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $renderers.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setRenderersEnabled(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$11(Ref.ObjectRef $cocoaRenderers, CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $renderers, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableCocoaRenderers.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isCocoaRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setCocoaRenderersEnabled(p0);
            }
        }));
        if ($renderers.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderers");
            cell = null;
        } else {
            cell = (Cell)$renderers.element;
        }
        $cocoaRenderers.element = cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$13$lambda$12(CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $renderers, Ref.ObjectRef $cocoaRenderers, Row $this$row) {
        Cell cell;
        Cell cell2;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableCoreDataRenderers.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell3 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isCoreDataRenderersEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setCoreDataRenderersEnabled(p0);
            }
        }));
        if ($renderers.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"renderers");
            cell2 = null;
        } else {
            cell2 = (Cell)$renderers.element;
        }
        ComponentPredicate componentPredicate = ButtonKt.getSelected((Cell)cell2);
        if ($cocoaRenderers.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cocoaRenderers");
            cell = null;
        } else {
            cell = (Cell)$cocoaRenderers.element;
        }
        cell3.enabledIf(ComponentPredicateKt.and((ComponentPredicate)componentPredicate, (ComponentPredicate)ButtonKt.getSelected((Cell)cell)));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$13(CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $renderers, Ref.ObjectRef $cocoaRenderers, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$13$lambda$12(this$0, $renderers, $cocoaRenderers, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14(Ref.ObjectRef $cocoaRenderers, CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $renderers, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$11($cocoaRenderers, this$0, $renderers, arg_0), (int)1, null);
        $this$indent.indent(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14$lambda$13(this$0, $renderers, $cocoaRenderers, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$15(Ref.ObjectRef $renderers, CidrDebuggerSettingsConfigurable this$0, Panel $this$rowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$10($renderers, this$0, arg_0), (int)1, null);
        Ref.ObjectRef cocoaRenderers = new Ref.ObjectRef();
        $this$rowsRange.indent(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15$lambda$14(cocoaRenderers, this$0, $renderers, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17$lambda$16(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.renderers.comment", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.comment$default((Row)$this$row, (String)string, (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18$lambda$17(CidrDebuggerSettingsConfigurable this$0, Panel $this$rowsRange) {
        Intrinsics.checkNotNullParameter((Object)$this$rowsRange, (String)"$this$rowsRange");
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$0(this$0, arg_0), (int)1, null).visible(!CidrDebuggerSettingsConfigurableKt.access$getPRESENT_AS_OBJC$p());
        Panel.row$default((Panel)$this$rowsRange, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$1(this$0, arg_0), (int)1, null);
        Ref.ObjectRef natvisRenderers = new Ref.ObjectRef();
        $this$rowsRange.rowsRange(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$9(natvisRenderers, this$0, arg_0)).visible(SystemInfo.isWindows);
        Ref.ObjectRef renderers = new Ref.ObjectRef();
        $this$rowsRange.rowsRange(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17$lambda$15(renderers, this$0, arg_0)).visible(CidrDebuggerSettingsConfigurableKt.access$getPRESENT_AS_OBJC$p());
        Panel.row$default((Panel)$this$rowsRange, null, CidrDebuggerSettingsConfigurable::createPanel$lambda$32$lambda$18$lambda$17$lambda$16, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$18(CidrDebuggerSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        $this$group.rowsRange(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18$lambda$17(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24$lambda$19(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableValuesFilter.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isValuesFilterEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setValuesFilterEnabled(p0);
            }
        })), (String)CidrDebuggerBundle.message("debug.settings.enableValuesFilter.checkbox.hint", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24$lambda$20(Ref.ObjectRef $hex, CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableHexNumberFormatting.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $hex.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isHexFormattingEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setHexFormattingEnabled(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24$lambda$22$lambda$21(CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $hex, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.enableHexNumberFormatting.asSecondary.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isHexAsSecondaryFormattingEnabled();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setHexAsSecondaryFormattingEnabled(p0);
            }
        }));
        if ($hex.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hex");
            cell = null;
        } else {
            cell = (Cell)$hex.element;
        }
        cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24$lambda$22(CidrDebuggerSettingsConfigurable this$0, Ref.ObjectRef $hex, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24$lambda$22$lambda$21(this$0, $hex, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24$lambda$23(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.showTypeTemplateArguments.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isShowTypeTemplateArguments();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setShowTypeTemplateArguments(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$24(boolean $isCxxNameDecorationEnabledInRegistry, CidrDebuggerSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24$lambda$19(this$0, arg_0), (int)1, null);
        Ref.ObjectRef hex = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24$lambda$20(hex, this$0, arg_0), (int)1, null);
        $this$group.indent(arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24$lambda$22(this$0, hex, arg_0));
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24$lambda$23(this$0, arg_0), (int)1, null).visible($isCxxNameDecorationEnabledInRegistry);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$28$lambda$25(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.showFrameModule.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isShowFrameModuleName();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setShowFrameModuleName(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$28$lambda$26(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.showFrameFunctionParameterTypes.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isShowFrameFunctionParameters();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setShowFrameFunctionParameters(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$28$lambda$27(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.showFrameFunctionTemplateArguments.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isShowFrameFunctionTemplateArguments();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setShowFrameFunctionTemplateArguments(p0);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$28(boolean $isCxxNameDecorationEnabledInRegistry, CidrDebuggerSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$28$lambda$25(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$28$lambda$26(this$0, arg_0), (int)1, null).visible($isCxxNameDecorationEnabledInRegistry);
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$28$lambda$27(this$0, arg_0), (int)1, null).visible($isCxxNameDecorationEnabledInRegistry);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$31$lambda$29(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.stripCxxStdAbiVersionNamespace.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isStripCxxAuxiliaryNamespaces();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setStripCxxAuxiliaryNamespaces(p0);
            }
        })), (String)CidrDebuggerBundle.message("debug.settings.stripCxxStdAbiVersionNamespace.checkbox.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$31$lambda$30(CidrDebuggerSettingsConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = CidrDebuggerBundle.message("debug.settings.sugarizeCxxStlTypes.checkbox", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (Function0)((Function0)new Function0<Boolean>((Object)this$0.settings){

            public final Boolean invoke() {
                return ((CidrDebuggerSettings)((Object)this.receiver)).isSugarizeCxxStlTypes();
            }
        }), (Function1)((Function1)new Function1<Boolean, Unit>((Object)this$0.settings){

            public final void invoke(boolean p0) {
                ((CidrDebuggerSettings)((Object)this.receiver)).setSugarizeCxxStlTypes(p0);
            }
        })), (String)CidrDebuggerBundle.message("debug.settings.sugarizeCxxStlTypes.checkbox.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32$lambda$31(CidrDebuggerSettingsConfigurable this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$31$lambda$29(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$group, null, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$31$lambda$30(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$32(CidrDebuggerSettingsConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        boolean isCxxNameDecorationEnabledInRegistry = Registry.Companion.is("cidr.debugger.frameTypeDecorator", true);
        Panel.group$default((Panel)$this$panel, (String)CidrDebuggerBundle.message("debug.settings.renderers.separator", new Object[0]), (boolean)false, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$18(this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)CidrDebuggerBundle.message("debug.settings.variables.separator", new Object[0]), (boolean)false, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$24(isCxxNameDecorationEnabledInRegistry, this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)CidrDebuggerBundle.message("debug.settings.frames.separator", new Object[0]), (boolean)false, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$28(isCxxNameDecorationEnabledInRegistry, this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)CidrDebuggerBundle.message("debug.settings.cxxTypes.separator", new Object[0]), (boolean)false, arg_0 -> CidrDebuggerSettingsConfigurable.createPanel$lambda$32$lambda$31(this$0, arg_0), (int)2, null).visible(isCxxNameDecorationEnabledInRegistry);
        return Unit.INSTANCE;
    }

    private static final void buildDirectoriesTable$lambda$33(CidrDebuggerSettingsConfigurable this$0, JBList $list, CollectionListModel $model, AnActionButton it) {
        Path path = this$0.showSelectDirectoryDialog((Component)$list);
        if (path != null) {
            $model.add((Object)path);
        }
    }

    private static final void buildDirectoriesTable$lambda$34(CollectionListModel $model, JBList $list, AnActionButton it) {
        $model.remove($list.getSelectedIndex());
    }

    private static final Unit buildDirectoriesTable$lambda$35(Function1 $saveValuesToSettings, CollectionListModel $model) {
        List list = $model.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        $saveValuesToSettings.invoke((Object)list);
        return Unit.INSTANCE;
    }

    private static final boolean buildDirectoriesTable$lambda$36(Function0 $getValuesFromSettings, CollectionListModel $model) {
        return !Intrinsics.areEqual((Object)$getValuesFromSettings.invoke(), (Object)$model.getItems());
    }

    private static final Unit buildDirectoriesTable$lambda$37(CollectionListModel $model, Function0 $getValuesFromSettings) {
        $model.replaceAll((List)$getValuesFromSettings.invoke());
        return Unit.INSTANCE;
    }
}

