/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerKt;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerProvider;
import com.jetbrains.cidr.execution.debugger.actions.CidrOpenCVMatImageViewer;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewerProvider;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerProvider;", "<init>", "()V", "getImageViewer", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "value", "Lcom/intellij/xdebugger/frame/XValue;", "isCvMatType", "", "type", "", "stripRef", "intellij.cidr.debugger"})
public final class CidrOpenCVMatImageViewerProvider
implements CidrImageViewerProvider {
    @Override
    @Nullable
    public CidrImageViewer getImageViewer(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof CidrPhysicalValue) {
            String string = ((CidrPhysicalValue)value).getType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getType(...)");
            if (this.isCvMatType(string)) {
                return new CidrOpenCVMatImageViewer((CidrPhysicalValue)value);
            }
        }
        return null;
    }

    @VisibleForTesting
    public final boolean isCvMatType(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String t = this.stripRef(CidrImageViewerKt.access$stripQualifiers(type));
        return Intrinsics.areEqual((Object)t, (Object)"cv::Mat") || StringsKt.startsWith$default((String)t, (String)"cv::Mat_<", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)t, (String)">", (boolean)false, (int)2, null);
    }

    private final String stripRef(String type) {
        return ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)type, (CharSequence)"&"))).toString();
    }
}

