/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrThreadFreezer;
import com.jetbrains.cidr.execution.debugger.actions.CidrFreezeThreadActionsKt;
import com.jetbrains.cidr.execution.debugger.actions.CidrOneByOneThreadFreezeHandler;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096@\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrUnfreezeSelectedThreadsHandler;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrOneByOneThreadFreezeHandler;", "<init>", "()V", "canHandle", "", "threads", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "handle", "freezer", "Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;", "(Lcom/jetbrains/cidr/execution/debugger/CidrThreadFreezer;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nCidrFreezeThreadActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrFreezeThreadActions.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrUnfreezeSelectedThreadsHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n1755#2,3:344\n*S KotlinDebug\n*F\n+ 1 CidrFreezeThreadActions.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrUnfreezeSelectedThreadsHandler\n*L\n70#1:344,3\n*E\n"})
public final class CidrUnfreezeSelectedThreadsHandler
extends CidrOneByOneThreadFreezeHandler {
    @NotNull
    public static final CidrUnfreezeSelectedThreadsHandler INSTANCE = new CidrUnfreezeSelectedThreadsHandler();

    private CidrUnfreezeSelectedThreadsHandler() {
        String string = CidrDebuggerBundle.message("debug.unfreezeThreads.progress", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = CidrDebuggerBundle.message("debug.unfreezeThreads.notification.success", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = CidrDebuggerBundle.message("debug.unfreezeThreads.notification.error", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        super(string, string2, string3);
    }

    @Override
    public boolean canHandle(@NotNull List<? extends LLThread> threads2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(threads2, (String)"threads");
            Iterable $this$any$iv = threads2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    LLThread it = (LLThread)element$iv;
                    boolean bl2 = false;
                    if (!it.isFrozen()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        List<LLThread> threads2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataContext dataContext = event.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        List<LLThread> list = threads2 = this.getThreads(dataContext);
        boolean bl = list != null ? list.size() == 1 : false;
        if (bl) {
            CidrFreezeThreadActionsKt.access$addThreadNameToText("debug.unfreezeThread.textWithThreadName", event, (LLThread)CollectionsKt.first(threads2));
        } else {
            event.getPresentation().setText(CidrDebuggerBundle.message("debug.unfreezeThreads.text", new Object[0]));
        }
    }

    @Override
    @Nullable
    public Object handle(@NotNull CidrThreadFreezer freezer, @NotNull List<? extends LLThread> threads2, @NotNull Continuation<? super Unit> $completion) {
        Object object = freezer.unfreezeThreads(threads2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }
}

