/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.cuda.CudaLLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "CudaCommands", "intellij.cidr.debugger"})
public final class CudaSupport
implements CidrDebugProcessConfigurator {
    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)debuggerDriverConfiguration), (String)"getDebuggerDriverConfiguration(...)");
        DebuggerDriverConfiguration driverConfiguration = debuggerDriverConfiguration;
        if (!(driverConfiguration instanceof GDBDriverConfiguration) || !Intrinsics.areEqual((Object)PathUtil.getFileName((String)((GDBDriverConfiguration)driverConfiguration).getGDBExecutablePath()), (Object)"cuda-gdb")) {
            return;
        }
        process.postCommand(arg_0 -> CudaSupport.configure$lambda$0(this, process, arg_0));
    }

    private static final void configure$lambda$0(CudaSupport this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        try {
            ((GDBDriver)driver).sendSilentRequestAndWaitForDone("show cuda", new Object[0]);
            ((GDBDriver)driver).setThreadFrameInfoDriverDelegate(this$0.new CudaCommands());
            CidrDebuggerLog.LOG.debug("CUDA support enabled");
            Project project = $process.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
            CidrDebuggerUsagesCollector.INSTANCE.logCudaDetected(project);
        }
        catch (Exception exception) {
            CidrDebuggerLog.LOG.debug("CUDA support won't be enabled");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J2\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J?\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport$CudaCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;)V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "getVariables", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "evaluate", "expression", "", "language", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DebuggerLanguage;", "switchContextIfNeededAndExecute", "T", "switchedContextExecutor", "Lkotlin/Function0;", "defaultExecutor", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.cidr.debugger"})
    private final class CudaCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @Override
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            CompletableFuture<DebuggerDriver.StopPlace> completableFuture;
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
            Intrinsics.checkNotNullParameter((Object)stopTuple, (String)"stopTuple");
            GDBTuple gDBTuple = stopTuple.getTupleOrEmpty("CudaFocus");
            Intrinsics.checkNotNullExpressionValue((Object)gDBTuple, (String)"getTupleOrEmpty(...)");
            GDBTuple cudaFocus = gDBTuple;
            if (cudaFocus.isEmpty()) {
                CompletableFuture<DebuggerDriver.StopPlace> completableFuture2 = GDBDriver.ThreadFrameInfoDriverDelegate.super.doReadStopPlaceAsync(bridge, driver, stopTuple);
                Intrinsics.checkNotNull(completableFuture2);
                completableFuture = completableFuture2;
            } else {
                DebuggerDriver.StopPlace stopPlace;
                try {
                    GDBTuple $this$doReadStopPlaceAsync_u24lambda_u240 = cudaFocus;
                    boolean bl = false;
                    int n = $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("kernel");
                    int n2 = $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("grid");
                    String string = $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredString("blockIdx");
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRequiredString(...)");
                    String string2 = $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredString("threadIdx");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRequiredString(...)");
                    CudaLLThread thread = new CudaLLThread(n, n2, string, string2, $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("device"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("sm"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("warp"), $this$doReadStopPlaceAsync_u24lambda_u240.getRequiredInt("lane"));
                    GDBTuple gDBTuple2 = stopTuple.getRequiredTupleOrThrow("frame", () -> CudaCommands.doReadStopPlaceAsync$lambda$1(stopTuple));
                    Intrinsics.checkNotNullExpressionValue((Object)gDBTuple2, (String)"getRequiredTupleOrThrow(...)");
                    GDBTuple frameTuple = gDBTuple2;
                    LLFrame lLFrame = bridge.doReadFrame(0, frameTuple);
                    Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"doReadFrame(...)");
                    LLFrame frame = lLFrame;
                    stopPlace = new DebuggerDriver.StopPlace(thread, frame, bridge.doReadReturnValue(stopTuple, thread.getId(), frame.getIndex()));
                }
                catch (ExecutionException e) {
                    CidrDebuggerLog.LOG.error((Throwable)e);
                    stopPlace = null;
                }
                DebuggerDriver.StopPlace stopPlace2 = stopPlace;
                CompletableFuture<Object> completableFuture3 = CompletableFuture.completedFuture(stopPlace2);
                Intrinsics.checkNotNull(completableFuture3);
                completableFuture = completableFuture3;
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public List<LLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Object t = this.switchContextIfNeededAndExecute(bridge, thread, () -> CudaCommands.getVariables$lambda$2(bridge, frame), () -> CudaCommands.getVariables$lambda$3(this, bridge, thread, frame));
            Intrinsics.checkNotNullExpressionValue(t, (String)"switchContextIfNeededAndExecute(...)");
            return (List)t;
        }

        @Override
        @NotNull
        public LLValue evaluate(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) {
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Object t = this.switchContextIfNeededAndExecute(bridge, thread, () -> CudaCommands.evaluate$lambda$4(bridge, frame, expression, language), () -> CudaCommands.evaluate$lambda$5(this, bridge, thread, frame, expression, language));
            Intrinsics.checkNotNullExpressionValue(t, (String)"switchContextIfNeededAndExecute(...)");
            return (LLValue)((Object)t);
        }

        private final <T> T switchContextIfNeededAndExecute(GDBDriver.Bridge bridge, LLThread thread, Function0<? extends T> switchedContextExecutor, Function0<? extends T> defaultExecutor) {
            return (T)(thread instanceof CudaLLThread ? bridge.executeCommand(() -> CudaCommands.switchContextIfNeededAndExecute$lambda$6(bridge, thread, switchedContextExecutor)) : defaultExecutor.invoke());
        }

        private static final ExecutionException doReadStopPlaceAsync$lambda$1(GDBTuple $stopTuple) {
            Object[] objectArray = new Object[]{$stopTuple};
            return new ExecutionException(GDBBundle.message("error.cannot.read.stop.place", objectArray));
        }

        private static final List getVariables$lambda$2(GDBDriver.Bridge $bridge, LLFrame $frame) {
            return $bridge.doGetFrameVariables(-1L, $frame.getIndex());
        }

        private static final List getVariables$lambda$3(CudaCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.getVariables($bridge, $thread, $frame);
        }

        private static final LLValue evaluate$lambda$4(GDBDriver.Bridge $bridge, LLFrame $frame, String $expression, DebuggerDriver.DebuggerLanguage $language) {
            return $bridge.doEvaluate(-1L, $frame.getIndex(), $expression, $language);
        }

        private static final LLValue evaluate$lambda$5(CudaCommands this$0, GDBDriver.Bridge $bridge, LLThread $thread, LLFrame $frame, String $expression, DebuggerDriver.DebuggerLanguage $language) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.evaluate($bridge, $thread, $frame, $expression, $language);
        }

        private static final Object switchContextIfNeededAndExecute$lambda$6(GDBDriver.Bridge $bridge, LLThread $thread, Function0 $switchedContextExecutor) {
            String string = $bridge.sendSilentRequestAndGetOutput("cuda kernel", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sendSilentRequestAndGetOutput(...)");
            String consoleOutput = string;
            if (StringsKt.startsWith$default((String)consoleOutput, (String)"Focus is not set", (boolean)false, (int)2, null)) {
                $bridge.sendSilentRequestAndGetOutput("cuda kernel " + ((CudaLLThread)$thread).getKernel() + " grid " + ((CudaLLThread)$thread).getGrid() + " thread " + ((CudaLLThread)$thread).getThreadIdx() + " block " + ((CudaLLThread)$thread).getBlockIdx() + " device " + ((CudaLLThread)$thread).getDevice() + " sm " + ((CudaLLThread)$thread).getSm() + " warp " + ((CudaLLThread)$thread).getWarp() + " lane " + ((CudaLLThread)$thread).getLane(), new Object[0]);
            }
            return $switchedContextExecutor.invoke();
        }
    }
}

