/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBResponse {
    public static GDBResponse parse(String s) throws ResponseParseException {
        return new Parser(s).parse();
    }

    private static String formatRecord(RecordCategory kind, RecordType name, GDBTuple resultList) {
        StringBuilder buffer = new StringBuilder(kind.toString());
        buffer.append(name);
        if (!resultList.isEmpty()) {
            buffer.append(",");
            GDBResponse.doFormat(buffer, resultList, false);
        }
        return buffer.toString();
    }

    private static void doFormat(StringBuilder buffer, Object obj, boolean closed) {
        if (obj instanceof Pair) {
            buffer.append(((Pair)obj).first);
            buffer.append("=");
            GDBResponse.doFormat(buffer, ((Pair)obj).second, true);
        } else if (obj instanceof List) {
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'{' : '[');
            }
            boolean first = true;
            for (Object each : (List)obj) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                GDBResponse.doFormat(buffer, each, true);
            }
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'}' : ']');
            }
        } else if (obj instanceof String) {
            buffer.append("\"").append(StringUtil.escapeQuotes((String)((String)obj))).append("\"");
        } else {
            throw new RuntimeException("unknown object: " + obj);
        }
    }

    public String toString() {
        return super.toString();
    }

    private static final class Parser {
        String text;

        private Parser(String s) {
            this.text = s;
        }

        public GDBResponse parse() throws ResponseParseException {
            ANTLRInputStream input = new ANTLRInputStream(this.text);
            GdbLexer lexer = new GdbLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            GdbParser parser = new GdbParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(new ANTLRErrorListener(){

                @Override
                public void syntaxError(Recognizer<?, ?> recognizer, @Nullable Object o, int line, int position, String msg, @Nullable RecognitionException e) {
                    throw new RuntimeException("Syntax error: " + msg + " in \"" + text + "\" line " + line + " position " + position);
                }

                @Override
                public void reportAmbiguity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, boolean b, @org.antlr.v4.runtime.misc.NotNull BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Ambiguity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                @Override
                public void reportAttemptingFullContext(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, @Nullable BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Attempting full context in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                @Override
                public void reportContextSensitivity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, int i3, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.error("Context sensitivity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }
            });
            try {
                GdbParser.ResponseContext tree = parser.response();
                GDBResponseVisitor visitor = new GDBResponseVisitor();
                return (GDBResponse)visitor.visit(tree);
            }
            catch (Throwable e) {
                CidrDebuggerLog.LOG.warn("Failed to parse response: '" + this.text + "'", e);
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }

    public static class ResponseParseException
    extends Exception {
        public ResponseParseException(String text, Throwable cause) {
            super(text, cause);
        }
    }

    public static class StreamRecord
    extends GDBResponse {
        private final Category myCategory;
        private final String myText;

        public StreamRecord(@NotNull Category category, @NotNull String text) {
            if (category == null) {
                StreamRecord.$$$reportNull$$$0(0);
            }
            if (text == null) {
                StreamRecord.$$$reportNull$$$0(1);
            }
            this.myCategory = category;
            this.myText = text;
        }

        @NotNull
        public Category getCategory() {
            Category category = this.myCategory;
            if (category == null) {
                StreamRecord.$$$reportNull$$$0(2);
            }
            return category;
        }

        @NlsSafe
        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                StreamRecord.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public String toString() {
            return this.myCategory.myPrefix + "\"" + StringUtil.escapeStringCharacters((String)this.myText) + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }

        public static enum Category implements RecordCategory
        {
            console("~"),
            target("@"),
            log("&");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@NotNull String prefix) {
                if (prefix == null) {
                    Category.$$$reportNull$$$0(1);
                }
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord$Category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$StreamRecord$Category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "forPrefix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
    }

    public static class AsyncRecord
    extends Record<Category, Type> {
        public AsyncRecord(@NotNull Category category, @NotNull String type, @NotNull GDBTuple resultList, @Nullable String commandToken) {
            if (category == null) {
                AsyncRecord.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AsyncRecord.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                AsyncRecord.$$$reportNull$$$0(2);
            }
            super(category, new Type(type), resultList, commandToken);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "category";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static class Type
        implements RecordType {
            @NotNull
            private final String myValue;

            public Type(@NotNull String value) {
                if (value == null) {
                    Type.$$$reportNull$$$0(0);
                }
                this.myValue = value;
            }

            @NlsSafe
            @NotNull
            public String getValue() {
                String string = this.myValue;
                if (string == null) {
                    Type.$$$reportNull$$$0(1);
                }
                return string;
            }

            public String toString() {
                return this.myValue;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Type name = (Type)o;
                return this.myValue.equals(name.myValue);
            }

            public int hashCode() {
                return this.myValue.hashCode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Type";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getValue";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        }

        public static enum Category implements RecordCategory
        {
            exec("*"),
            notify("="),
            status("+");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@NotNull String prefix) {
                if (prefix == null) {
                    Category.$$$reportNull$$$0(1);
                }
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Category";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPrefix";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$AsyncRecord$Category";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "forPrefix";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
    }

    public static class ResultRecord
    extends Record<Category, Type> {
        public ResultRecord(@NotNull Category kind, @NotNull Type type, @NotNull GDBTuple resultList, @Nullable String commandToken) {
            if (kind == null) {
                ResultRecord.$$$reportNull$$$0(0);
            }
            if (type == null) {
                ResultRecord.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                ResultRecord.$$$reportNull$$$0(2);
            }
            super(kind, type, resultList, commandToken);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resultList";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        public static enum Type implements RecordType
        {
            done,
            running,
            connected,
            error,
            exit,
            stepping,
            continuing,
            result,
            tuple_value,
            list_value,
            str_value;

        }

        public static enum Category implements RecordCategory
        {
            result("^");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                String string = this.myPrefix;
                if (string == null) {
                    Category.$$$reportNull$$$0(0);
                }
                return string;
            }

            public String toString() {
                return this.myPrefix;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$ResultRecord$Category", "getPrefix"));
            }
        }
    }

    public static abstract class Record<CATEGORY_TYPE extends RecordCategory, TYPE_TYPE extends RecordType>
    extends GDBResponse {
        @NotNull
        private final CATEGORY_TYPE myCategory;
        @NotNull
        private final TYPE_TYPE myType;
        @NotNull
        private final GDBTuple myResultList;
        @Nullable
        private final String myCommandToken;

        public Record(@NotNull CATEGORY_TYPE category, @NotNull TYPE_TYPE type, @NotNull GDBTuple resultList, @Nullable String commandToken) {
            if (category == null) {
                Record.$$$reportNull$$$0(0);
            }
            if (type == null) {
                Record.$$$reportNull$$$0(1);
            }
            if (resultList == null) {
                Record.$$$reportNull$$$0(2);
            }
            this.myCategory = category;
            this.myType = type;
            this.myResultList = resultList;
            this.myCommandToken = commandToken;
        }

        @NotNull
        public CATEGORY_TYPE getCategory() {
            CATEGORY_TYPE CATEGORY_TYPE = this.myCategory;
            if (CATEGORY_TYPE == null) {
                Record.$$$reportNull$$$0(3);
            }
            return CATEGORY_TYPE;
        }

        @NotNull
        public TYPE_TYPE getType() {
            TYPE_TYPE TYPE_TYPE = this.myType;
            if (TYPE_TYPE == null) {
                Record.$$$reportNull$$$0(4);
            }
            return TYPE_TYPE;
        }

        @NotNull
        public GDBTuple getResultList() {
            GDBTuple gDBTuple = this.myResultList;
            if (gDBTuple == null) {
                Record.$$$reportNull$$$0(5);
            }
            return gDBTuple;
        }

        @Override
        public String toString() {
            return GDBResponse.formatRecord(this.getCategory(), this.getType(), this.myResultList);
        }

        @Nullable
        public String getCommandToken() {
            return this.myCommandToken;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "category";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultList";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$Record";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCategory";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static interface RecordType {
    }

    public static interface RecordCategory {
        @NlsSafe
        @NotNull
        public String getPrefix();

        @NotNull
        public static <T extends RecordCategory> T forPrefix(T @NotNull [] values, @NotNull String prefix) {
            if (prefix == null) {
                RecordCategory.$$$reportNull$$$0(0);
            }
            if (values == null) {
                RecordCategory.$$$reportNull$$$0(1);
            }
            for (T each : values) {
                if (!each.getPrefix().equals(prefix)) continue;
                T t = each;
                if (t == null) {
                    RecordCategory.$$$reportNull$$$0(2);
                }
                return t;
            }
            throw new IllegalArgumentException("Unknown RecordCategory prefix, expected one of " + Arrays.toString(values));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$RecordCategory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBResponse$RecordCategory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "forPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "forPrefix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

