/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.childProcessDebugging;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.DebuggerCommandContext;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingFileFormatUtilsKt;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingSettings;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRules;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DefaultRule;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ParseResult;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.Rule;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J#\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ChildProcessDebuggingDriverConfigurator;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "configureChildProcessDebugging", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "tryGetRulesFromFile", "Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/DebuggingRules;", "project", "Lcom/intellij/openapi/project/Project;", "createDebuggingRulesString", "", "rules", "intellij.cidr.debugger"})
public final class ChildProcessDebuggingDriverConfigurator
implements CidrDebugProcessConfigurator {
    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (!SystemInfo.isWindows) {
            return;
        }
        if (!(process.getRunParameters().getDebuggerDriverConfiguration() instanceof LLDBDriverConfiguration)) {
            return;
        }
        if (!Registry.Companion.is("cidr.debugger.lldb.child.process.debugging.enabled")) {
            CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - child process debugging is disabled through registry");
            return;
        }
        ChildProcessDebuggingSettings childProcessDebuggingSettings = CidrDebuggerSettings.getInstance().getChildProcessDebuggingSettings();
        Intrinsics.checkNotNullExpressionValue((Object)childProcessDebuggingSettings, (String)"getChildProcessDebuggingSettings(...)");
        ChildProcessDebuggingSettings settings = childProcessDebuggingSettings;
        if (!settings.getUseChildProcessDebugging()) {
            CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - child process debugging is disabled");
            return;
        }
        this.configureChildProcessDebugging(process);
    }

    private final CompletableFuture<Void> configureChildProcessDebugging(CidrDebugProcess process) {
        CompletableFuture<Void> completableFuture = process.postCommand(arg_0 -> ChildProcessDebuggingDriverConfigurator.configureChildProcessDebugging$lambda$0(this, process, arg_0));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"postCommand(...)");
        return completableFuture;
    }

    private final DebuggingRules tryGetRulesFromFile(Project project) {
        String rulesFile = ChildProcessDebuggingFileFormatUtilsKt.getRulesFilePath(project);
        if (rulesFile != null && new File(rulesFile).exists()) {
            ParseResult parseResult;
            CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - configuring child process debugging for " + rulesFile);
            ParseResult parseResult2 = parseResult = ChildProcessDebuggingFileFormatUtilsKt.parseChildProcessDebuggingFileFormat(rulesFile);
            if (parseResult2 instanceof ParseResult.Success) {
                return ((ParseResult.Success)parseResult).getDebuggingRules();
            }
            if (parseResult2 instanceof ParseResult.Error) {
                CidrDebuggerLog.LOG.warn("ChildProcessDebuggingDriverConfigurator - failed to parse rules file: " + ((ParseResult.Error)parseResult).getMessage());
                XDebuggerManagerImpl.getNotificationGroup().createNotification(((ParseResult.Error)parseResult).getMessage(), NotificationType.WARNING).notify(project);
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - no rules file found, using default rule with attach = true");
        return new DebuggingRules(new DefaultRule(true), CollectionsKt.emptyList());
    }

    private final String createDebuggingRulesString(DebuggingRules rules) {
        StringBuilder result = new StringBuilder("child-process-debug ");
        String startToken = "^<JB<";
        String cmdToken = "#JB_CMD#";
        String actToken = "#JB_ACT#";
        String attachToken = "attach";
        String passToken = "pass";
        String endToken = ">JB>$";
        for (Rule rule : rules.getRules()) {
            result.append(startToken);
            String string = rule.getProcessName();
            if (string == null) {
                string = "*";
            }
            result.append(string);
            result.append(cmdToken);
            String string2 = rule.getCommandLine();
            if (string2 == null) {
                string2 = "*";
            }
            result.append(string2);
            result.append(actToken);
            result.append(rule.getAttach() ? attachToken : passToken);
            result.append(endToken);
        }
        result.append(startToken);
        result.append("*");
        result.append(cmdToken);
        result.append("*");
        result.append(actToken);
        result.append(rules.getDefaultRule().getAttach() ? attachToken : passToken);
        result.append(endToken);
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void configureChildProcessDebugging$lambda$0(ChildProcessDebuggingDriverConfigurator this$0, CidrDebugProcess $process, DebuggerDriver driver) {
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        if (!(driver instanceof LLDBDriver)) {
            return;
        }
        Project project = $process.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"<get-project>(...)");
        DebuggingRules rules = this$0.tryGetRulesFromFile(project);
        if (rules == null) {
            CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - no rules found");
            return;
        }
        String rulesString = this$0.createDebuggingRulesString(rules);
        CidrDebuggerLog.LOG.debug("ChildProcessDebuggingDriverConfigurator - configuring child process debugging with rules: " + rulesString);
        ((LLDBDriver)driver).executeDebuggerCommand(new DebuggerCommandContext.Builder().withoutExecutionContext().build(), rulesString);
    }
}

