/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.formatters.natvis;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0004"}, d2={"getVisualStudioSystemVisualizersDir", "Ljava/nio/file/Path;", "vsRootDir", "getVisualStudioUserVisualizersDir", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nNatvisFileLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NatvisFileLocationUtils.kt\ncom/jetbrains/cidr/execution/debugger/formatters/natvis/NatvisFileLocationUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,18:1\n1#2:19\n*E\n"})
public final class NatvisFileLocationUtilsKt {
    @Nullable
    public static final Path getVisualStudioSystemVisualizersDir(@NotNull Path vsRootDir) {
        Path visualizersDir;
        Path path;
        Intrinsics.checkNotNullParameter((Object)vsRootDir, (String)"vsRootDir");
        Path it = path = (visualizersDir = vsRootDir.resolve("Common7/Packages/Debugger/Visualizers"));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
    }

    @Nullable
    public static final Path getVisualStudioUserVisualizersDir(@NotNull Path vsRootDir) {
        Intrinsics.checkNotNullParameter((Object)vsRootDir, (String)"vsRootDir");
        Path path = vsRootDir.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        Integer n = StringsKt.toIntOrNull((String)PathsKt.getName((Path)path));
        if (n == null) {
            return null;
        }
        int vsVersion = n;
        String string = System.getenv("USERPROFILE");
        if (string == null) {
            return null;
        }
        String userProfile = string;
        Object object = new String[]{"Documents", "Visual Studio " + vsVersion, "Visualizers"};
        Path visualizersDir = Path.of(userProfile, object);
        Object it = object = visualizersDir;
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.exists((Path)it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? object : null;
    }
}

