/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueNodeKt;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.PreprocessNodeComparator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.impl.CompoundIconProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tree.LeafState;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/common/error/IssuedFileNode;", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLeafState", "Lcom/intellij/ui/tree/LeafState;", "getName", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getVirtualFile", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "updatePresentation", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "hashCode", "", "equals", "", "other", "", "getChildren", "", "Lcom/android/tools/idea/common/error/IssueNode;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesignerCommonIssueNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerCommonIssueNode.kt\ncom/android/tools/idea/common/error/IssuedFileNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,606:1\n1#2:607\n*E\n"})
public final class IssuedFileNode
extends DesignerCommonIssueNode {
    @NotNull
    private final VirtualFile file;
    public static final int $stable = 8;

    public IssuedFileNode(@NotNull VirtualFile file2, @Nullable DesignerCommonIssueNode parent) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        DesignerCommonIssueNode designerCommonIssueNode = parent;
        super((Project)(designerCommonIssueNode != null ? designerCommonIssueNode.getProject() : null), (NodeDescriptor<DesignerCommonIssueNode>)((NodeDescriptor)parent));
        this.file = file2;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public LeafState getLeafState() {
        return LeafState.DEFAULT;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile it = this.file;
        boolean bl = false;
        VirtualFile virtualFile = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"let(...)");
        return virtualFile;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable() {
        return null;
    }

    @Override
    protected void updatePresentation(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        VirtualFile virtualFile = this.file;
        presentation.addText(this.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        Icon icon2 = CompoundIconProvider.findIcon((PsiElement)((PsiElement)PsiUtilCore.findFileSystemItem((Project)this.getProject(), (VirtualFile)virtualFile)), (int)0);
        if (icon2 == null) {
            Icon icon3 = virtualFile.isDirectory() ? AllIcons.Nodes.Folder : AllIcons.FileTypes.Any_type;
            Intrinsics.checkNotNull((Object)icon3);
            icon2 = icon3;
        }
        presentation.setIcon(icon2);
        Object object = virtualFile.getParent();
        if (object == null || (object = object.getPresentableUrl()) == null) {
            return;
        }
        Object url = object;
        presentation.addText("  " + FileUtil.getLocationRelativeToUserHome((String)url), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        int count = this.getNodeProvider().getIssueNodes(this).size();
        presentation.addText("  " + DesignerCommonIssueNodeKt.access$createIssueCountText(count), SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public int hashCode() {
        Object[] objectArray = new Object[2];
        NodeDescriptor nodeDescriptor = this.getParentDescriptor();
        objectArray[0] = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        objectArray[1] = this.file;
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        IssuedFileNode issuedFileNode = other instanceof IssuedFileNode ? (IssuedFileNode)((Object)other) : null;
        if (issuedFileNode == null) {
            return false;
        }
        IssuedFileNode that = issuedFileNode;
        NodeDescriptor nodeDescriptor = that.getParentDescriptor();
        NodeDescriptor nodeDescriptor2 = this.getParentDescriptor();
        return Intrinsics.areEqual((Object)(nodeDescriptor != null ? nodeDescriptor.getElement() : null), (Object)(nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null)) && Intrinsics.areEqual((Object)that.file, (Object)this.file);
    }

    @NotNull
    public List<IssueNode> getChildren() {
        Iterable iterable = this.getNodeProvider().getIssueNodes(this);
        Comparator<DesignerCommonIssueNode> comparator = PreprocessNodeComparator.INSTANCE.thenComparing(this.getIssueComparator());
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"thenComparing(...)");
        return CollectionsKt.sortedWith((Iterable)iterable, comparator);
    }
}

