/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import java.awt.Cursor;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/common/surface/LayoutlibInteraction;", "Lcom/android/tools/idea/common/surface/Interaction;", "sceneView", "Lcom/android/tools/idea/common/surface/SceneView;", "<init>", "(Lcom/android/tools/idea/common/surface/SceneView;)V", "commit", "", "event", "Lcom/android/tools/idea/common/surface/InteractionEvent;", "begin", "cancel", "getCursor", "Ljava/awt/Cursor;", "update", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class LayoutlibInteraction
implements Interaction {
    @NotNull
    private final SceneView sceneView;
    public static final int $stable = 8;

    public LayoutlibInteraction(@NotNull SceneView sceneView) {
        Intrinsics.checkNotNullParameter((Object)sceneView, (String)"sceneView");
        this.sceneView = sceneView;
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        MouseReleasedEvent mouseEvent = (MouseReleasedEvent)event;
        int androidX = Coordinates.getAndroidX(this.sceneView, ((MouseEvent)mouseEvent.getEventObject()).getX());
        int androidY = Coordinates.getAndroidY(this.sceneView, ((MouseEvent)mouseEvent.getEventObject()).getY());
        SceneManager sceneManager = this.sceneView.getSceneManager();
        if (sceneManager instanceof LayoutlibSceneManager) {
            ((LayoutlibSceneManager)sceneManager).triggerTouchEventAsync(RenderSession.TouchEventType.RELEASE, androidX, androidY);
        }
        this.sceneView.getSurface().repaint();
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        block2: {
            InteractionEvent interactionEvent;
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                interactionEvent = event;
                if (!(interactionEvent instanceof MousePressedEvent)) break block1;
                int androidX = Coordinates.getAndroidX(this.sceneView, ((MouseEvent)((MousePressedEvent)event).getEventObject()).getX());
                int androidY = Coordinates.getAndroidY(this.sceneView, ((MouseEvent)((MousePressedEvent)event).getEventObject()).getY());
                SceneManager sceneManager = this.sceneView.getSceneManager();
                if (!(sceneManager instanceof LayoutlibSceneManager)) break block2;
                ((LayoutlibSceneManager)sceneManager).triggerTouchEventAsync(RenderSession.TouchEventType.PRESS, androidX, androidY);
                break block2;
            }
            if (!(interactionEvent instanceof KeyPressedEvent)) break block2;
            SceneManager sceneManager = this.sceneView.getSceneManager();
            LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
            if (layoutlibSceneManager != null) {
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyPressedEvent)event).getEventObject());
            }
        }
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.sceneView.getScene().mouseCancel();
        this.sceneView.getSurface().repaint();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return this.sceneView.getScene().getMouseCursor();
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        block3: {
            InteractionEvent interactionEvent;
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    interactionEvent = event;
                    if (!(interactionEvent instanceof MouseDraggedEvent)) break block2;
                    int mouseX = ((MouseEvent)((MouseDraggedEvent)event).getEventObject()).getX();
                    int mouseY = ((MouseEvent)((MouseDraggedEvent)event).getEventObject()).getY();
                    this.sceneView.getContext().setMouseLocation(mouseX, mouseY);
                    int androidX = Coordinates.getAndroidX(this.sceneView, mouseX);
                    int androidY = Coordinates.getAndroidY(this.sceneView, mouseY);
                    SceneManager sceneManager = this.sceneView.getSceneManager();
                    if (sceneManager instanceof LayoutlibSceneManager) {
                        ((LayoutlibSceneManager)sceneManager).triggerTouchEventAsync(RenderSession.TouchEventType.DRAG, androidX, androidY);
                    }
                    this.sceneView.getSurface().repaint();
                    break block3;
                }
                if (!(interactionEvent instanceof KeyPressedEvent)) break block4;
                SceneManager sceneManager = this.sceneView.getSceneManager();
                LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
                if (layoutlibSceneManager == null) break block3;
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyPressedEvent)event).getEventObject());
                break block3;
            }
            if (!(interactionEvent instanceof KeyReleasedEvent)) break block3;
            SceneManager sceneManager = this.sceneView.getSceneManager();
            LayoutlibSceneManager layoutlibSceneManager = sceneManager instanceof LayoutlibSceneManager ? (LayoutlibSceneManager)sceneManager : null;
            if (layoutlibSceneManager != null) {
                layoutlibSceneManager.triggerKeyEventAsync((KeyEvent)((KeyReleasedEvent)event).getEventObject());
            }
        }
    }

    @Override
    @NotNull
    public List<Layer> createOverlays() {
        return Interaction.super.createOverlays();
    }
}

