/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.util;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.compose.AndroidComposablePsiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDataProvider;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.compose.preview.ComposePreviewRepresentationProviderKt;
import com.android.tools.idea.compose.preview.ComposeViewInfo;
import com.android.tools.idea.compose.preview.ComposeViewInfoKt;
import com.android.tools.idea.compose.preview.ComposeViewInfoParserKt;
import com.android.tools.idea.compose.preview.PreviewElementFinderUtilsKt;
import com.android.tools.idea.editors.fast.FastPreviewManager;
import com.android.tools.idea.preview.essentials.PreviewEssentialsModeManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.android.tools.preview.ComposePreviewElementInstance;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\f\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u0007\u001a*\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0007\u001a\u000e\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u001e\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u0014j\u0004\u0018\u0001`\u0017*\u00020\u0018\u001a\u001e\u0010\u0013\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u0015\u0018\u00010\u0014j\u0004\u0018\u0001`\u0017*\u00020\u0019\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u001bH\u0001\u001a\f\u0010\u001c\u001a\u00020\u0001*\u00020\u001bH\u0002\u001a\f\u0010\u001d\u001a\u00020\u0001*\u00020\u001bH\u0002\u00a8\u0006\u001e"}, d2={"containsOffset", "", "Lcom/intellij/openapi/util/Segment;", "offset", "", "getRootComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "Lcom/android/tools/idea/common/surface/SceneView;", "getSmallestViewInfos", "", "Lcom/android/tools/idea/compose/preview/ComposeViewInfo;", "x", "y", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isRootComponentSelected", "isFastPreviewAvailable", "project", "Lcom/intellij/openapi/project/Project;", "previewElement", "Lcom/android/tools/preview/ComposePreviewElementInstance;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "Lcom/android/tools/idea/compose/PsiComposePreviewElementInstance;", "Lcom/intellij/openapi/actionSystem/DataContext;", "Lcom/android/tools/idea/common/model/NlDataProvider;", "isValidComposePreviewForRunConfiguration", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isInAndroidOrCommonModule", "isInTestFile", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/compose/preview/util/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n1#2:117\n1755#3,3:118\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/android/tools/idea/compose/preview/util/UtilsKt\n*L\n105#1:118,3\n*E\n"})
public final class UtilsKt {
    public static final boolean containsOffset(@Nullable Segment $this$containsOffset, int offset) {
        boolean bl;
        Segment segment = $this$containsOffset;
        if (segment != null) {
            Segment it = segment;
            boolean bl2 = false;
            bl = it.getStartOffset() <= offset && offset <= it.getEndOffset();
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final NlComponent getRootComponent(@NotNull SceneView $this$getRootComponent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getRootComponent, (String)"<this>");
        NlComponent root = (NlComponent)CollectionsKt.firstOrNull((List)((List)$this$getRootComponent.getSceneManager().getModel().getTreeReader().getComponents()));
        boolean bl2 = bl = root == null || Intrinsics.areEqual((Object)root.getTagName(), (Object)"androidx.compose.ui.tooling.ComposeViewAdapter");
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            NlComponent nlComponent = root;
            Intrinsics.checkNotNull((Object)nlComponent);
            String string = "Expected the root component of a Compose Preview to be a androidx.compose.ui.tooling.ComposeViewAdapter, but found " + nlComponent.getTagName();
            throw new AssertionError((Object)string);
        }
        return root;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Collection<ComposeViewInfo> getSmallestViewInfos(@NotNull SceneView $this$getSmallestViewInfos, int x, int y, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)$this$getSmallestViewInfos, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        int androidX = Coordinates.getAndroidX($this$getSmallestViewInfos, x);
        int androidY = Coordinates.getAndroidY($this$getSmallestViewInfos, y);
        SceneComponent sceneComponent = $this$getSmallestViewInfos.getScene().getRoot();
        if (sceneComponent == null) return null;
        NlComponent nlComponent = sceneComponent.getNlComponent();
        if (nlComponent == null) return null;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(nlComponent);
        if (viewInfo == null) return null;
        ViewInfo viewInfo2 = viewInfo;
        boolean bl = false;
        List<ComposeViewInfo> list = ComposeViewInfoParserKt.parseViewInfo(viewInfo2, logger);
        if (list == null) return null;
        Collection<ComposeViewInfo> collection = ComposeViewInfoKt.findSmallestHit(list, androidX, androidY);
        return collection;
    }

    public static final boolean isRootComponentSelected(@NotNull SceneView $this$isRootComponentSelected) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isRootComponentSelected, (String)"<this>");
        NlComponent nlComponent = UtilsKt.getRootComponent($this$isRootComponentSelected);
        if (nlComponent != null) {
            NlComponent it = nlComponent;
            boolean bl2 = false;
            bl = $this$isRootComponentSelected.getSurface().getSelectionModel().isSelected(it);
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isFastPreviewAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return FastPreviewManager.Companion.getInstance(project).isAvailable() && !PreviewEssentialsModeManager.INSTANCE.isEssentialsModeEnabled();
    }

    @Nullable
    public static final ComposePreviewElementInstance<SmartPsiElementPointer<PsiElement>> previewElement(@NotNull DataContext $this$previewElement) {
        Intrinsics.checkNotNullParameter((Object)$this$previewElement, (String)"<this>");
        return (ComposePreviewElementInstance)$this$previewElement.getData(ComposePreviewRepresentationProviderKt.getPSI_COMPOSE_PREVIEW_ELEMENT_INSTANCE());
    }

    @Nullable
    public static final ComposePreviewElementInstance<SmartPsiElementPointer<PsiElement>> previewElement(@NotNull NlDataProvider $this$previewElement) {
        Intrinsics.checkNotNullParameter((Object)$this$previewElement, (String)"<this>");
        return $this$previewElement.getData(ComposePreviewRepresentationProviderKt.getPSI_COMPOSE_PREVIEW_ELEMENT_INSTANCE());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresReadLock
    public static final boolean isValidComposePreviewForRunConfiguration(@NotNull KtNamedFunction $this$isValidComposePreviewForRunConfiguration) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isValidComposePreviewForRunConfiguration, (String)"<this>");
        if (UtilsKt.isInTestFile($this$isValidComposePreviewForRunConfiguration)) return false;
        if (!UtilsKt.isInAndroidOrCommonModule($this$isValidComposePreviewForRunConfiguration)) return false;
        if (!AndroidComposablePsiUtils.isValidPreviewLocation((KtNamedFunction)$this$isValidComposePreviewForRunConfiguration)) return false;
        List list = $this$isValidComposePreviewForRunConfiguration.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            KtAnnotationEntry annotation = (KtAnnotationEntry)element$iv;
            boolean bl2 = false;
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)annotation));
            UAnnotation uAnnotation = uElement instanceof UAnnotation ? (UAnnotation)uElement : null;
            if (uAnnotation != null) {
                if (PreviewElementFinderUtilsKt.isPreviewAnnotation$default(uAnnotation, false, 1, null)) {
                    return true;
                }
                bl = false;
                continue;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isInAndroidOrCommonModule(KtNamedFunction $this$isInAndroidOrCommonModule) {
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)$this$isInAndroidOrCommonModule.getContainingFile());
        if (module == null) {
            return false;
        }
        Module module2 = module;
        return ModuleExtensionsKt.isAndroidModule((Module)module2) || ModuleExtensionsKt.isCommonWithAndroidModule((Module)module2);
    }

    private static final boolean isInTestFile(KtNamedFunction $this$isInTestFile) {
        Project project = $this$isInTestFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ProjectSystemUtil.isTestFile((Project)project, (VirtualFile)$this$isInTestFile.getContainingFile().getVirtualFile());
    }
}

