/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene.layout;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.layout.SingleComponentLayoutAlgorithm;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003456B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010\u001c\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0003J\u0012\u0010!\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\"\u001a\u00020\u00072\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00072\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$H\u0002J\u001e\u0010'\u001a\u00020\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010,\u001a\u00020\u001a2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.2\u0006\u00100\u001a\u00020\u0007H\u0002J\u0014\u00101\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0003J\u001a\u00102\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u00103\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00067"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm;", "Lcom/android/tools/idea/naveditor/scene/layout/SingleComponentLayoutAlgorithm;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "state", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;Lcom/intellij/openapi/module/Module;)V", "_storage", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "tagPositionMap", "Lcom/google/common/collect/BiMap;", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/xml/XmlTag;", "filePositionMap", "", "Lcom/intellij/psi/xml/XmlFile;", "storage", "getStorage", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "doLayout", "", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "reload", "", "file", "force", "positions", "tag", "save", "getPositions", "tryToFindNewNestedGraphPosition", "getPositionsFromPath", "pathWithNulls", "", "", "maybeGetPositionsFromPath", "restorePositionData", "path", "position", "", "getPositionData", "rectifyIds", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "layoutPositions", "getPosition", "setPosition", "canSave", "Point", "LayoutPositions", "Storage", "intellij.android.nav.editor"})
@SourceDebugExtension(value={"SMAP\nManualLayoutAlgorithm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualLayoutAlgorithm.kt\ncom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1368#2:353\n1454#2,5:354\n774#2:360\n865#2,2:361\n1863#2,2:363\n1557#2:365\n1628#2,3:366\n1557#2:369\n1628#2,3:370\n1#3:359\n*S KotlinDebug\n*F\n+ 1 ManualLayoutAlgorithm.kt\ncom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm\n*L\n180#1:353\n180#1:354,5\n214#1:360\n214#1:361,2\n215#1:363,2\n225#1:365\n225#1:366,3\n239#1:369\n239#1:370,3\n*E\n"})
public final class ManualLayoutAlgorithm
extends SingleComponentLayoutAlgorithm {
    @NotNull
    private final Module module;
    @Nullable
    private Storage _storage;
    @NotNull
    private final BiMap<SmartPsiElementPointer<XmlTag>, LayoutPositions> tagPositionMap;
    @NotNull
    private final Map<XmlFile, LayoutPositions> filePositionMap;

    public ManualLayoutAlgorithm(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.module = module;
        HashBiMap hashBiMap = HashBiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashBiMap, (String)"create(...)");
        this.tagPositionMap = (BiMap)hashBiMap;
        this.filePositionMap = new LinkedHashMap();
    }

    private final Storage getStorage() {
        Storage result = this._storage;
        if (result == null) {
            Object object = this.module.getProject().getService(Storage.class);
            Intrinsics.checkNotNull((Object)object);
            this._storage = result = (Storage)object;
        }
        return result;
    }

    @VisibleForTesting
    public ManualLayoutAlgorithm(@NotNull LayoutPositions state, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this(module);
        this._storage = new Storage();
        this.getStorage().setRootPositions$intellij_android_nav_editor(state);
    }

    @Override
    protected boolean doLayout(@NotNull SceneComponent component) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (Intrinsics.areEqual((Object)component.getNlComponent().getClientProperty("skipPersistedLayout"), (Object)true)) {
            return false;
        }
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        if (!NavComponentHelperKt.isDestination(nlComponent)) {
            return false;
        }
        ManualLayoutAlgorithm.reload$default(this, component.getNlComponent().getModel().getFile(), false, 2, null);
        NlComponent nlComponent2 = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"getNlComponent(...)");
        if (NavComponentHelperKt.isNavigation(nlComponent2) && component.getParent() == null) {
            return true;
        }
        LayoutPositions positions = (LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.doLayout$lambda$0(this, component));
        if (positions == null) {
            this.reload(component.getNlComponent().getModel().getFile(), true);
            positions = (LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.doLayout$lambda$1(this, component));
        }
        if (positions == null) {
            positions = this.tryToFindNewNestedGraphPosition(component);
        }
        if ((object = positions) == null || (object = ((LayoutPositions)object).getMyPosition()) == null) {
            return false;
        }
        Object location = object;
        component.setPosition(((Point)location).getX(), ((Point)location).getY());
        return true;
    }

    private final void reload(XmlFile file2, boolean force) {
        if (this.filePositionMap.containsKey(file2) && !force) {
            return;
        }
        LayoutPositions layoutPositions = this.getStorage().getState().get(file2.getName());
        if (layoutPositions == null) {
            return;
        }
        LayoutPositions positions = layoutPositions;
        this.filePositionMap.put(file2, positions);
        ApplicationManager.getApplication().runReadAction(() -> ManualLayoutAlgorithm.reload$lambda$2(file2, this, positions));
    }

    static /* synthetic */ void reload$default(ManualLayoutAlgorithm manualLayoutAlgorithm, XmlFile xmlFile, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        manualLayoutAlgorithm.reload(xmlFile, bl);
    }

    private final void reload(LayoutPositions positions, XmlTag tag) {
        this.tagPositionMap.inverse().remove((Object)positions);
        this.setPosition(tag, positions);
        for (Map.Entry<String, LayoutPositions> entry : positions.getMyPositions().entrySet()) {
            String id = entry.getKey();
            LayoutPositions position = entry.getValue();
            for (XmlTag subtag : tag.getSubTags()) {
                String subtagId = (String)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.reload$lambda$3(subtag));
                if (subtagId == null && Intrinsics.areEqual((Object)subtag.getName(), (Object)"include")) {
                    subtagId = (String)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.reload$lambda$4(subtag));
                }
                if (!Intrinsics.areEqual((Object)subtagId, (Object)id)) continue;
                Intrinsics.checkNotNull((Object)subtag);
                this.reload(position, subtag);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void save(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        if (!NavComponentHelperKt.isDestination(nlComponent)) {
            return;
        }
        Point newPoint = new Point(component.getDrawX(), component.getDrawY());
        Point oldPoint = ((LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.save$lambda$5(this, component))).getMyPosition();
        if (!Intrinsics.areEqual((Object)oldPoint, (Object)newPoint)) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            NlModel nlModel = component.getNlComponent().getModel();
            Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"getModel(...)");
            NlModel model = nlModel;
            if (oldPoint != null) {
                WeakReference<SceneComponent> sceneComponentRef = new WeakReference<SceneComponent>(component);
                NlComponent nlComponent2 = component.getNlComponent();
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"getNlComponent(...)");
                List<String> path = NavComponentHelperKt.getIdPath(nlComponent2);
                WriteCommandAction.writeCommandAction((PsiFile)((PsiFile)model.getFile()), (PsiFile[])new PsiFile[0]).withName("Move Destination").run(() -> ManualLayoutAlgorithm.save$lambda$6(model, component, sceneComponentRef, oldPoint, this, path, newPoint));
            }
            LayoutPositions newPositions = (LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.save$lambda$7(this, component));
            newPositions.setMyPosition(newPoint);
            this.tagPositionMap.inverse().remove((Object)newPositions);
            this.setPosition((XmlTag)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.save$lambda$8(component)), newPositions);
            String string = component.getNlComponent().getModel().getVirtualFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String fileName = string;
            Iterable iterable = (Iterable)model.getTreeReader().getComponents();
            ManualLayoutAlgorithm manualLayoutAlgorithm = this;
            boolean $i$f$flatMap = false;
            void var9_10 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                NlComponent it = (NlComponent)element$iv$iv;
                boolean bl = false;
                List<NlComponent> list = it.getChildren();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            LayoutPositions layoutPositions = this.getStorage().getState().get(fileName);
            Intrinsics.checkNotNull((Object)layoutPositions);
            manualLayoutAlgorithm.rectifyIds(collection, layoutPositions);
        }
    }

    @RequiresReadLock
    private final LayoutPositions getPositions(SceneComponent component) {
        LayoutPositions componentPositions = this.getPosition(component.getNlComponent().getTag());
        if (componentPositions == null) {
            NlComponent nlComponent = component.getNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
            NlComponent nlComponent2 = nlComponent;
            List<String> path = NavComponentHelperKt.getIdPath(nlComponent2);
            componentPositions = this.getPositionsFromPath(path);
        }
        if (componentPositions.getMyPosition() == null) {
            LayoutPositions layoutPositions = this.tryToFindNewNestedGraphPosition(component);
            if (layoutPositions == null) {
                layoutPositions = componentPositions;
            }
            componentPositions = layoutPositions;
        }
        return componentPositions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions tryToFindNewNestedGraphPosition(SceneComponent component) {
        LayoutPositions layoutPositions;
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<String> idPath;
        NlComponent nlComponent = component.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getNlComponent(...)");
        NlComponent nlComponent2 = nlComponent;
        if (!NavComponentHelperKt.isNavigation(nlComponent2)) {
            return null;
        }
        List<String> it = idPath = NavComponentHelperKt.getIdPath(nlComponent2);
        boolean $i$a$-let-ManualLayoutAlgorithm$tryToFindNewNestedGraphPosition$pathPrefix$22 = false;
        List<String> pathPrefix = it.subList(0, it.size() - 1);
        Point averagePoint = new Point(0, 0, 3, null);
        List<NlComponent> list = nlComponent2.getChildren();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
        List<NlComponent> children = list;
        if (children.isEmpty()) {
            return null;
        }
        Iterable $i$a$-let-ManualLayoutAlgorithm$tryToFindNewNestedGraphPosition$pathPrefix$22 = children;
        boolean $i$f$filter = false;
        void var9_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            NlComponent it2 = (NlComponent)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            if (!NavComponentHelperKt.isDestination(it2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NlComponent it3 = (NlComponent)element$iv;
            boolean bl = false;
            Object object = this.maybeGetPositionsFromPath(CollectionsKt.plus((Collection)pathPrefix, (Object)it3.getId()));
            if (object == null || (object = ((LayoutPositions)object).getMyPosition()) == null) {
                return null;
            }
            Object oldChildPosition = object;
            averagePoint.setX(averagePoint.getX() + ((Point)oldChildPosition).getX() / children.size());
            averagePoint.setY(averagePoint.getY() + ((Point)oldChildPosition).getY() / children.size());
        }
        LayoutPositions it4 = layoutPositions = this.getPositionsFromPath(idPath);
        boolean bl = false;
        it4.setMyPosition(averagePoint);
        return layoutPositions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions getPositionsFromPath(List<String> pathWithNulls) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathWithNulls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            if (string2 == null) {
                string2 = "_null";
            }
            collection.add(string2);
        }
        List path = (List)destination$iv$iv;
        LayoutPositions positions = this.getStorage().getState();
        for (String parentId : path) {
            LayoutPositions newPositions = positions.get(parentId);
            if (newPositions == null) {
                newPositions = new LayoutPositions();
                positions.put(parentId, newPositions);
            }
            positions = newPositions;
        }
        return positions;
    }

    /*
     * WARNING - void declaration
     */
    private final LayoutPositions maybeGetPositionsFromPath(List<String> pathWithNulls) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = pathWithNulls;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it;
            if (string2 == null) {
                string2 = "_null";
            }
            collection.add(string2);
        }
        List path = (List)destination$iv$iv;
        LayoutPositions positions = this.getStorage().getState();
        for (String parentId : path) {
            if (positions.get(parentId) != null) continue;
            return null;
        }
        return positions;
    }

    @Override
    public void restorePositionData(@NotNull List<String> path, @NotNull Object position) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (!(position instanceof LayoutPositions)) {
            return;
        }
        LayoutPositions existing = this.getPositionsFromPath(path);
        existing.setMyPosition(((LayoutPositions)position).getMyPosition());
        existing.setMyPositions(((LayoutPositions)position).getMyPositions());
    }

    @Override
    @NotNull
    public LayoutPositions getPositionData(@NotNull SceneComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return (LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.getPositionData$lambda$16(this, component));
    }

    private final void rectifyIds(Collection<? extends NlComponent> components, LayoutPositions layoutPositions) {
        Set seenComponents = new LinkedHashSet();
        for (NlComponent nlComponent : components) {
            String string;
            LayoutPositions cachedPositions;
            LayoutPositions layoutPositions2 = (LayoutPositions)ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.rectifyIds$lambda$17(this, nlComponent));
            if (layoutPositions2 == null) {
                layoutPositions2 = cachedPositions = new LayoutPositions();
            }
            if (NavComponentHelperKt.isInclude(nlComponent)) {
                String string2 = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
                if (string2 != null) {
                    String string3 = string2.substring(12);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = null;
                }
            } else {
                string = nlComponent.getId();
            }
            String id = string;
            LayoutPositions persistedPositions = layoutPositions.get(id);
            if (!Intrinsics.areEqual((Object)cachedPositions, (Object)persistedPositions)) {
                String origId;
                Object v4;
                Map<String, LayoutPositions> idMap;
                block11: {
                    idMap = layoutPositions.getMyPositions();
                    Iterable iterable = idMap.entrySet();
                    for (Object t : iterable) {
                        Map.Entry it = (Map.Entry)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getValue(), (Object)cachedPositions)) continue;
                        v4 = t;
                        break block11;
                    }
                    v4 = null;
                }
                Map.Entry entry = v4;
                String string4 = origId = entry != null ? (String)entry.getKey() : null;
                if (origId != null) {
                    idMap.remove(origId);
                }
                if (id != null) {
                    idMap.put(id, cachedPositions);
                }
            }
            if (id != null) {
                seenComponents.add(id);
            }
            List<NlComponent> list = nlComponent.getChildren();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildren(...)");
            this.rectifyIds((Collection<? extends NlComponent>)list, cachedPositions);
        }
        layoutPositions.getMyPositions().keySet().retainAll(seenComponents);
    }

    @RequiresReadLock
    private final LayoutPositions getPosition(XmlTag tag) {
        LayoutPositions layoutPositions;
        XmlTag xmlTag = tag;
        if (xmlTag != null) {
            XmlTag it = xmlTag;
            boolean bl = false;
            layoutPositions = (LayoutPositions)this.tagPositionMap.get((Object)SmartPointerManager.createPointer((PsiElement)((PsiElement)it)));
        } else {
            layoutPositions = null;
        }
        return layoutPositions;
    }

    private final void setPosition(XmlTag tag, LayoutPositions positions) {
        block0: {
            XmlTag xmlTag = tag;
            if (xmlTag == null) break block0;
            XmlTag it = xmlTag;
            boolean bl = false;
            Object object = ActionsKt.runReadAction(() -> ManualLayoutAlgorithm.setPosition$lambda$21$lambda$20(it));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
            SmartPsiElementPointer pointer = (SmartPsiElementPointer)object;
            ((Map)this.tagPositionMap).put(pointer, positions);
        }
    }

    @Override
    public boolean canSave() {
        return true;
    }

    private static final LayoutPositions doLayout$lambda$0(ManualLayoutAlgorithm this$0, SceneComponent $component) {
        return this$0.getPosition($component.getNlComponent().getTag());
    }

    private static final LayoutPositions doLayout$lambda$1(ManualLayoutAlgorithm this$0, SceneComponent $component) {
        return this$0.getPosition($component.getNlComponent().getTag());
    }

    private static final void reload$lambda$2(XmlFile $file, ManualLayoutAlgorithm this$0, LayoutPositions $positions) {
        XmlTag xmlTag = $file.getRootTag();
        if (xmlTag == null) {
            return;
        }
        XmlTag component = xmlTag;
        this$0.reload($positions, component);
    }

    private static final String reload$lambda$3(XmlTag $subtag) {
        String string;
        String string2 = $subtag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            string = ResourcesUtil.stripPrefixFromId((String)p0);
        } else {
            string = null;
        }
        return string;
    }

    private static final String reload$lambda$4(XmlTag $subtag) {
        String string;
        String string2 = $subtag.getAttributeValue("graph", "http://schemas.android.com/apk/res-auto");
        if (string2 != null) {
            String string3 = string2.substring(12);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string = null;
        }
        return string;
    }

    private static final LayoutPositions save$lambda$5(ManualLayoutAlgorithm this$0, SceneComponent $component) {
        return this$0.getPositions($component);
    }

    private static final void save$lambda$6(NlModel $model, SceneComponent $component, WeakReference $sceneComponentRef, Point $oldPoint, ManualLayoutAlgorithm this$0, List $path, Point $newPoint) {
        VirtualFile[] virtualFileArray = new VirtualFile[]{$model.getVirtualFile()};
        VirtualFile[] virtualFileArray2 = virtualFileArray;
        BasicUndoableAction action2 = new BasicUndoableAction($sceneComponentRef, $oldPoint, this$0, $path, $newPoint, virtualFileArray2){
            final /* synthetic */ WeakReference<SceneComponent> $sceneComponentRef;
            final /* synthetic */ Point $oldPoint;
            final /* synthetic */ ManualLayoutAlgorithm this$0;
            final /* synthetic */ List<String> $path;
            final /* synthetic */ Point $newPoint;
            {
                this.$sceneComponentRef = $sceneComponentRef;
                this.$oldPoint = $oldPoint;
                this.this$0 = $receiver;
                this.$path = $path;
                this.$newPoint = $newPoint;
                super($super_call_param$1);
            }

            public void undo() {
                SceneComponent sceneComponent = (SceneComponent)this.$sceneComponentRef.get();
                if (sceneComponent == null) {
                    return;
                }
                SceneComponent sceneComponent2 = sceneComponent;
                sceneComponent2.setPosition(this.$oldPoint.getX(), this.$oldPoint.getY());
                LayoutPositions positions = ManualLayoutAlgorithm.access$getPositionsFromPath(this.this$0, this.$path);
                positions.setMyPosition(this.$oldPoint);
                ManualLayoutAlgorithm.access$getTagPositionMap$p(this.this$0).inverse().remove((Object)positions);
                sceneComponent2.getScene().getSceneManager().requestRender();
            }

            public void redo() {
                SceneComponent sceneComponent = (SceneComponent)this.$sceneComponentRef.get();
                if (sceneComponent == null) {
                    return;
                }
                SceneComponent sceneComponent2 = sceneComponent;
                sceneComponent2.setPosition(this.$newPoint.getX(), this.$newPoint.getY());
                LayoutPositions positions = ManualLayoutAlgorithm.access$getPositionsFromPath(this.this$0, this.$path);
                positions.setMyPosition(this.$newPoint);
                ManualLayoutAlgorithm.access$getTagPositionMap$p(this.this$0).inverse().remove((Object)positions);
                sceneComponent2.getScene().getSceneManager().requestRender();
            }
        };
        UndoManager.getInstance((Project)$component.getNlComponent().getModel().getProject()).undoableActionPerformed((UndoableAction)action2);
    }

    private static final LayoutPositions save$lambda$7(ManualLayoutAlgorithm this$0, SceneComponent $component) {
        return this$0.getPositions($component);
    }

    private static final XmlTag save$lambda$8(SceneComponent $component) {
        return $component.getNlComponent().getTag();
    }

    private static final LayoutPositions getPositionData$lambda$16(ManualLayoutAlgorithm this$0, SceneComponent $component) {
        return this$0.getPositions($component);
    }

    private static final LayoutPositions rectifyIds$lambda$17(ManualLayoutAlgorithm this$0, NlComponent $component) {
        return this$0.getPosition($component.getTag());
    }

    private static final SmartPsiElementPointer setPosition$lambda$21$lambda$20(XmlTag $it) {
        return SmartPointerManager.createPointer((PsiElement)((PsiElement)$it));
    }

    public static final /* synthetic */ LayoutPositions access$getPositionsFromPath(ManualLayoutAlgorithm $this, List pathWithNulls) {
        return $this.getPositionsFromPath(pathWithNulls);
    }

    public static final /* synthetic */ BiMap access$getTagPositionMap$p(ManualLayoutAlgorithm $this) {
        return $this.tagPositionMap;
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0006H\u0086\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0000R&\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "", "<init>", "()V", "myPositions", "", "", "getMyPositions", "()Ljava/util/Map;", "setMyPositions", "(Ljava/util/Map;)V", "myPosition", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "getMyPosition", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "setMyPosition", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;)V", "get", "id", "put", "", "sub", "intellij.android.nav.editor"})
    public static final class LayoutPositions {
        @NotNull
        private Map<String, LayoutPositions> myPositions = new LinkedHashMap();
        @Nullable
        private Point myPosition;

        @NotNull
        public final Map<String, LayoutPositions> getMyPositions() {
            return this.myPositions;
        }

        public final void setMyPositions(@NotNull Map<String, LayoutPositions> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
            this.myPositions = map2;
        }

        @Nullable
        public final Point getMyPosition() {
            return this.myPosition;
        }

        public final void setMyPosition(@Nullable Point point) {
            this.myPosition = point;
        }

        @Nullable
        public final LayoutPositions get(@Nullable String id) {
            return this.myPositions.get(id);
        }

        public final void put(@NotNull String id, @NotNull LayoutPositions sub) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
            this.myPositions.put(id, sub);
        }
    }

    @VisibleForTesting
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Point;", "", "x", "", "y", "<init>", "(II)V", "getX", "()I", "setX", "(I)V", "getY", "setY", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.nav.editor"})
    public static final class Point {
        private int x;
        private int y;

        @JvmOverloads
        public Point(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public /* synthetic */ Point(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 1) != 0) {
                n = 0;
            }
            if ((n3 & 2) != 0) {
                n2 = 0;
            }
            this(n, n2);
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        @NotNull
        public final Point copy(int x, int y) {
            return new Point(x, y);
        }

        public static /* synthetic */ Point copy$default(Point point, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = point.x;
            }
            if ((n3 & 2) != 0) {
                n2 = point.y;
            }
            return point.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Point(x=" + this.x + ", y=" + this.y + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.x);
            result = result * 31 + Integer.hashCode(this.y);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Point)) {
                return false;
            }
            Point point = (Point)other;
            if (this.x != point.x) {
                return false;
            }
            return this.y == point.y;
        }

        @JvmOverloads
        public Point(int x) {
            this(x, 0, 2, null);
        }

        @JvmOverloads
        public Point() {
            this(0, 0, 3, null);
        }
    }

    @Service(value={Service.Level.PROJECT})
    @State(name="navEditor-manualLayoutAlgorithm2", storages={@com.intellij.openapi.components.Storage(value="navEditor.xml", roamingType=RoamingType.DISABLED)})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R&\u0010\u0005\u001a\u0004\u0018\u00010\u00028\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0004\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$Storage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "<init>", "()V", "rootPositions", "getRootPositions$intellij_android_nav_editor$annotations", "getRootPositions$intellij_android_nav_editor", "()Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;", "setRootPositions$intellij_android_nav_editor", "(Lcom/android/tools/idea/naveditor/scene/layout/ManualLayoutAlgorithm$LayoutPositions;)V", "getState", "loadState", "", "state", "intellij.android.nav.editor"})
    private static final class Storage
    implements PersistentStateComponent<LayoutPositions> {
        @Nullable
        private LayoutPositions rootPositions;

        @Nullable
        public final LayoutPositions getRootPositions$intellij_android_nav_editor() {
            return this.rootPositions;
        }

        public final void setRootPositions$intellij_android_nav_editor(@Nullable LayoutPositions layoutPositions) {
            this.rootPositions = layoutPositions;
        }

        @VisibleForTesting
        public static /* synthetic */ void getRootPositions$intellij_android_nav_editor$annotations() {
        }

        @NotNull
        public LayoutPositions getState() {
            LayoutPositions result = this.rootPositions;
            if (result == null) {
                this.rootPositions = result = new LayoutPositions();
            }
            return result;
        }

        public void loadState(@NotNull LayoutPositions state) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            this.rootPositions = state;
        }
    }
}

