/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.preview.RenderQualityManagerKt;
import com.android.tools.idea.preview.RenderQualityPolicy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/preview/DefaultRenderQualityPolicy;", "Lcom/android/tools/idea/preview/RenderQualityPolicy;", "screenScalingFactorProvider", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "getScreenScalingFactorProvider", "()Lkotlin/jvm/functions/Function0;", "active", "", "acceptedErrorMargin", "", "getAcceptedErrorMargin", "()F", "debounceTimeMillis", "", "getDebounceTimeMillis", "()J", "getTargetQuality", "scale", "isVisible", "activate", "", "deactivate", "Companion", "intellij.android.preview-designer"})
public final class DefaultRenderQualityPolicy
implements RenderQualityPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Double> screenScalingFactorProvider;
    private boolean active;
    private final float acceptedErrorMargin;
    public static final float lowestQuality = 0.001f;

    public DefaultRenderQualityPolicy(@NotNull Function0<Double> screenScalingFactorProvider) {
        Intrinsics.checkNotNullParameter(screenScalingFactorProvider, (String)"screenScalingFactorProvider");
        this.screenScalingFactorProvider = screenScalingFactorProvider;
        this.active = true;
        this.acceptedErrorMargin = 0.05f;
    }

    @NotNull
    public final Function0<Double> getScreenScalingFactorProvider() {
        return this.screenScalingFactorProvider;
    }

    @Override
    public float getAcceptedErrorMargin() {
        return this.acceptedErrorMargin;
    }

    @Override
    public long getDebounceTimeMillis() {
        Object object = StudioFlags.PREVIEW_RENDER_QUALITY_DEBOUNCE_TIME.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return RangesKt.coerceAtLeast((long)((Number)object).longValue(), (long)1L);
    }

    @Override
    public float getTargetQuality(double scale, boolean isVisible) {
        if (!this.active || !isVisible || scale * ((Number)this.screenScalingFactorProvider.invoke()).doubleValue() < (double)Companion.getScaleVisibilityThreshold()) {
            return 0.001f;
        }
        return RangesKt.coerceAtLeast((float)RangesKt.coerceAtMost((float)((float)scale), (float)RenderQualityManagerKt.getDefaultPreviewQuality()), (float)0.001f);
    }

    public final void activate() {
        this.active = true;
    }

    public final void deactivate() {
        this.active = false;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/preview/DefaultRenderQualityPolicy$Companion;", "", "<init>", "()V", "scaleVisibilityThreshold", "", "getScaleVisibilityThreshold", "()F", "lowestQuality", "intellij.android.preview-designer"})
    public static final class Companion {
        private Companion() {
        }

        public final float getScaleVisibilityThreshold() {
            return RangesKt.coerceAtMost((float)RangesKt.coerceAtLeast((float)(((Number)StudioFlags.PREVIEW_RENDER_QUALITY_VISIBILITY_THRESHOLD.get()).floatValue() / 100.0f), (float)0.0f), (float)1.0f);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

