/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.find;

import com.android.tools.preview.AnnotationAttributesProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.text.StringKt;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\t\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\u0004\u0018\u0001H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/preview/find/UastAnnotationAttributesProvider;", "Lcom/android/tools/preview/AnnotationAttributesProvider;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "defaultValues", "", "", "<init>", "(Lorg/jetbrains/uast/UAnnotation;Ljava/util/Map;)V", "getAttributeValue", "T", "attributeName", "(Ljava/lang/String;)Ljava/lang/Object;", "getIntAttribute", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getStringAttribute", "getFloatAttribute", "", "(Ljava/lang/String;)Ljava/lang/Float;", "getBooleanAttribute", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getDeclaredAttributeValue", "findClassNameValue", "name", "intellij.android.preview-designer"})
@SourceDebugExtension(value={"SMAP\nUastAnnotationAttributesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UastAnnotationAttributesProvider.kt\ncom/android/tools/idea/preview/find/UastAnnotationAttributesProvider\n+ 2 UastAnnotationAttributesProvider.kt\ncom/android/tools/idea/preview/find/UastAnnotationAttributesProviderKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n81#2,3:86\n81#2,3:90\n25#3:89\n25#3:93\n25#3:94\n*S KotlinDebug\n*F\n+ 1 UastAnnotationAttributesProvider.kt\ncom/android/tools/idea/preview/find/UastAnnotationAttributesProvider\n*L\n36#1:86,3\n62#1:90,3\n39#1:89\n65#1:93\n75#1:94\n*E\n"})
public final class UastAnnotationAttributesProvider
implements AnnotationAttributesProvider {
    @NotNull
    private final UAnnotation annotation;
    @NotNull
    private final Map<String, String> defaultValues;

    public UastAnnotationAttributesProvider(@NotNull UAnnotation annotation, @NotNull Map<String, String> defaultValues) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        Intrinsics.checkNotNullParameter(defaultValues, (String)"defaultValues");
        this.annotation = annotation;
        this.defaultValues = defaultValues;
    }

    @Nullable
    public <T> T getAttributeValue(@NotNull String attributeName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        try {
            Object object2;
            UExpression expression;
            UExpression uExpression = expression = this.annotation.findAttributeValue(attributeName);
            if (uExpression != null) {
                Object value$iv;
                UExpression $this$getValueOfType$iv = uExpression;
                boolean $i$f$getValueOfType = false;
                Object object3 = $this$getValueOfType$iv.evaluate();
                if (object3 == null) {
                    object3 = null;
                }
                if ((object2 = (value$iv = object3)) == null) {
                    PsiElement psiElement = $this$getValueOfType$iv.getSourcePsi();
                    PsiLiteralExpression psiLiteralExpression = psiElement instanceof PsiLiteralExpression ? (PsiLiteralExpression)psiElement : null;
                    object2 = psiLiteralExpression != null ? psiLiteralExpression.getValue() : null;
                    if (object2 == null) {
                        object2 = null;
                    }
                }
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (IndexNotReadyException e) {
            UastAnnotationAttributesProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UastAnnotationAttributesProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Resolution of " + attributeName + " attempted while index not ready", (Throwable)e);
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public Integer getIntAttribute(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Integer n = (Integer)this.getAttributeValue(attributeName);
        if (n == null) {
            String string = this.defaultValues.get(attributeName);
            n = string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        return n;
    }

    @Nullable
    public String getStringAttribute(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        String string = (String)this.getAttributeValue(attributeName);
        if (string == null || (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) == null) {
            string = this.defaultValues.get(attributeName);
        }
        return string;
    }

    @Nullable
    public Float getFloatAttribute(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Float f = (Float)this.getAttributeValue(attributeName);
        if (f == null) {
            String string = this.defaultValues.get(attributeName);
            f = string != null ? Float.valueOf(Float.parseFloat(string)) : null;
        }
        return f;
    }

    @Nullable
    public Boolean getBooleanAttribute(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Boolean bl = (Boolean)this.getAttributeValue(attributeName);
        if (bl == null) {
            String string = this.defaultValues.get(attributeName);
            bl = string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
        }
        return bl;
    }

    @Nullable
    public <T> T getDeclaredAttributeValue(@NotNull String attributeName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        try {
            Object object2;
            UExpression expression;
            UExpression uExpression = expression = this.annotation.findDeclaredAttributeValue(attributeName);
            if (uExpression != null) {
                Object value$iv;
                UExpression $this$getValueOfType$iv = uExpression;
                boolean $i$f$getValueOfType = false;
                Object object3 = $this$getValueOfType$iv.evaluate();
                if (object3 == null) {
                    object3 = null;
                }
                if ((object2 = (value$iv = object3)) == null) {
                    PsiElement psiElement = $this$getValueOfType$iv.getSourcePsi();
                    PsiLiteralExpression psiLiteralExpression = psiElement instanceof PsiLiteralExpression ? (PsiLiteralExpression)psiElement : null;
                    object2 = psiLiteralExpression != null ? psiLiteralExpression.getValue() : null;
                    if (object2 == null) {
                        object2 = null;
                    }
                }
            } else {
                object2 = null;
            }
            object = object2;
        }
        catch (IndexNotReadyException e) {
            UastAnnotationAttributesProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UastAnnotationAttributesProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Resolution of declared attribute " + attributeName + " attempted while index not ready", (Throwable)e);
            object = null;
        }
        return (T)object;
    }

    @Nullable
    public String findClassNameValue(@NotNull String name) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            UExpression uExpression = this.annotation.findAttributeValue(name);
            UClassLiteralExpression uClassLiteralExpression = uExpression instanceof UClassLiteralExpression ? (UClassLiteralExpression)uExpression : null;
            string = uClassLiteralExpression != null && (uClassLiteralExpression = uClassLiteralExpression.getType()) != null ? uClassLiteralExpression.getCanonicalText() : null;
        }
        catch (IndexNotReadyException e) {
            UastAnnotationAttributesProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(UastAnnotationAttributesProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Resolution of class name " + name + " attempted while index not ready", (Throwable)e);
            string = null;
        }
        return string;
    }
}

