/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssueProviderListener;
import com.android.tools.idea.uibuilder.editor.ResourceFileTrafficLightRendererKt;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0014R:\u0010\b\u001a.\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\r\u00a2\u0006\u0002\b\f0\t\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "severities", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "errorCounts", "", "getErrorCounts", "()[I", "refresh", "", "editorMarkupModel", "Lcom/intellij/openapi/editor/ex/EditorMarkupModel;", "getStatus", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "createUIController", "Lcom/intellij/openapi/editor/markup/UIController;", "ResourceFileUIController", "intellij.android.designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nResourceFileTrafficLightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFileTrafficLightRenderer.kt\ncom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1863#2,2:131\n827#2:133\n855#2,2:134\n1557#2:136\n1628#2,3:137\n*S KotlinDebug\n*F\n+ 1 ResourceFileTrafficLightRenderer.kt\ncom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender\n*L\n70#1:131,2\n83#1:133\n83#1:134,2\n84#1:136\n84#1:137,3\n*E\n"})
public final class ResourceFileTrafficLightRender
extends TrafficLightRenderer {
    @NotNull
    private final List<HighlightSeverity> severities;
    @NotNull
    private final int[] errorCounts;
    public static final int $stable = 8;

    public ResourceFileTrafficLightRender(@NotNull PsiFile file2, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        super(project, editor);
        List list = SeverityRegistrar.getSeverityRegistrar((Project)this.getProject()).getAllSeverities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSeverities(...)");
        this.severities = list;
        this.errorCounts = new int[this.severities.size()];
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(IssueProviderListener.TOPIC, (arg_0, arg_1) -> ResourceFileTrafficLightRender._init_$lambda$0(this, editor, file2, arg_0, arg_1));
    }

    @NotNull
    public int[] getErrorCounts() {
        return this.errorCounts;
    }

    public void refresh(@NotNull EditorMarkupModel editorMarkupModel) {
        Intrinsics.checkNotNullParameter((Object)editorMarkupModel, (String)"editorMarkupModel");
        super.refresh(editorMarkupModel);
        ArraysKt.fill$default((int[])this.getErrorCounts(), (int)0, (int)0, (int)0, (int)6, null);
        List<Issue> issues = IssuePanelService.Companion.getInstance(this.getProject()).getSharedPanelIssues();
        Iterable $this$forEach$iv = issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue it = (Issue)element$iv;
            boolean bl = false;
            int index = this.severities.indexOf(it.getSeverity());
            if (index <= -1) continue;
            int[] nArray = this.getErrorCounts();
            int n = nArray[index];
            nArray[index] = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnalyzerStatus getStatus() {
        void $this$mapTo$iv$iv;
        int it;
        Iterable $this$filterNotTo$iv$iv;
        AnalyzerStatus status = super.getStatus();
        Iterable $this$filterNot$iv = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.getErrorCounts())));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (this.getErrorCounts()[it] == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SeverityRegistrar.getSeverityRegistrar((Project)this.getProject()).getSeverityByIndex(it));
        }
        List nonZeroSeverities = (List)destination$iv$iv;
        List items = new ArrayList();
        List currentItems = status.getExpandedStatus();
        if (currentItems.size() != nonZeroSeverities.size()) {
            return status;
        }
        int n = ((Collection)currentItems).size();
        for (int index = 0; index < n; ++index) {
            StatusItem item = (StatusItem)currentItems.get(index);
            Icon icon2 = (Icon)ResourceFileTrafficLightRendererKt.access$getSEVERITY_TO_ICON$p().get(nonZeroSeverities.get(index));
            if (icon2 == null) {
                icon2 = item.getIcon();
            }
            Icon icon3 = icon2;
            items.add(new StatusItem(item.getText(), icon3, item.getDetailsText(), null, 8, null));
        }
        status.withExpandedStatus(items);
        return status;
    }

    @NotNull
    protected UIController createUIController() {
        return (UIController)new ResourceFileUIController();
    }

    private static final void _init_$lambda$0(ResourceFileTrafficLightRender this$0, Editor $editor, PsiFile $file, Object object, List list) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        if (!this$0.getProject().isDisposed()) {
            ErrorStripeUpdateManager.Companion.getInstance(this$0.getProject()).launchRepaintErrorStripePanel($editor, $file);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender$ResourceFileUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "<init>", "(Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;)V", "toggleProblemsView", "", "intellij.android.designer"})
    private final class ResourceFileUIController
    extends TrafficLightRenderer.DefaultUIController {
        public ResourceFileUIController() {
            super((TrafficLightRenderer)ResourceFileTrafficLightRender.this);
        }

        public void toggleProblemsView() {
            IssuePanelService issuePanelService = IssuePanelService.Companion.getInstance(ResourceFileTrafficLightRender.this.getProject());
            if (issuePanelService.isIssuePanelVisible()) {
                ToolWindow toolWindow = ProblemsView.getToolWindow((Project)ResourceFileTrafficLightRender.this.getProject());
                if (toolWindow != null) {
                    toolWindow.hide();
                }
            } else {
                IssuePanelService.showSharedIssuePanel$default(issuePanelService, false, null, 3, null);
            }
        }
    }
}

