/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.UIBuilderHandlerToken;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BottomAppBarHandler
extends ViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"style", (Object)"backgroundTint", (Object)"navigationIcon", (Object)"fabAlignmentMode", (Object)"fabAnimationMode", (Object)"fabCradleMargin", (Object)"fabCradleRoundedCornerRadius", (Object)"fabCradleVerticalOffset");
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        return new XmlBuilder().startTag(tagName).androidAttribute("layout_width", "match_parent").androidAttribute("layout_height", "wrap_content").androidAttribute("layout_gravity", "bottom").endTag(tagName).toString();
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        Project project = newChild.getModel().getProject();
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)project);
        Optional<UIBuilderHandlerToken> token = UIBuilderHandlerToken.EP_NAME.getExtensionList().stream().filter(it -> it.isApplicable(projectSystem)).findFirst();
        String style = token.isEmpty() ? "Widget.MaterialComponents.BottomAppBar.Colored" : token.get().getBottomAppBarStyle(projectSystem, newChild);
        if (style != null) {
            NlWriteCommandActionUtil.run(newChild, "Setup BottomAppBar", () -> newChild.setAttribute(null, "style", "@style/" + style));
        }
        return super.onCreate(parent, newChild, insertType);
    }
}

