/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.drawing.decorator;

import com.android.tools.idea.uibuilder.handlers.constraint.animation.AnimatedColor;
import java.awt.Color;

public class ColorTheme {
    private static final int sAnimationDuration = 250;
    private final Color mNormalColor;
    private final Color mSelectedColor;
    private final Color mHighlightedColor;
    private final Color mSubduedColor;
    private Look mCurrentLook = Look.NORMAL;
    private AnimatedColor mAnimation;

    public static Color updateBrightness(Color color, float factor) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], Math.max(0.0f, Math.min(hsb[2] * factor, 1.0f))));
    }

    public static Color updateBrightness(Color color, float factor, int alpha) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return new Color(Color.HSBtoRGB(hsb[0], hsb[1], Math.min(1.0f, hsb[2] * factor)) & 0xFFFFFF | alpha << 24, true);
    }

    public static Color fadeToColor(Color source, Color target, float ratio) {
        int r = (int)((1.0f - ratio) * (float)source.getRed() + ratio * (float)target.getRed());
        int g = (int)((1.0f - ratio) * (float)source.getGreen() + ratio * (float)target.getGreen());
        int b = (int)((1.0f - ratio) * (float)source.getBlue() + ratio * (float)target.getBlue());
        int a = (int)((1.0f - ratio) * (float)source.getAlpha() + ratio * (float)target.getAlpha());
        return new Color(r, g, b, a);
    }

    public ColorTheme(Color subdued, Color normal, Color highlighted, Color selected) {
        this.mSubduedColor = subdued;
        this.mNormalColor = normal;
        this.mHighlightedColor = highlighted;
        this.mSelectedColor = selected;
        this.mAnimation = new AnimatedColor(new Color(0, 0, 0, 0), this.mNormalColor);
        this.mAnimation.setDuration(250);
        this.mAnimation.start();
    }

    public Look getLook() {
        return this.mCurrentLook;
    }

    public void setLook(Look look) {
        if (this.mCurrentLook != look) {
            Color currentColor = this.getColor();
            Color targetColor = this.mNormalColor;
            switch (look) {
                case SUBDUED: {
                    targetColor = this.mSubduedColor;
                    break;
                }
                case NORMAL: {
                    targetColor = this.mNormalColor;
                    break;
                }
                case HIGHLIGHTED: {
                    targetColor = this.mHighlightedColor;
                    break;
                }
                case SELECTED: {
                    targetColor = this.mSelectedColor;
                }
            }
            this.mAnimation = new AnimatedColor(currentColor, targetColor);
            this.mAnimation.setDuration(250);
            this.mAnimation.start();
            this.mCurrentLook = look;
        }
    }

    public boolean isAnimating() {
        return this.mAnimation.step();
    }

    public Color getColor() {
        this.mAnimation.step();
        return this.mAnimation.getColor();
    }

    public static enum Look {
        SUBDUED,
        NORMAL,
        HIGHLIGHTED,
        SELECTED;

    }
}

