/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ChainChecker;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintDropHandler {
    private static final int ourSnapMarginDistance = 4;
    @NotNull
    private final SceneComponent myComponent;
    private final ChainChecker myChainChecker = new ChainChecker();

    public ConstraintDropHandler(@NotNull SceneComponent component) {
        this.myComponent = component;
    }

    public void updateAttributes(@NotNull NlAttributesHolder attributes, @NotNull SceneComponent parent, int x, int y) {
        SceneComponent targetStartComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourStartAttributes);
        SceneComponent targetEndComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourEndAttributes);
        SceneComponent targetLeftComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourLeftAttributes);
        SceneComponent targetRightComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourRightAttributes);
        String targetStartMargin = "layout_marginStart";
        String targetEndMargin = "layout_marginEnd";
        boolean useStartEnd = this.myComponent.useRtlAttributes();
        boolean isInRTL = this.myComponent.getScene().isInRTL();
        int dx1 = 0;
        int dx2 = 0;
        if (targetStartComponent == null && targetEndComponent == null) {
            targetStartComponent = targetLeftComponent;
            targetEndComponent = targetRightComponent;
            targetStartMargin = "layout_marginLeft";
            targetEndMargin = "layout_marginRight";
            useStartEnd = false;
            isInRTL = false;
            if (targetStartComponent != null) {
                dx1 = this.getLeftTargetOrigin(targetStartComponent) + this.getMarginValue(targetStartMargin);
            }
            if (targetEndComponent != null) {
                dx2 = this.getRightTargetOrigin(targetEndComponent) - this.getMarginValue(targetEndMargin);
            }
        } else {
            int margin;
            if (targetStartComponent != null) {
                dx1 = this.getStartTargetOrigin(targetStartComponent, isInRTL);
                margin = this.getMarginValue(targetStartMargin);
                dx1 = isInRTL ? (dx1 -= margin) : (dx1 += margin);
            }
            if (targetEndComponent != null) {
                dx2 = this.getEndTargetOrigin(targetEndComponent, isInRTL);
                margin = this.getMarginValue(targetEndMargin);
                dx2 = isInRTL ? (dx2 += margin) : (dx2 -= margin);
            }
        }
        this.myChainChecker.checkIsInChain(this.myComponent);
        if (targetStartComponent != null && targetEndComponent != null) {
            if (!this.myChainChecker.isInHorizontalChain()) {
                float dw = dx2 - dx1 - this.myComponent.getDrawWidth();
                float bias = (float)(x - dx1) / dw;
                if (useStartEnd && isInRTL) {
                    dw = dx1 - dx2 - this.myComponent.getDrawWidth();
                    bias = (dw - (float)(x - dx2)) / dw;
                }
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", biasValue);
            }
        } else if (targetStartComponent != null) {
            dx = x - this.getLeftTargetOrigin(targetStartComponent);
            if (useStartEnd) {
                dx = isInRTL ? this.getStartTargetOrigin(targetStartComponent, true) - (x + this.myComponent.getDrawWidth()) : x - this.getStartTargetOrigin(targetStartComponent, false);
            }
            this.applyMargin(attributes, targetStartMargin, dx);
        } else if (targetEndComponent != null) {
            dx = this.getRightTargetOrigin(targetEndComponent) - (x + this.myComponent.getDrawWidth());
            if (useStartEnd) {
                dx = isInRTL ? x - this.getEndTargetOrigin(targetEndComponent, true) : this.getEndTargetOrigin(targetEndComponent, false) - (x + this.myComponent.getDrawWidth());
            }
            this.applyMargin(attributes, targetEndMargin, dx);
        } else {
            String positionX = String.format(Locale.US, "%ddp", x - parent.getDrawX());
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", positionX);
        }
        SceneComponent targetTopComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourTopAttributes);
        SceneComponent targetBottomComponent = this.getTargetComponent(parent, ConstraintComponentUtilities.ourBottomAttributes);
        if (targetTopComponent != null && targetBottomComponent != null) {
            if (!this.myChainChecker.isInVerticalChain()) {
                int dy2;
                float dh;
                int dy1 = this.getTopTargetOrigin(targetTopComponent) + this.getMarginValue("layout_marginTop");
                float bias = (float)(y - dy1) / (dh = (float)((dy2 = this.getBottomTargetOrigin(targetBottomComponent) - this.getMarginValue("layout_marginBottom")) - dy1 - this.myComponent.getDrawHeight()));
                if (bias < 0.0f) {
                    bias = 0.0f;
                }
                if (bias > 1.0f) {
                    bias = 1.0f;
                }
                String biasValue = null;
                if ((int)(bias * 1000.0f) != 500 && (biasValue = String.valueOf(bias = (float)((int)(bias * 1000.0f)) / 1000.0f)).equalsIgnoreCase("NaN")) {
                    biasValue = null;
                }
                attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", biasValue);
            }
        } else if (targetTopComponent != null) {
            int dy = y - this.getTopTargetOrigin(targetTopComponent);
            this.applyMargin(attributes, "layout_marginTop", dy);
        } else if (targetBottomComponent != null) {
            int dy = this.getBottomTargetOrigin(targetBottomComponent) - (y + this.myComponent.getDrawHeight());
            this.applyMargin(attributes, "layout_marginBottom", dy);
        } else {
            String positionY = String.format(Locale.US, "%ddp", y - parent.getDrawY());
            attributes.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", positionY);
        }
        ConstraintComponentUtilities.cleanup(attributes, this.myComponent.getNlComponent());
    }

    @Nullable
    private SceneComponent getTargetComponent(@NotNull SceneComponent parent, @NotNull ArrayList<String> attributes) {
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String target = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", attributes.get(i));
            if (target == null) continue;
            if (target.equalsIgnoreCase("parent")) {
                return parent;
            }
            if ((target = NlComponent.extractId(target)) == null) continue;
            return this.myComponent.getScene().getSceneComponent(target);
        }
        return null;
    }

    private void applyMargin(NlAttributesHolder attributes, String attribute, int currentValue) {
        currentValue = Math.max(0, currentValue);
        currentValue = currentValue / 4 * 4;
        String marginString = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res/android", attribute);
        int marginValue = -1;
        if (marginString != null) {
            marginValue = this.getMarginValue(attribute);
        }
        if (currentValue == 0) {
            attributes.removeAttribute("http://schemas.android.com/apk/res/android", attribute);
            if ("layout_marginEnd".equals(attribute)) {
                attributes.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
            } else if ("layout_marginStart".equals(attribute)) {
                attributes.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
            }
        } else if (marginValue != -1 && marginValue == currentValue) {
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginString);
            if ("layout_marginEnd".equals(attribute)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", marginString);
            } else if ("layout_marginStart".equals(attribute)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", marginString);
            }
        } else {
            String marginY = String.format(Locale.US, "%ddp", currentValue);
            attributes.setAttribute("http://schemas.android.com/apk/res/android", attribute, marginY);
            if ("layout_marginEnd".equals(attribute)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", marginY);
            } else if ("layout_marginStart".equals(attribute)) {
                attributes.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", marginY);
            }
        }
    }

    private int getStartTargetOrigin(@NotNull SceneComponent target, boolean isInRtl) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf") != null) {
            return isInRtl ? origin : origin + target.getDrawWidth();
        }
        NlComponent parent = target.getAuthoritativeNlComponent();
        return isInRtl ? origin + target.getDrawWidth() - this.getPadding(parent, true)[0] : origin + this.getPadding(parent, false)[0];
    }

    private int getEndTargetOrigin(@NotNull SceneComponent target, boolean isInRtl) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf") != null) {
            NlComponent parent = target.getAuthoritativeNlComponent();
            return isInRtl ? origin + this.getPadding(parent, true)[2] : origin + target.getDrawWidth() - this.getPadding(parent, false)[2];
        }
        NlComponent parent = target.getAuthoritativeNlComponent();
        return isInRtl ? origin + target.getDrawWidth() - this.getPadding(parent, true)[0] : origin + this.getPadding(parent, false)[0];
    }

    private int getLeftTargetOrigin(@NotNull SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf") != null) {
            return origin + target.getDrawWidth();
        }
        NlComponent parent = target.getAuthoritativeNlComponent();
        return origin + this.getPadding(parent, false)[0];
    }

    private int getRightTargetOrigin(@NotNull SceneComponent target) {
        int origin = target.getDrawX();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        NlComponent parent = target.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf") != null) {
            return origin + target.getDrawWidth() - this.getPadding(parent, false)[2];
        }
        return origin + this.getPadding(parent, false)[0];
    }

    protected int getTopTargetOrigin(@NotNull SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf") != null) {
            return origin + target.getDrawHeight();
        }
        NlComponent parent = target.getAuthoritativeNlComponent();
        return origin + this.getPadding(parent, false)[1];
    }

    private int getBottomTargetOrigin(@NotNull SceneComponent target) {
        int origin = target.getDrawY();
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        NlComponent parent = target.getAuthoritativeNlComponent();
        if (nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf") != null) {
            return origin + target.getDrawHeight() - this.getPadding(parent, false)[3];
        }
        return origin + this.getPadding(parent, false)[1];
    }

    private int getMarginValue(String attribute) {
        NlComponent nlComponent = this.myComponent.getAuthoritativeNlComponent();
        return ConstraintComponentUtilities.getDpValue(nlComponent, nlComponent.getAttribute("http://schemas.android.com/apk/res/android", attribute));
    }

    private int[] getPadding(NlComponent component, boolean isRtl) {
        int paddingValue;
        int[] padding = new int[]{-1, -1, -1, -1};
        String paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingStart");
        if (paddingAttr != null) {
            padding[0] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
        }
        if ((paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingEnd")) != null) {
            padding[2] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
        }
        if ((paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "padding")) != null) {
            int paddingValue2 = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            padding[0] = padding[0] == -1 ? paddingValue2 : padding[0];
            padding[1] = paddingValue2;
            padding[2] = padding[2] == -1 ? paddingValue2 : padding[2];
            padding[3] = paddingValue2;
            return padding;
        }
        paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingVertical");
        if (paddingAttr != null) {
            padding[1] = paddingValue = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            padding[3] = paddingValue;
        } else {
            paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingTop");
            padding[1] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingBottom");
            padding[3] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
        }
        if (padding[0] > -1 && padding[2] > -1) {
            return padding;
        }
        paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", "paddingHorizontal");
        if (paddingAttr != null) {
            paddingValue = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            padding[0] = padding[0] == -1 ? paddingValue : padding[0];
            padding[2] = padding[2] == -1 ? paddingValue : padding[2];
        } else {
            if (padding[0] == -1) {
                paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", isRtl ? "paddingRight" : "paddingLeft");
                padding[0] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            }
            if (padding[2] == -1) {
                paddingAttr = component.getAttribute("http://schemas.android.com/apk/res/android", isRtl ? "paddingLeft" : "paddingRight");
                padding[2] = ConstraintComponentUtilities.getDpValue(component, paddingAttr);
            }
        }
        return padding;
    }
}

