/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.grid;

import com.android.AndroidXConstants;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.grid.CellInfo;
import com.android.tools.idea.uibuilder.handlers.grid.GridBarriers;
import com.android.tools.idea.uibuilder.handlers.grid.InsetsAttributes;
import com.android.tools.idea.uibuilder.model.Insets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001b\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0012H\u0002\u001a\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"getGridBarriers", "Lcom/android/tools/idea/uibuilder/handlers/grid/GridBarriers;", "gridComponent", "Lcom/android/tools/idea/common/scene/SceneComponent;", "retrieveCellData", "Lcom/android/tools/idea/uibuilder/handlers/grid/CellInfo;", "nlComponent", "Lcom/android/tools/idea/common/model/NlComponent;", "isSupportLibrary", "", "getLiveAndroidAttribute", "", "Lorg/jetbrains/annotations/Nullable;", "androidAttribute", "retrieveMargins", "Lcom/android/tools/idea/uibuilder/model/Insets;", "retrievePaddings", "PADDING_ATTRIBUTES", "Lcom/android/tools/idea/uibuilder/handlers/grid/InsetsAttributes;", "MARGIN_ATTRIBUTES", "retrieveInsets", "attrs", "getPxValue", "", "value", "intellij.android.designer"})
public final class GridUtilsKt {
    @NotNull
    private static final InsetsAttributes PADDING_ATTRIBUTES = new InsetsAttributes("padding", (Pair<String, String>)new Pair((Object)"paddingStart", (Object)"paddingLeft"), "paddingTop", (Pair<String, String>)new Pair((Object)"paddingEnd", (Object)"paddingRight"), "paddingBottom");
    @NotNull
    private static final InsetsAttributes MARGIN_ATTRIBUTES = new InsetsAttributes("layout_margin", (Pair<String, String>)new Pair((Object)"layout_marginStart", (Object)"layout_marginLeft"), "layout_marginTop", (Pair<String, String>)new Pair((Object)"layout_marginEnd", (Object)"layout_marginRight"), "layout_marginBottom");

    @NotNull
    public static final GridBarriers getGridBarriers(@NotNull SceneComponent gridComponent) {
        Intrinsics.checkNotNullParameter((Object)gridComponent, (String)"gridComponent");
        boolean isSupportLibrary = AndroidXConstants.GRID_LAYOUT_V7.isEquals(gridComponent.getNlComponent().getTagName());
        NlComponent nlComponent = gridComponent.getAuthoritativeNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"getAuthoritativeNlComponent(...)");
        Insets padding = GridUtilsKt.retrievePaddings(nlComponent);
        int left = gridComponent.getDrawX() + GridUtilsKt.getGridBarriers$toDp(padding.left, gridComponent);
        int top = gridComponent.getDrawY() + GridUtilsKt.getGridBarriers$toDp(padding.top, gridComponent);
        int right = gridComponent.getDrawX() + gridComponent.getDrawWidth() - GridUtilsKt.getGridBarriers$toDp(padding.right, gridComponent);
        int bottom = gridComponent.getDrawY() + gridComponent.getDrawHeight() - GridUtilsKt.getGridBarriers$toDp(padding.bottom, gridComponent);
        List<SceneComponent> children = gridComponent.getChildren();
        HashMap rowMap = new HashMap();
        HashMap columnMap = new HashMap();
        int previousRow = 0;
        int previousColumn = -1;
        for (SceneComponent child : children) {
            Integer n;
            Integer n2;
            Object object;
            Map map2;
            if (child instanceof TemporarySceneComponent) continue;
            NlComponent nlComponent2 = child.getAuthoritativeNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent2, (String)"getAuthoritativeNlComponent(...)");
            CellInfo cellData = GridUtilsKt.retrieveCellData(nlComponent2, isSupportLibrary);
            if (cellData.getColumn() == -1) {
                cellData.setColumn(previousColumn + 1);
            }
            if (cellData.getRow() == -1) {
                cellData.setRow(previousRow);
            }
            NlComponent nlComponent3 = child.getAuthoritativeNlComponent();
            Intrinsics.checkNotNullExpressionValue((Object)nlComponent3, (String)"getAuthoritativeNlComponent(...)");
            Insets marginInsets = GridUtilsKt.retrieveMargins(nlComponent3);
            int cellLeft = child.getDrawX() - GridUtilsKt.getGridBarriers$toDp(marginInsets.left, gridComponent);
            int cellTop = child.getDrawY() - GridUtilsKt.getGridBarriers$toDp(marginInsets.top, gridComponent);
            int cellRight = child.getDrawX() + child.getDrawWidth() + GridUtilsKt.getGridBarriers$toDp(marginInsets.right, gridComponent);
            int cellBottom = child.getDrawY() + child.getDrawHeight() + GridUtilsKt.getGridBarriers$toDp(marginInsets.bottom, gridComponent);
            if (cellData.getColumn() != 0) {
                map2 = columnMap;
                object = cellData.getColumn();
                Integer n3 = (Integer)columnMap.get(cellData.getColumn());
                int n4 = n3 != null ? n3 : Integer.MAX_VALUE;
                n2 = Math.min(cellLeft, n4);
                map2.put(object, n2);
            }
            if (cellData.getRow() != 0) {
                map2 = rowMap;
                object = cellData.getRow();
                Integer n5 = (Integer)rowMap.get(cellData.getRow());
                int n6 = n5 != null ? n5 : Integer.MAX_VALUE;
                n2 = Math.min(cellTop, n6);
                map2.put(object, n2);
            }
            if (cellData.getColumn() != -1 && cellData.getColumnSpan() != 0) {
                int rightIndex = cellData.getColumn() + cellData.getColumnSpan();
                object = columnMap;
                n2 = rightIndex;
                Integer n7 = (Integer)columnMap.get(rightIndex);
                int n8 = n7 != null ? n7 : Integer.MIN_VALUE;
                n = Math.max(cellRight, n8);
                object.put(n2, n);
            }
            if (cellData.getRow() != -1 && cellData.getRowSpan() != 0) {
                int bottomIndex = cellData.getRow() + cellData.getRowSpan();
                object = rowMap;
                n2 = bottomIndex;
                Integer n9 = (Integer)rowMap.get(bottomIndex);
                int n10 = n9 != null ? n9 : Integer.MIN_VALUE;
                n = Math.max(cellBottom, n10);
                object.put(n2, n);
            }
            previousRow = cellData.getRow();
            previousColumn = cellData.getColumn();
        }
        Set set = columnMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)set);
        int columnCount = n != null ? n + 1 : 1;
        Set set2 = rowMap.keySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"<get-keys>(...)");
        Integer n11 = (Integer)CollectionsKt.maxOrNull((Iterable)set2);
        int rowCount = n11 != null ? n11 + 1 : 1;
        ((Map)columnMap).put(0, left);
        ((Map)columnMap).put(columnCount, right);
        ((Map)rowMap).put(0, top);
        ((Map)rowMap).put(rowCount, bottom);
        return new GridBarriers(rowMap, columnMap);
    }

    private static final CellInfo retrieveCellData(NlComponent nlComponent, boolean isSupportLibrary) {
        String namespace = isSupportLibrary ? "http://schemas.android.com/apk/res-auto" : "http://schemas.android.com/apk/res/android";
        Function2 getAttribute = (arg_0, arg_1) -> GridUtilsKt.retrieveCellData$lambda$0(nlComponent, namespace, arg_0, arg_1);
        return new CellInfo(((Number)getAttribute.invoke((Object)"layout_row", (Object)-1)).intValue(), ((Number)getAttribute.invoke((Object)"layout_column", (Object)-1)).intValue(), ((Number)getAttribute.invoke((Object)"layout_rowSpan", (Object)1)).intValue(), ((Number)getAttribute.invoke((Object)"layout_columnSpan", (Object)1)).intValue());
    }

    private static final String getLiveAndroidAttribute(NlComponent $this$getLiveAndroidAttribute, String androidAttribute) {
        return $this$getLiveAndroidAttribute.getLiveAttribute("http://schemas.android.com/apk/res/android", androidAttribute);
    }

    private static final Insets retrieveMargins(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, MARGIN_ATTRIBUTES);
    }

    private static final Insets retrievePaddings(NlComponent nlComponent) {
        return GridUtilsKt.retrieveInsets(nlComponent, PADDING_ATTRIBUTES);
    }

    private static final Insets retrieveInsets(NlComponent nlComponent, InsetsAttributes attrs) {
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        String valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getAll());
        if (valueString != null) {
            int padding;
            left = padding = GridUtilsKt.getPxValue(nlComponent, valueString);
            top = padding;
            right = padding;
            bottom = padding;
        } else {
            String string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getFirst());
            if (string == null) {
                string = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getLeft().getSecond());
            }
            valueString = string;
            left = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getTop());
            top = GridUtilsKt.getPxValue(nlComponent, valueString);
            String string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getFirst());
            if (string2 == null) {
                string2 = GridUtilsKt.getLiveAndroidAttribute(nlComponent, (String)attrs.getRight().getSecond());
            }
            valueString = string2;
            right = GridUtilsKt.getPxValue(nlComponent, valueString);
            valueString = GridUtilsKt.getLiveAndroidAttribute(nlComponent, attrs.getBottom());
            bottom = GridUtilsKt.getPxValue(nlComponent, valueString);
        }
        return new Insets(left, top, right, bottom);
    }

    private static final int getPxValue(NlComponent nlComponent, String value) {
        if (value != null) {
            Configuration configuration = nlComponent.getModel().getConfiguration();
            Integer n = ViewEditor.resolveDimensionPixelSize(value, configuration);
            return n != null ? n : 0;
        }
        return 0;
    }

    private static final int getGridBarriers$toDp(int $this$getGridBarriers_u24toDp, SceneComponent $gridComponent) {
        return Coordinates.pxToDp($gridComponent.getScene().getSceneManager(), $this$getGridBarriers_u24toDp);
    }

    private static final int retrieveCellData$lambda$0(NlComponent $nlComponent, String $namespace, String name, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = $nlComponent.getLiveAttribute($namespace, name);
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
    }
}

