/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.actions;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewActionPresentation;
import com.android.tools.idea.uibuilder.handlers.linear.LinearLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.linear.actions.LinearLayoutAction;
import icons.StudioIcons;
import java.util.List;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class BaselineAction
extends LinearLayoutAction {
    @Override
    public void perform(@NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
        if (!selectedChildren.isEmpty()) {
            boolean align = !BaselineAction.isBaselineAligned(selectedChildren.get(0));
            for (NlComponent selected : selectedChildren) {
                selected.setAttribute("http://schemas.android.com/apk/res/android", "baselineAligned", align ? null : "false");
            }
        }
    }

    @Override
    public void updatePresentation(@NotNull ViewActionPresentation presentation, @NotNull ViewEditor editor, @NotNull LinearLayoutHandler handler, @NotNull NlComponent component, @NotNull List<NlComponent> selectedChildren, @JdkConstants.InputEventMask int modifiers) {
        if (selectedChildren.isEmpty()) {
            presentation.setVisible(false);
        } else {
            presentation.setVisible(true);
            boolean align = !BaselineAction.isBaselineAligned(selectedChildren.get(0));
            presentation.setIcon(align ? StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED : StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_OFF);
            presentation.setLabel(align ? "Align with the baseline" : "Do not align with the baseline");
        }
    }

    private static boolean isBaselineAligned(NlComponent component) {
        String value = component.getAttribute("http://schemas.android.com/apk/res/android", "baselineAligned");
        return value == null || Boolean.parseBoolean(value);
    }
}

