/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.linear.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Graphics2D;

public class DrawLinearPlaceholder
extends DrawRegion {
    public DrawLinearPlaceholder(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        Color defColor = g.getColor();
        ColorSet colorSet = sceneContext.getColorSet();
        g.setColor(colorSet.getDragReceiverBackground());
        g.fill(this);
        g.setColor(colorSet.getDragReceiverFrames());
        g.draw(this);
        g.setColor(defColor);
    }

    @Override
    public int getLevel() {
        return 50;
    }

    public static void add(DisplayList list, SceneContext context, boolean isLayoutVertical, boolean atEnd, int highLightSize, float left, float top, float right, float bottom) {
        int x = context.getSwingXDip(left);
        int y = context.getSwingYDip(top);
        int width = context.getSwingDimensionDip(right - left);
        int height = context.getSwingDimensionDip(bottom - top);
        highLightSize = context.getSwingDimensionDip(highLightSize);
        if (isLayoutVertical) {
            if (!atEnd) {
                y -= highLightSize / 2;
            }
            height = highLightSize;
        } else {
            if (!atEnd) {
                x -= highLightSize / 2;
            }
            width = highLightSize;
        }
        list.add(new DrawLinearPlaceholder(x, y, JBUI.scale((int)width), JBUI.scale((int)height)));
    }
}

