/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import android.widget.ListView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.DragHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.graphics.NlDrawingStyle;
import com.android.tools.idea.uibuilder.graphics.NlGraphics;
import com.android.tools.idea.uibuilder.handlers.preference.ViewInfoUtils;
import java.awt.Rectangle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

abstract class PreferenceGroupDragHandler
extends DragHandler {
    SceneComponent myGroup;
    Map<SceneComponent, Rectangle> myPreferenceToBoundsMap;
    private SceneComponent myActivePreference;
    private int myDividerHeight;

    PreferenceGroupDragHandler(@NotNull ViewEditor editor, @NotNull ViewGroupHandler handler, @NotNull SceneComponent group, @NotNull List<NlComponent> preferences, @NotNull DragType type) {
        super(editor, handler, group, preferences, type);
        this.myGroup = group;
        this.initDividerHeight();
        this.myPreferenceToBoundsMap = this.getPreferenceToBoundsMap(group);
    }

    private void initDividerHeight() {
        ViewInfo listView = ViewInfoUtils.findViewWithName(this.editor.getRootViews(), "android.widget.ListView");
        this.myDividerHeight = listView != null ? this.editor.pxToDp(((ListView)listView.getViewObject()).getDividerHeight()) : 0;
    }

    @NotNull
    final Map<SceneComponent, Rectangle> getPreferenceToBoundsMap(@NotNull SceneComponent group) {
        return group.getChildren().stream().collect(Collectors.toMap(Function.identity(), this::getBounds));
    }

    @NotNull
    final Rectangle getBounds(@NotNull SceneComponent preference) {
        int height = preference.getDrawHeight() + this.myDividerHeight;
        if (preference.getNlComponent().getTagName().equals("PreferenceCategory")) {
            height += preference.getChildren().stream().mapToInt(child -> child.getDrawHeight() + this.myDividerHeight).sum();
        }
        return new Rectangle(preference.getDrawX(), preference.getDrawY(), preference.getDrawWidth(), height);
    }

    final void updateActivePreference() {
        List<SceneComponent> preferences = this.myGroup.getChildren();
        if (this.lastY < preferences.get(0).getDrawY()) {
            this.myActivePreference = preferences.get(0);
        } else {
            Optional<SceneComponent> activePreference = this.myPreferenceToBoundsMap.keySet().stream().filter(preference -> this.myPreferenceToBoundsMap.get(preference).contains(this.lastX, this.lastY)).findFirst();
            this.myActivePreference = activePreference.orElse(preferences.get(preferences.size() - 1));
        }
    }

    @Override
    public final void paint(@NotNull NlGraphics graphics) {
        this.drawDropPreviewLine(graphics);
        this.drawDropRecipientLines(graphics);
        this.drawDropZoneLines(graphics);
    }

    void drawDropPreviewLine(@NotNull NlGraphics graphics) {
        graphics.useStyle(NlDrawingStyle.DROP_PREVIEW);
        Rectangle bounds2 = this.myPreferenceToBoundsMap.get(this.myActivePreference);
        if (this.lastY < PreferenceGroupDragHandler.getMidpointY(bounds2)) {
            graphics.drawTopDp(bounds2);
        } else {
            graphics.drawBottomDp(bounds2);
        }
    }

    abstract void drawDropRecipientLines(@NotNull NlGraphics var1);

    abstract void drawDropZoneLines(@NotNull NlGraphics var1);

    final void drawDropZoneLines(@NotNull NlGraphics graphics, int startingIndex) {
        List<SceneComponent> preferences = this.myGroup.getChildren();
        if (preferences.isEmpty()) {
            return;
        }
        graphics.useStyle(NlDrawingStyle.DROP_ZONE);
        int midpointY = this.getMidpointY(this.myActivePreference);
        int size = preferences.size();
        for (int i = startingIndex; i < size; ++i) {
            SceneComponent preference = preferences.get(i);
            if (i != 0 && this.myActivePreference == preferences.get(i - 1)) {
                if (this.lastY >= midpointY) continue;
                graphics.drawTop(preference.getNlComponent());
                continue;
            }
            if (this.myActivePreference == preference) {
                if (this.lastY < midpointY) continue;
                graphics.drawTop(preference.getNlComponent());
                continue;
            }
            graphics.drawTop(preference.getNlComponent());
        }
    }

    @Override
    public final void commit(int x, int y, int modifiers, @NotNull InsertType type) {
        List<SceneComponent> preferences = this.myGroup.getChildren();
        if (preferences.isEmpty()) {
            this.editor.insertChildren(this.layout.getNlComponent(), this.components, -1, type);
            return;
        }
        int i = preferences.indexOf(this.myActivePreference);
        if (this.lastY >= this.getMidpointY(this.myActivePreference)) {
            ++i;
        }
        this.editor.insertChildren(this.layout.getNlComponent(), this.components, i == preferences.size() ? -1 : i, type);
    }

    final int getMidpointY(@NotNull SceneComponent preference) {
        return PreferenceGroupDragHandler.getMidpointY(this.myPreferenceToBoundsMap.get(preference));
    }

    private static int getMidpointY(@NotNull Rectangle bounds2) {
        return bounds2.y + bounds2.height / 2;
    }
}

