/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.ide.common.repository.WellKnownMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.RegisteringModuleSystem;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.ide.PooledThreadExecutor;

public class DependencyManager
implements Disposable {
    private final Project myProject;
    private final List<DependencyChangeListener> myListeners;
    private final AtomicReference<Set<GoogleMavenArtifactId>> myMissingLibraries;
    private final AtomicBoolean myUseAndroidXDependencies;
    private final Object mySync;
    private Module myModule;
    private Palette myPalette;
    private boolean myRegisteredForDependencyUpdates;
    private boolean myNotifyAlways;
    private Consumer<Future<?>> mySyncTopicConsumer;

    public DependencyManager(@NotNull Project project) {
        this.myProject = project;
        this.myMissingLibraries = new AtomicReference(Collections.emptySet());
        this.myUseAndroidXDependencies = new AtomicBoolean(false);
        this.myListeners = new ArrayList<DependencyChangeListener>(2);
        this.myPalette = Palette.EMPTY;
        this.mySyncTopicConsumer = future -> {};
        this.mySync = new Object();
    }

    public void addDependencyChangeListener(@NotNull DependencyChangeListener listener2) {
        this.myListeners.add(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPalette(@NotNull Palette palette, @NotNull Module module) {
        Object object = this.mySync;
        synchronized (object) {
            this.myPalette = palette;
            this.myModule = module;
        }
        this.checkForRelevantDependencyChanges();
        this.registerDependencyUpdates();
        ApplicationManager.getApplication().invokeLater(() -> this.myListeners.forEach(listener2 -> listener2.onDependenciesChanged()));
    }

    public boolean useAndroidXDependencies() {
        return this.myUseAndroidXDependencies.get();
    }

    public boolean needsLibraryLoad(@NotNull Palette.Item item) {
        return this.myMissingLibraries.get().contains(item.getGradleCoordinateId());
    }

    @TestOnly
    public void setSyncTopicListener(@NotNull Consumer<Future<?>> listener2) {
        this.mySyncTopicConsumer = listener2;
    }

    @TestOnly
    public void setNotifyAlways(boolean notifyAlways) {
        this.myNotifyAlways = notifyAlways;
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForRelevantDependencyChanges() {
        Object object = this.mySync;
        synchronized (object) {
            return this.checkForNewMissingDependencies() | this.checkForNewAndroidXDependencies();
        }
    }

    private boolean checkForNewAndroidXDependencies() {
        boolean useAndroidX = this.computeUseAndroidXDependencies();
        if (useAndroidX == this.myUseAndroidXDependencies.get()) {
            return false;
        }
        this.myUseAndroidXDependencies.set(useAndroidX);
        return true;
    }

    private boolean checkForNewMissingDependencies() {
        Object missing = Collections.emptySet();
        if (this.myModule != null && !this.myModule.isDisposed() && !this.myProject.isDisposed()) {
            RegisteringModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)this.myModule).getRegisteringModuleSystem();
            missing = moduleSystem != null ? (Set)this.myPalette.getGoogleMavenArtifactIds().stream().filter(id -> !moduleSystem.hasRegisteredDependency((WellKnownMavenArtifactId)id)).collect(ImmutableSet.toImmutableSet()) : ImmutableSet.copyOf(this.myPalette.getGoogleMavenArtifactIds());
            if (this.myMissingLibraries.get().equals(missing)) {
                return false;
            }
        }
        this.myMissingLibraries.set((Set<GoogleMavenArtifactId>)missing);
        return true;
    }

    private void registerDependencyUpdates() {
        if (this.myRegisteredForDependencyUpdates || this.myProject.isDisposed()) {
            return;
        }
        this.myRegisteredForDependencyUpdates = true;
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result -> this.mySyncTopicConsumer.accept(this.ensureRunningOnBackgroundThread(() -> {
            if (result == ProjectSystemSyncManager.SyncResult.SUCCESS && this.checkForRelevantDependencyChanges() || this.myNotifyAlways) {
                ApplicationManager.getApplication().invokeLater(() -> this.myListeners.forEach(listener2 -> listener2.onDependenciesChanged()));
            }
        })));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLibraryIsIncluded(@NotNull Palette.Item item) {
        GoogleMavenArtifactId id;
        if (this.needsLibraryLoad(item) && (id = item.getGradleCoordinateId()) != null) {
            Object object = this.mySync;
            synchronized (object) {
                DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)this.myModule, Set.of(id), (boolean)true);
            }
        }
    }

    private boolean computeUseAndroidXDependencies() {
        if (this.myProject.isDisposed() || this.myModule == null || this.myModule.isDisposed()) {
            return true;
        }
        return ProjectSystemUtil.getModuleSystem((Module)this.myModule).getUseAndroidX();
    }

    private Future<?> ensureRunningOnBackgroundThread(@NotNull Runnable runnable) {
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(runnable, PooledThreadExecutor.INSTANCE);
            Disposable taskCanceller = () -> future.cancel(true);
            Disposer.register((Disposable)this, (Disposable)taskCanceller);
            return future.whenComplete((r, e) -> Disposer.dispose((Disposable)taskCanceller));
        }
        runnable.run();
        return Futures.immediateFuture(null);
    }

    public static interface DependencyChangeListener {
        public void onDependenciesChanged();
    }
}

