/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.common.StudioColorsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.ListExpandableItemsHandler;
import com.intellij.ui.components.JBList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public abstract class ListWithMargin<E>
extends JBList<E> {
    public ListWithMargin() {
        this.setSelectionMode(0);
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
    }

    protected abstract int getRightMarginWidth();

    @NotNull
    protected ExpandableItemsHandler<Integer> createExpandableItemsHandler() {
        return new ListWithMarginExpandableItemsHandler(this);
    }

    private static class ListWithMarginExpandableItemsHandler
    extends ListExpandableItemsHandler {
        private Integer myExpansionIndex;

        protected ListWithMarginExpandableItemsHandler(@NotNull ListWithMargin list) {
            super((JList)((Object)list));
            ((JList)this.myComponent).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(@NotNull MouseEvent event) {
                    this.hideExpansion();
                }
            });
        }

        private int getRightMarginWidth() {
            return ((ListWithMargin)((Object)this.myComponent)).getRightMarginWidth();
        }

        @NotNull
        public Collection<Integer> getExpandedItems() {
            Collection popup2 = super.getExpandedItems();
            if (!popup2.isEmpty()) {
                return popup2;
            }
            return this.myExpansionIndex == null ? Collections.emptyList() : Collections.singleton(this.myExpansionIndex);
        }

        protected Pair<Component, Rectangle> getCellRendererAndBounds(@NotNull Integer index) {
            Pair rendererAndBounds = super.getCellRendererAndBounds(index);
            if (rendererAndBounds == null) {
                this.hideExpansion();
                return null;
            }
            Rectangle bounds2 = (Rectangle)rendererAndBounds.second;
            if (bounds2.width > ((JList)this.myComponent).getWidth() - this.getRightMarginWidth() && bounds2.width < ((JList)this.myComponent).getWidth()) {
                this.myExpansionIndex = index;
                Rectangle cellBounds = ((JList)this.myComponent).getCellBounds(this.myExpansionIndex, this.myExpansionIndex);
                if (cellBounds != null) {
                    ((JList)this.myComponent).repaint(cellBounds);
                }
                return null;
            }
            this.hideExpansion();
            return rendererAndBounds;
        }

        protected void onFocusLost() {
            super.onFocusLost();
            this.hideExpansion();
        }

        private void hideExpansion() {
            Rectangle bounds2;
            if (this.myExpansionIndex != null && (bounds2 = ((JList)this.myComponent).getCellBounds(this.myExpansionIndex, this.myExpansionIndex)) != null) {
                ((JList)this.myComponent).repaint(bounds2);
            }
            this.myExpansionIndex = null;
        }
    }
}

