/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.ScoutArrange;
import com.android.tools.idea.uibuilder.scout.ScoutWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class ScoutChains {
    static final int MAX_ERROR = 1000;
    static final int MIN_SPREAD = 3;
    private static final boolean DEBUG = true;

    public static void pick(ScoutWidget[] list) {
        ChainMode chain_mode;
        int errorPacked;
        int[] marginsPacked;
        int errorInside;
        int[] marginsInside;
        int errorSpread;
        int[] marginsSpread;
        int[] margins;
        Dir dir;
        ScoutWidget[] group;
        ScoutWidget child;
        int i;
        ScoutWidget base = list[0];
        ScoutWidget[] children = new ScoutWidget[list.length - 1];
        System.arraycopy(list, 1, children, 0, children.length);
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            child.mCheckedForChain = child.isConnected(Direction.LEFT) || child.isConnected(Direction.RIGHT);
        }
        block11: for (i = 0; i < children.length; ++i) {
            child = children[i];
            group = ScoutChains.getCandiateListX(child, children);
            if ((group = ScoutChains.removeOverlapsX(group)) == null) continue;
            dir = Dir.HORIZONTAL;
            if (ScoutChains.anyNotWrap(group, dir)) {
                margins = new int[group.length + 1];
                ScoutChains.getMargins(base, group, margins, dir);
                ScoutChains.creatHorizontalChain(group, base, ChainMode.CHAIN_SPREAD, margins);
                continue;
            }
            marginsSpread = new int[group.length + 1];
            errorSpread = ScoutChains.getMarginsSpread(base, group, marginsSpread, dir);
            marginsInside = new int[group.length + 1];
            errorInside = ScoutChains.getMarginsInside(base, group, marginsInside, dir);
            marginsPacked = new int[group.length + 1];
            errorPacked = ScoutChains.getMarginsPacked(base, group, marginsPacked, dir);
            chain_mode = errorInside < errorSpread ? (errorInside < errorPacked ? ChainMode.CHAIN_SPREAD_INSIDE : ChainMode.CHAIN_PACKED) : (errorSpread < errorPacked ? ChainMode.CHAIN_SPREAD : ChainMode.CHAIN_PACKED);
            switch (chain_mode) {
                case CHAIN_PACKED: {
                    if (errorPacked > 1000) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsPacked);
                    continue block11;
                }
                case CHAIN_SPREAD: {
                    if (errorSpread > 1000) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsSpread);
                    continue block11;
                }
                case CHAIN_SPREAD_INSIDE: {
                    if (errorInside > 1000 || group.length < 3) {
                        return;
                    }
                    ScoutChains.creatHorizontalChain(group, base, chain_mode, marginsInside);
                }
            }
        }
        for (i = 0; i < children.length; ++i) {
            child = children[i];
            child.mCheckedForChain = child.isConnected(Direction.BOTTOM) || child.isConnected(Direction.TOP) || child.isConnected(Direction.BASELINE);
        }
        block13: for (i = 0; i < children.length; ++i) {
            child = children[i];
            group = ScoutChains.getCandiateListY(child, children);
            if ((group = ScoutChains.removeOverlapsY(group)) == null) continue;
            dir = Dir.VERTICAL;
            if (ScoutChains.anyNotWrap(group, dir)) {
                margins = new int[group.length + 1];
                ScoutChains.getMargins(base, group, margins, dir);
                ScoutChains.creatVerticalChain(group, base, ChainMode.CHAIN_SPREAD, margins);
                continue;
            }
            marginsSpread = new int[group.length + 1];
            errorSpread = ScoutChains.getMarginsSpread(base, group, marginsSpread, dir);
            marginsInside = new int[group.length + 1];
            errorInside = ScoutChains.getMarginsInside(base, group, marginsInside, dir);
            marginsPacked = new int[group.length + 1];
            errorPacked = ScoutChains.getMarginsPacked(base, group, marginsPacked, dir);
            chain_mode = errorInside < errorSpread ? (errorInside < errorPacked ? ChainMode.CHAIN_SPREAD_INSIDE : ChainMode.CHAIN_PACKED) : (errorSpread < errorPacked ? ChainMode.CHAIN_SPREAD : ChainMode.CHAIN_PACKED);
            switch (chain_mode) {
                case CHAIN_PACKED: {
                    if (errorPacked > 1000) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsPacked);
                    continue block13;
                }
                case CHAIN_SPREAD: {
                    if (errorSpread > 1000) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsSpread);
                    continue block13;
                }
                case CHAIN_SPREAD_INSIDE: {
                    if (errorInside > 1000 || group.length < 3) {
                        return;
                    }
                    ScoutChains.creatVerticalChain(group, base, chain_mode, marginsInside);
                }
            }
        }
    }

    private static void getMargins(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        if (dir == Dir.HORIZONTAL) {
            margin[0] = group[0].getDpX();
            for (int i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth();
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX();
        } else {
            margin[0] = group[0].getDpY();
            for (int i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight();
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY();
        }
    }

    private static int getMarginsSpread(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            minGap = group[0].getDpX();
            for (i = 1; i < group.length; ++i) {
                gap = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap = Math.min(minGap, base.getDpWidth() - group[group.length - 1].getDpX() - group[group.length - 1].getDpWidth());
            margin[0] = group[0].getDpX() - naturalSpace;
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth() - naturalSpace;
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX() - naturalSpace;
        } else {
            minGap = group[0].getDpY();
            for (i = 1; i < group.length; ++i) {
                gap = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap = Math.min(minGap, base.getDpHeight() - group[group.length - 1].getDpY() - group[group.length - 1].getDpHeight());
            margin[0] = group[0].getDpY() - naturalSpace;
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight() - naturalSpace;
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY() - naturalSpace;
        }
        for (int i = 0; i < margin.length; ++i) {
            int e = margin[i];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        System.out.println(" error = " + error);
        return error;
    }

    private static int getMarginsInside(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            minGap = Integer.MAX_VALUE;
            for (i = 1; i < group.length; ++i) {
                gap = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap;
            margin[0] = group[0].getDpX();
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth() - naturalSpace;
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX();
        } else {
            minGap = Integer.MAX_VALUE;
            for (i = 1; i < group.length; ++i) {
                gap = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight();
                minGap = Math.min(gap, minGap);
            }
            naturalSpace = minGap;
            margin[0] = group[0].getDpY();
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight() - naturalSpace;
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY();
        }
        for (int i = 0; i < margin.length; ++i) {
            int e = margin[i];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        return error;
    }

    private static int getMarginsPacked(ScoutWidget base, ScoutWidget[] group, int[] margin, Dir dir) {
        int error = 0;
        if (dir == Dir.HORIZONTAL) {
            topSpace = group[0].getDpX();
            bottomSpace = base.getDpWidth() - (group[group.length - 1].getDpWidth() + group[group.length - 1].getDpX());
            naturalSpace = Math.min(topSpace, bottomSpace);
            margin[0] = group[0].getDpX() - naturalSpace;
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpX() - group[i - 1].getDpX() - group[i - 1].getDpWidth();
            }
            margin[group.length] = base.getDpWidth() - group[group.length - 1].getDpWidth() - group[group.length - 1].getDpX() - naturalSpace;
        } else {
            topSpace = group[0].getDpY();
            bottomSpace = base.getDpHeight() - (group[group.length - 1].getDpHeight() + group[group.length - 1].getDpY());
            naturalSpace = Math.min(topSpace, bottomSpace);
            margin[0] = group[0].getDpY() - naturalSpace;
            for (i = 1; i < group.length; ++i) {
                margin[i] = group[i].getDpY() - group[i - 1].getDpY() - group[i - 1].getDpHeight();
            }
            margin[group.length] = base.getDpHeight() - group[group.length - 1].getDpHeight() - group[group.length - 1].getDpY() - naturalSpace;
        }
        for (int i = 0; i < margin.length; ++i) {
            int e = margin[i];
            if (e < -2) {
                error = Integer.MAX_VALUE;
                return error;
            }
            error += e * e;
        }
        return error;
    }

    private static boolean anyNotWrap(ScoutWidget[] group, Dir dir) {
        for (int i = 0; i < group.length; ++i) {
            ScoutWidget widget = group[i];
            if (!widget.isCandidateResizable(dir == Dir.HORIZONTAL ? 1 : 0)) continue;
            return true;
        }
        return false;
    }

    private static void creatHorizontalChain(ScoutWidget[] scoutWidgets, ScoutWidget parentScoutWidget, ChainMode chain_mode, int[] margins) {
        ArrayList<String[]> attrList = new ArrayList<String[]>();
        for (int i = 0; i < scoutWidgets.length; ++i) {
            int gap;
            ScoutWidget leftConnect;
            ScoutWidget rightConnect;
            ScoutWidget widget = scoutWidgets[i];
            Direction ldir = Direction.RIGHT;
            Direction rdir = Direction.LEFT;
            if (i + 1 < scoutWidgets.length) {
                rightConnect = scoutWidgets[i + 1];
            } else {
                rightConnect = parentScoutWidget;
                rdir = Direction.RIGHT;
            }
            if (i > 0) {
                leftConnect = scoutWidgets[i - 1];
            } else {
                leftConnect = parentScoutWidget;
                ldir = Direction.LEFT;
            }
            attrList.clear();
            if (widget.isCandidateResizable(1)) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_width", "0dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.LEFT, leftConnect.mNlComponent, ldir, attrList);
            attrList.clear();
            String[] modes = new String[]{"spread", "spread_inside", "packed"};
            if (i == 0) {
                int gap2;
                String mode = modes[chain_mode.ordinal()];
                if (chain_mode != ChainMode.CHAIN_SPREAD) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", mode});
                }
                if ((gap2 = margins[i]) > 0) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginStart", Integer.toString(gap2) + "dp"});
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginLeft", Integer.toString(gap2) + "dp"});
                }
            }
            if ((gap = margins[i + 1]) > 0) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginEnd", Integer.toString(gap) + "dp"});
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginRight", Integer.toString(gap) + "dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.RIGHT, rightConnect.mNlComponent, rdir, attrList);
        }
    }

    private static void creatVerticalChain(ScoutWidget[] scoutWidgets, ScoutWidget parentScoutWidget, ChainMode chain_mode, int[] margin) {
        Arrays.sort(scoutWidgets, ScoutArrange.sSortRecY);
        ArrayList<String[]> attrList = new ArrayList<String[]>();
        for (int i = 0; i < scoutWidgets.length; ++i) {
            int gap;
            ScoutWidget topConnect;
            ScoutWidget bottomConnect;
            ScoutWidget widget = scoutWidgets[i];
            Direction tdir = Direction.BOTTOM;
            Direction bdir = Direction.TOP;
            if (i + 1 < scoutWidgets.length) {
                bottomConnect = scoutWidgets[i + 1];
            } else {
                bottomConnect = parentScoutWidget;
                bdir = Direction.BOTTOM;
            }
            if (i > 0) {
                topConnect = scoutWidgets[i - 1];
            } else {
                topConnect = parentScoutWidget;
                tdir = Direction.TOP;
            }
            attrList.clear();
            if (widget.isCandidateResizable(0)) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_height", "0dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.TOP, topConnect.mNlComponent, tdir, attrList);
            attrList.clear();
            String[] modes = new String[]{"spread", "spread_inside", "packed"};
            if (i == 0) {
                int gap2;
                String mode = modes[chain_mode.ordinal()];
                if (chain_mode != ChainMode.CHAIN_SPREAD) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", mode});
                }
                if ((gap2 = margin[i]) > 0) {
                    attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginTop", Integer.toString(gap2) + "dp"});
                }
            }
            if ((gap = margin[i + 1]) > 0) {
                attrList.add(new String[]{"http://schemas.android.com/apk/res/android", "layout_marginBottom", Integer.toString(gap) + "dp"});
            }
            ConstraintComponentUtilities.scoutChainConnect(widget.mNlComponent, Direction.BOTTOM, bottomConnect.mNlComponent, bdir, attrList);
        }
    }

    private static ScoutWidget[] removeOverlapsX(ScoutWidget[] group) {
        if (group == null || group.length < 3) {
            return group;
        }
        boolean overlap = false;
        for (int i = 1; i < group.length; ++i) {
            if (!ScoutChains.xRangeOverlap(group[i - 1], group[i - 1])) continue;
            overlap = true;
            break;
        }
        if (!overlap) {
            return group;
        }
        ArrayList<ScoutWidget> list = new ArrayList<ScoutWidget>();
        for (int i = 0; i < group.length; ++i) {
            if (i + 1 < group.length && ScoutChains.xRangeOverlap(group[i], group[i + 1])) {
                int p = ScoutChains.medianY(group, i);
                int first = group[i].getDpY() + group[i].getDpHeight() / 2;
                int second = group[i + 1].getDpY() + group[i + 1].getDpHeight() / 2;
                list.add(Math.abs(first - p) > Math.abs(second - p) ? group[i] : group[i + 1]);
                ++i;
                continue;
            }
            list.add(group[i]);
        }
        return list.toArray(new ScoutWidget[list.size()]);
    }

    private static ScoutWidget[] removeOverlapsY(ScoutWidget[] group) {
        if (group == null || group.length < 3) {
            return group;
        }
        boolean overlap = false;
        for (int i = 1; i < group.length; ++i) {
            if (!ScoutChains.yRangeOverlap(group[i - 1], group[i - 1])) continue;
            overlap = true;
            break;
        }
        if (!overlap) {
            return group;
        }
        ArrayList<ScoutWidget> list = new ArrayList<ScoutWidget>();
        for (int i = 0; i < group.length; ++i) {
            if (i + 1 < group.length && ScoutChains.yRangeOverlap(group[i], group[i + 1])) {
                int p = ScoutChains.medianX(group, i);
                int first = group[i].getDpX() + group[i].getDpWidth() / 2;
                int second = group[i + 1].getDpX() + group[i + 1].getDpWidth() / 2;
                list.add(Math.abs(first - p) > Math.abs(second - p) ? group[i] : group[i + 1]);
                ++i;
                continue;
            }
            list.add(group[i]);
        }
        return list.toArray(new ScoutWidget[list.size()]);
    }

    private static int medianX(ScoutWidget[] group, int excluding) {
        int count = 0;
        int sum = 0;
        for (int i = 0; i < group.length; ++i) {
            if (i >= excluding && i <= excluding + 1) continue;
            ++count;
            sum += group[i].getDpX() + group[i].getDpWidth() / 2;
        }
        return sum / count;
    }

    private static int medianY(ScoutWidget[] group, int excluding) {
        int count = 0;
        int sum = 0;
        for (int i = 0; i < group.length; ++i) {
            if (i >= excluding && i <= excluding + 1) continue;
            ++count;
            sum += group[i].getDpY() + group[i].getDpHeight() / 2;
        }
        return sum / count;
    }

    public static ScoutWidget[] getCandiateListX(ScoutWidget candidate, ScoutWidget[] list) {
        ScoutWidget a = candidate;
        ScoutWidget[] shortList = new ScoutWidget[list.length];
        int shortListCount = 1;
        shortList[0] = candidate;
        for (int j = 0; j < list.length; ++j) {
            int ab_gap;
            int ba_gap;
            ScoutWidget b = list[j];
            if (b.mCheckedForChain || a == b || !ScoutChains.yRangeOverlap(a, b) || (ba_gap = b.getDpX() + b.getDpWidth() - a.getDpX()) * (ab_gap = a.getDpX() + a.getDpWidth() - b.getDpX()) > 0) continue;
            shortList[shortListCount++] = b;
        }
        if (shortListCount < 2) {
            return null;
        }
        shortList = Arrays.copyOf(shortList, shortListCount);
        for (int i = 0; i < shortList.length; ++i) {
            shortList[i].mCheckedForChain = true;
        }
        Arrays.sort(shortList, new Comparator<ScoutWidget>(){

            @Override
            public int compare(ScoutWidget o1, ScoutWidget o2) {
                return Float.compare(o1.getDpX(), o2.getDpX());
            }
        });
        return shortList;
    }

    public static ScoutWidget[] getCandiateListY(ScoutWidget candidate, ScoutWidget[] list) {
        ScoutWidget a = candidate;
        ScoutWidget[] shortList = new ScoutWidget[list.length];
        int shortListCount = 1;
        shortList[0] = candidate;
        for (int j = 0; j < list.length; ++j) {
            int ab_gap;
            int ba_gap;
            ScoutWidget b = list[j];
            if (b.mCheckedForChain || a == b || !ScoutChains.xRangeOverlap(a, b) || (ba_gap = b.getDpY() + b.getDpHeight() - a.getDpY()) * (ab_gap = a.getDpY() + a.getDpHeight() - b.getDpY()) > 0) continue;
            shortList[shortListCount++] = b;
        }
        if (shortListCount < 2) {
            return null;
        }
        shortList = Arrays.copyOf(shortList, shortListCount);
        for (int i = 0; i < shortList.length; ++i) {
            shortList[i].mCheckedForChain = true;
        }
        Arrays.sort(shortList, new Comparator<ScoutWidget>(){

            @Override
            public int compare(ScoutWidget o1, ScoutWidget o2) {
                return Float.compare(o1.getDpY(), o2.getDpY());
            }
        });
        return shortList;
    }

    static boolean xRangeOverlap(ScoutWidget a, ScoutWidget b) {
        return ScoutChains.rangeOverlap(a.getDpX(), a.getDpWidth(), b.getDpX(), b.getDpWidth());
    }

    static boolean yRangeOverlap(ScoutWidget a, ScoutWidget b) {
        return ScoutChains.rangeOverlap(a.getDpY(), a.getDpHeight(), b.getDpY(), b.getDpHeight());
    }

    static boolean rangeOverlap(int x1, int w1, int x2, int w2) {
        return x1 < x2 + w2 && x2 < x1 + w1;
    }

    static enum Dir {
        HORIZONTAL,
        VERTICAL;

    }

    static enum ChainMode {
        CHAIN_SPREAD,
        CHAIN_SPREAD_INSIDE,
        CHAIN_PACKED;

    }
}

