/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.HardwareConfig;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.ShapePolicy;
import com.android.tools.idea.common.surface.ShapePolicyKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.ui.designer.overlays.OverlayConfiguration;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.AndroidColorSet;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenViewBase;
import com.android.tools.idea.uibuilder.surface.ScreenViewBuilder;
import com.android.tools.idea.uibuilder.surface.ScreenViewLayer;
import com.android.tools.idea.uibuilder.surface.layer.BorderLayer;
import com.android.tools.idea.uibuilder.surface.layer.CanvasResizeLayer;
import com.android.tools.idea.uibuilder.surface.layer.DiagnosticsLayer;
import com.android.tools.idea.uibuilder.surface.layer.OverlayLayer;
import com.android.tools.idea.uibuilder.surface.sizepolicy.ContentSizePolicy;
import com.google.common.collect.ImmutableList;
import java.awt.Dimension;
import java.util.function.Function;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ScreenView
extends ScreenViewBase {
    public static final ContentSizePolicy DEVICE_CONTENT_SIZE_POLICY = (screenView, outDimension) -> {
        State state;
        Configuration configuration = screenView.getConfiguration();
        Device device = configuration.getCachedDevice();
        if (device != null && (state = configuration.getDeviceState()) != null) {
            HardwareConfig config = new HardwareConfigHelper(device).setOrientation(state.getOrientation()).getConfig();
            float densityRatio = (float)Density.DEFAULT_DENSITY * 1.0f / (float)config.getDensity().getDpiValue();
            int dpWidth = Math.round((float)config.getScreenWidth() * densityRatio);
            int dpHeight = Math.round((float)config.getScreenHeight() * densityRatio);
            outDimension.setSize(dpWidth, dpHeight);
        }
    };
    static final Function<ScreenView, ImmutableList<Layer>> DEFAULT_LAYERS_PROVIDER = screenView -> {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (screenView.hasBorderLayer()) {
            builder.add((Object)new BorderLayer((SceneView)screenView, (Function0<Boolean>)((Function0)() -> screenView.getSurface().isRotating())));
        }
        NlDesignSurface surface2 = screenView.getSurface();
        builder.add((Object)new ScreenViewLayer((ScreenView)screenView, surface2, surface2::getRotateSurfaceDegree));
        SceneLayer sceneLayer = new SceneLayer(surface2, (SceneView)screenView, false);
        sceneLayer.setAlwaysShowSelection(true);
        builder.add((Object)sceneLayer);
        builder.add((Object)new OverlayLayer((SceneView)screenView, (Function0<OverlayConfiguration>)((Function0)() -> ((NlDesignSurface)surface2).getOverlayConfiguration())));
        if (screenView.myIsResizeable && screenView.getSceneManager().getModel().getType().isEditable()) {
            builder.add((Object)new CanvasResizeLayer((ScreenView)screenView, (Function0<Unit>)((Function0)() -> {
                surface2.repaint();
                return null;
            })));
        }
        if (((Boolean)StudioFlags.NELE_RENDER_DIAGNOSTICS.get()).booleanValue()) {
            builder.add((Object)new DiagnosticsLayer(surface2, surface2.getProject()));
        }
        return builder.build();
    };
    private final boolean myHasBorderLayer;
    private final boolean myIsResizeable;
    @NotNull
    private final ColorSet myColorSet;
    @NotNull
    private final Function<ScreenView, ImmutableList<Layer>> myLayersProvider;
    @NotNull
    private final ContentSizePolicy myContentSizePolicy;

    @NotNull
    public static ScreenViewBuilder newBuilder(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager) {
        return new ScreenViewBuilder(surface2, manager);
    }

    ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull ShapePolicy shapePolicy, boolean isResizeable, boolean hasBorderLayer, @NotNull ColorSet colorSet, @NotNull Function<ScreenView, ImmutableList<Layer>> layersProvider, @NotNull ContentSizePolicy contentSizePolicy) {
        super(surface2, manager, shapePolicy);
        this.myHasBorderLayer = hasBorderLayer;
        this.myIsResizeable = isResizeable;
        this.myColorSet = colorSet;
        this.myLayersProvider = layersProvider;
        this.myContentSizePolicy = contentSizePolicy;
    }

    @TestOnly
    public ScreenView(@NotNull NlDesignSurface surface2, @NotNull LayoutlibSceneManager manager, @NotNull ContentSizePolicy contentSizePolicy) {
        this(surface2, manager, ShapePolicyKt.SQUARE_SHAPE_POLICY, true, false, new AndroidColorSet(), DEFAULT_LAYERS_PROVIDER, contentSizePolicy);
    }

    @Override
    @NotNull
    public Dimension getContentSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension();
        }
        this.myContentSizePolicy.measure(this, dimension);
        return dimension;
    }

    @Override
    @NotNull
    protected ImmutableList<Layer> createLayers() {
        return this.myLayersProvider.apply(this);
    }

    public boolean hasBorderLayer() {
        return this.myHasBorderLayer;
    }

    @Override
    public boolean hasContentSize() {
        return this.myContentSizePolicy.hasContentSize(this);
    }

    @Override
    @NotNull
    public ColorSet getColorSet() {
        return this.myColorSet;
    }

    @Override
    public boolean isResizeable() {
        return this.myIsResizeable;
    }
}

