/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.visuallint;

import com.android.tools.configurations.Configuration;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.AndroidBuildTargetReference;
import com.android.tools.idea.rendering.RenderServiceUtilsKt;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.rendering.parsers.PsiXmlFile;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintInspection;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.android.tools.rendering.RenderAsyncActionExecutor;
import com.android.tools.rendering.RenderLogger;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.RenderService;
import com.android.tools.rendering.RenderTask;
import com.android.tools.rendering.parsers.RenderXmlFile;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0012\u001a\u00020\u0011*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"visualLintSingleThreadedDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getVisualLintSingleThreadedDispatcher$annotations", "()V", "visualLintAnalyzerSingleThreadedDispatcher", "getVisualLintAnalyzerSingleThreadedDispatcher$annotations", "visualLintTimeout", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createRenderResult", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/rendering/RenderResult;", "model", "Lcom/android/tools/idea/common/model/NlModel;", "runAtfChecks", "", "shouldRun", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "project", "Lcom/intellij/openapi/project/Project;", "runningInBackground", "intellij.android.designer"})
public final class VisualLintServiceKt {
    @NotNull
    private static final CoroutineDispatcher visualLintSingleThreadedDispatcher = Dispatchers.getDefault().limitedParallelism(1);
    @NotNull
    private static final CoroutineDispatcher visualLintAnalyzerSingleThreadedDispatcher = Dispatchers.getDefault().limitedParallelism(1);
    private static final long visualLintTimeout = ApplicationManager.getApplication().isUnitTestMode() ? 30L : 5L;
    @NotNull
    private static final Logger LOG;

    private static /* synthetic */ void getVisualLintSingleThreadedDispatcher$annotations() {
    }

    private static /* synthetic */ void getVisualLintAnalyzerSingleThreadedDispatcher$annotations() {
    }

    @NotNull
    public static final CompletableFuture<RenderResult> createRenderResult(@NotNull NlModel model, boolean runAtfChecks) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        RenderService renderService = StudioRenderService.Companion.getInstance(model.getProject());
        RenderLogger logger = RenderServiceUtilsKt.createHtmlLogger(renderService, model.getProject());
        CompletionStage completionStage = StudioRenderServiceKt.taskBuilder$default((RenderService)renderService, (AndroidBuildTargetReference)model.getBuildTarget(), (Configuration)model.getConfiguration(), (RenderLogger)logger, null, (int)8, null).withPsiFile((RenderXmlFile)new PsiXmlFile(model.getFile())).withLayoutScanner(Boolean.valueOf(runAtfChecks)).withTopic(RenderAsyncActionExecutor.RenderingTopic.VISUAL_LINT).withQuality(0.25f).build().thenCompose(arg_0 -> VisualLintServiceKt.createRenderResult$lambda$3(arg_0 -> VisualLintServiceKt.createRenderResult$lambda$2(logger, model, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"thenCompose(...)");
        return completionStage;
    }

    private static final boolean shouldRun(VisualLintAnalyzer $this$shouldRun, Project project, boolean runningInBackground) {
        InspectionProfileImpl inspectionProfileImpl = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        ToolsImpl toolsImpl = profile.getToolsOrNull($this$shouldRun.getType().getShortName(), project);
        if (toolsImpl == null) {
            return false;
        }
        ToolsImpl tools = toolsImpl;
        if (!tools.isEnabled()) {
            return false;
        }
        if (!runningInBackground) {
            return true;
        }
        InspectionProfileEntry inspectionProfileEntry = tools.getInspectionTool(null).getTool();
        VisualLintInspection visualLintInspection = inspectionProfileEntry instanceof VisualLintInspection ? (VisualLintInspection)inspectionProfileEntry : null;
        if (visualLintInspection == null) {
            return false;
        }
        VisualLintInspection inspection = visualLintInspection;
        return inspection.getRunInBackground();
    }

    private static final Unit createRenderResult$lambda$2$lambda$0(RenderTask $newTask, RenderLogger $logger, RenderResult result, Throwable inflateException) {
        Throwable throwable = inflateException;
        if (throwable == null) {
            RenderResult renderResult = result;
            throwable = renderResult != null && (renderResult = renderResult.getRenderResult()) != null ? renderResult.getException() : null;
        }
        Throwable exception = throwable;
        $newTask.dispose();
        if (exception != null || result == null) {
            $logger.error("INFLATE", "Error inflating views for visual lint on background", exception, null, null);
        }
        return Unit.INSTANCE;
    }

    private static final void createRenderResult$lambda$2$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final CompletionStage createRenderResult$lambda$2(RenderLogger $logger, NlModel $model, RenderTask newTask) {
        if (newTask == null) {
            $logger.error("INFLATE", "Error inflating view for visual lint on background. No RenderTask Created.", null, null, null);
            return CompletableFuture.failedFuture(new IllegalArgumentException());
        }
        if ($model.isDisposed()) {
            newTask.dispose();
            return CompletableFuture.failedFuture((Throwable)new AlreadyDisposedException("NlModel was already disposed"));
        }
        return newTask.inflate().whenComplete((arg_0, arg_1) -> VisualLintServiceKt.createRenderResult$lambda$2$lambda$1((arg_0, arg_1) -> VisualLintServiceKt.createRenderResult$lambda$2$lambda$0(newTask, $logger, arg_0, arg_1), arg_0, arg_1));
    }

    private static final CompletionStage createRenderResult$lambda$3(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ CoroutineDispatcher access$getVisualLintSingleThreadedDispatcher$p() {
        return visualLintSingleThreadedDispatcher;
    }

    public static final /* synthetic */ CoroutineDispatcher access$getVisualLintAnalyzerSingleThreadedDispatcher$p() {
        return visualLintAnalyzerSingleThreadedDispatcher;
    }

    public static final /* synthetic */ long access$getVisualLintTimeout$p() {
        return visualLintTimeout;
    }

    public static final /* synthetic */ boolean access$shouldRun(VisualLintAnalyzer $receiver, Project project, boolean runningInBackground) {
        return VisualLintServiceKt.shouldRun($receiver, project, runningInBackground);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance(VisualLintService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

