/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.widget.EditText;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/visuallint/analyzers/TextFieldSizeAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "isWideTextField", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "createIssueContent", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nTextFieldSizeAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextFieldSizeAnalyzer.kt\ncom/android/tools/visuallint/analyzers/TextFieldSizeAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1863#2,2:74\n*S KotlinDebug\n*F\n+ 1 TextFieldSizeAnalyzer.kt\ncom/android/tools/visuallint/analyzers/TextFieldSizeAnalyzer\n*L\n41#1:74,2\n*E\n"})
public final class TextFieldSizeAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final TextFieldSizeAnalyzer INSTANCE = new TextFieldSizeAnalyzer();

    private TextFieldSizeAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.TEXT_FIELD_SIZE;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNull((Object)view);
            if (!this.isWideTextField(view, configuration)) continue;
            issues.add(this.createIssueContent(view));
        }
        return issues;
    }

    private final boolean isWideTextField(ViewInfo view, Configuration configuration) {
        if (!VisualLintAnalyzer.Companion.checkIsClass(view, EditText.class)) {
            return false;
        }
        int widthInDp = VisualLintAnalyzer.Companion.pxToDp(configuration, view.getRight() - view.getLeft());
        return widthInDp > 488;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view) {
        String summary = "The text field " + VisualLintAnalyzer.Companion.nameWithId(view) + " is too wide";
        String simpleName = VisualLintAnalyzer.Companion.simpleName(view);
        Function1 provider = arg_0 -> TextFieldSizeAnalyzer.createIssueContent$lambda$1(simpleName, arg_0);
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, provider, 4, null);
    }

    private static final HtmlBuilder createIssueContent$lambda$1(String $simpleName, int count) {
        return new HtmlBuilder().add("The text field " + $simpleName + " is wider than 488dp in " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ".").newline().add("Material Design recommends text fields to be no wider than 488dp");
    }
}

