/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangQuickFixFactoryKt;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFixItHint;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplierBase;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyRange;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.MisraProblemGroup;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.MisraInspection;
import com.jetbrains.cidr.lang.inspections.OurClangTidyInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangTidyAnnotationApplierImpl
extends ClangTidyAnnotationApplierBase {
    @NotNull
    protected SuppressableProblemGroup createProblemGroup(@NotNull PsiFile file, @NotNull TextRange highlightRange, @NotNull String checkName, @NotNull ClangTidyInspectionBase inspection) {
        boolean canSuppressByInlineComment;
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(0);
        }
        if (highlightRange == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(1);
        }
        if (checkName == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(2);
        }
        if (inspection == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(3);
        }
        boolean canDisable = inspection.canBeDisabledByClangTidyCheckName(file.getVirtualFile(), file.getProject());
        boolean bl = canSuppressByInlineComment = !(inspection instanceof OurClangTidyInspection);
        if (ClangTidyInspectionBase.isMisraInspection((String)checkName)) {
            return new MisraProblemGroup(file, highlightRange, checkName, canDisable, inspection.getShortName());
        }
        if (checkName.startsWith("-Wclazy")) {
            return new ClazyProblemGroup(checkName, canDisable, inspection.getShortName());
        }
        return new ClangTidyProblemGroup(file, highlightRange, checkName, canDisable, canSuppressByInlineComment, inspection.getShortName());
    }

    @Nullable
    protected TextRange getRangeToHighlight(@NotNull PsiFile file, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection) {
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(4);
        }
        if (diagnostic == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(5);
        }
        if (sourceInspection == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(6);
        }
        boolean isMisraInspection = sourceInspection instanceof MisraInspection;
        PsiElement elementToAnnotate = ClangTidyAnnotationApplierImpl.getElementToAnnotate(file, diagnostic.getFileOffset(), isMisraInspection);
        return elementToAnnotate != null ? ClangTidyAnnotationApplierImpl.getRangeToHighlight(elementToAnnotate, isMisraInspection, diagnostic.getRanges()) : null;
    }

    protected boolean isSuppressed(@NotNull PsiFile file, int offset, @NotNull String suppressName) {
        OCFile ocFile;
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(7);
        }
        if (suppressName == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(8);
        }
        return (ocFile = OCLanguageUtils.asOCFile((PsiFile)file)) != null && OCPragmaSuppressionUtils.getDiagnosticMode((OCFile)ocFile, (int)offset, (String)suppressName) == OCPragma.Mode.IGNORE;
    }

    @NotNull
    protected List<IntentionAction> createQuickFixes(@NotNull PsiFile file, @NotNull @NlsSafe String diagnosticMessage, @NotNull ClangTidyDiagnostic diagnostic, @NotNull ClangTidyInspectionBase sourceInspection, @NotNull ClangUrlConverter urlConverter) {
        String quickFixMessage;
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(9);
        }
        if (diagnosticMessage == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(10);
        }
        if (diagnostic == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(11);
        }
        if (sourceInspection == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(12);
        }
        if (urlConverter == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(13);
        }
        List replacements = diagnostic.getReplacements();
        ClionFixItHint clionFix = diagnostic.getClionFix();
        String diagnosticName = diagnostic.getDiagnosticName();
        String string = quickFixMessage = sourceInspection.getQuickFixMessage() != null ? sourceInspection.getQuickFixMessage() : diagnosticMessage;
        if (clionFix != null) {
            List<IntentionAction> list = ClangQuickFixFactoryKt.getClangQuickFixes(clionFix, OCResolveContext.forPsi((PsiElement)file), (PsiElement)file, urlConverter);
            if (list == null) {
                ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (replacements.isEmpty()) {
            List<EmptyIntentionAction> list = Collections.singletonList(new EmptyIntentionAction(sourceInspection.getDisplayName()));
            if (list == null) {
                ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        List<ClangTidyIntentionAction> list = Collections.singletonList(new ClangTidyIntentionAction(quickFixMessage, diagnosticName, replacements));
        if (list == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    protected boolean shouldIgnoreForFile(@NotNull PsiFile file) {
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(17);
        }
        return OCLanguageUtils.asOCFile((PsiFile)file) == null;
    }

    @Nullable
    public static PsiElement getElementToAnnotate(@NotNull PsiFile file, int offset, boolean useExactRange) {
        PsiElement element;
        if (file == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(18);
        }
        PsiElement psiElement = element = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild();
        if (element == null) {
            return null;
        }
        if (element instanceof PsiComment || useExactRange) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant((PsiElement)element) && (element = OCElementUtil.getPrevSignificantSibling((PsiElement)element)) == null) {
            return null;
        }
        if (ClangTidyAnnotationApplierImpl.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class, OCTypeParameterDeclaration.class, OCReferenceElement.class, OCDirective.class});
        assert (!(context instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context != null ? context : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(19);
        }
        if (elementType == OCLexerTokenTypes.LBRACE || elementType == OCLexerTokenTypes.RBRACE || elementType == OCLexerTokenTypes.COMMA) {
            return true;
        }
        if (OCLexerTokenTypes.DIRECTIVES.contains(elementType)) {
            return true;
        }
        if (!OCLexerTokenTypes.KEYWORDS.contains(elementType) || OCLexerTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCLexerTokenTypes.OPERATOR_CPP_KEYWORD, OCLexerTokenTypes.VIRTUAL_CPP_KEYWORD, OCLexerTokenTypes.EXPLICIT_CPP_KEYWORD, OCLexerTokenTypes.INLINE_KEYWORD, OCLexerTokenTypes.EXTERN_KEYWORD, OCLexerTokenTypes.REGISTER_KEYWORD, OCLexerTokenTypes.STATIC_KEYWORD, OCLexerTokenTypes.CONST_KEYWORD, OCLexerTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        PsiElement identifier;
        List declarators;
        if (element == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(20);
        }
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCLexerTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCLexerTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                TextRange textRange = keywordElement.get().getTextRange();
                if (textRange == null) {
                    ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(21);
                }
                return textRange;
            }
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && !((OCDeclarator)declarators.get(0)).getName().equals("<unnamed>")) {
            element = (PsiElement)declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(22);
            }
            return textRange;
        }
        if (element instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(23);
            }
            return textRange;
        }
        if (element instanceof LeafPsiElement && element.getText().equals("typename") && element.getParent() instanceof OCTypeElement) {
            TextRange textRange = element.getParent().getTextRange();
            if (textRange == null) {
                ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(24);
            }
            return textRange;
        }
        TextRange textRange = OCElementUtil.getRangeWithMacros((PsiElement)element);
        if (textRange == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(25);
        }
        return textRange;
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement elementToAnnotate, boolean isMisraInspection, @NotNull List<ClangTidyRange> additionalRanges) {
        if (elementToAnnotate == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(26);
        }
        if (additionalRanges == null) {
            ClangTidyAnnotationApplierImpl.$$$reportNull$$$0(27);
        }
        if (isMisraInspection && additionalRanges.size() == 1) {
            ClangTidyRange range = additionalRanges.get(0);
            return new TextRange(range.getFileOffset(), range.getFileOffset() + Math.max(range.getLength(), 1));
        }
        return ClangTidyAnnotationApplierImpl.getRangeToHighlight(elementToAnnotate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 16, 21, 22, 23, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspection";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnosticMessage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlConverter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierImpl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToAnnotate";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplierImpl";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createQuickFixes";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProblemGroup";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 20: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToHighlight";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createQuickFixes";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreForFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementToAnnotate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMakeSenseToHighlight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 16, 21, 22, 23, 24, 25 -> new IllegalStateException(string);
        };
    }
}

