/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/google/play/policy/insights/ForegroundServicesPolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "policyinsights"})
public final class ForegroundServicesPolicyDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS;
    public static final int MIN_TARGET_SDK_VERSION = 34;
    @NotNull
    public static final String ID = "ForegroundServicesPolicy";
    @NotNull
    public static final String DESCRIPTION = "Foreground Services Insights";
    @NotNull
    private static final String EXPLANATION;
    @NotNull
    public static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888379#foreground_service";
    @NotNull
    private static final String MESSAGE;
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-permission");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Intrinsics.checkNotNull((Object)nameNode);
            context.report(new Incident(ISSUE, (Object)element, context.getLocation((Node)nameNode), MESSAGE), Constraints.targetSdkAtLeast((int)34));
        }
    }

    static {
        String[] stringArray = new String[]{"android.permission.FOREGROUND_SERVICE", "android.permission.FOREGROUND_SERVICE_TYPE_CAMERA", "android.permission.FOREGROUND_SERVICE_TYPE_CONNECTED_DEVICE", "android.permission.FOREGROUND_SERVICE_TYPE_HEALTH", "android.permission.FOREGROUND_SERVICE_TYPE_LOCATION", "android.permission.FOREGROUND_SERVICE_TYPE_MANIFEST", "android.permission.FOREGROUND_SERVICE_TYPE_MEDIA_PLAYBACK", "android.permission.FOREGROUND_SERVICE_TYPE_MEDIA_PROCESSING", "android.permission.FOREGROUND_SERVICE_TYPE_MEDIA_PROJECTION", "android.permission.FOREGROUND_SERVICE_TYPE_MICROPHONE", "android.permission.FOREGROUND_SERVICE_TYPE_PHONE_CALL", "android.permission.FOREGROUND_SERVICE_TYPE_REMOTE_MESSAGING", "android.permission.FOREGROUND_SERVICE_TYPE_SPECIAL_USE"};
        PERMISSIONS = CollectionsKt.listOf((Object[])stringArray);
        EXPLANATION = "For apps targeting Android 14+ you must declare valid Foreground Service (FGS) types in the \\\nmanifest and Play Console, providing descriptions, user impact, and a demo video justifying \\\ntheir use based on user-initiated, perceptible actions.\n\n**Dos:**\n\n- Run FGS only for as long as necessary to complete the task. \n- Ensure FGS provides a user-beneficial core app feature, is initiated by the user, is \\\nvisible in notifications or is user perceptible (for example, audio from playing a song).\n- Submit a declaration form in your Play Console if targeting Android 14+ and describe the \\\nuse case for each Foreground Services (FGS) permission used. Ensure the appropriate FGS type \\\nis selected. Examples listed here.\n\n**Don'ts:**\n\n- Use FGS if system management of your task doesn\u2019t break the user experience in your app. \\\nConsider alternatives like WorkManager\n- Declare invalid or inaccurate FGS types in your app\u2019s manifest.\n\n**Helpful Links:**\n\nSee Policy page: https://goo.gle/play-policy-foreground-service \nSee Help Center article: https://goo.gle/play-help-foreground-service \nSee Declaration form:  https://goo.gle/play-permission-decl-form\n\nAlways review the full policy in the Policy Center to ensure compliance.";
        MESSAGE = "Android 14+ requires Foreground Service types declaration and justification. ";
        stringArray = Issue.Companion;
        String string = EXPLANATION;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ForegroundServicesPolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST));
        ISSUE = Issue.Companion.create$default((Issue.Companion)stringArray, (String)ID, (String)DESCRIPTION, (String)string, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/google/play/policy/insights/ForegroundServicesPolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "MIN_TARGET_SDK_VERSION", "", "ID", "DESCRIPTION", "EXPLANATION", "getEXPLANATION", "()Ljava/lang/String;", "URL", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getEXPLANATION() {
            return EXPLANATION;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

