/*
 * Decompiled with CFR 0.152.
 */
package com.google.play.policy.insights;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/google/play/policy/insights/VpnServicePolicyDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "applicableSuperClasses", "", "visitClass", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Companion", "policyinsights"})
public final class VpnServicePolicyDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> PERMISSIONS = CollectionsKt.listOf((Object)"android.permission.BIND_VPN_SERVICE");
    @NotNull
    public static final String VPN_SERVICE = "android.net.VpnService";
    @NotNull
    public static final String ID = "VpnServicePolicy";
    @NotNull
    public static final String DESCRIPTION = "VPN Service Insights";
    @NotNull
    public static final String EXPLANATION = "\n      The `VpnService` base class allows developers to create secure VPN solutions. Google Play \\\n      permits its use only for apps with core VPN functionality or those requiring a remote server \\\n      for essential features such as parental control, app usage tracking, device security, \\\n      network tools, web browsers, or carrier services. It is paramount that `VpnService` is never \\\n      used to collect personal or sensitive user data without prominent disclosure and explicit \\\n      consent. Furthermore, redirecting or manipulating user traffic from other apps for \\\n      monetization is strictly prohibited. All apps using `VpnService` must clearly document this \\\n      in their Google Play listing and encrypt all data from the device to the VPN tunnel endpoint.\n\n      **Dos:**\n      \n      - Document use of the `VpnService` clearly in the Google Play listing.\n      - Must encrypt the data from the device to the VPN tunnel end point. \n      - Ensure your app's core functionality aligns with VPN use or permitted exceptions.\n      - Provide prominent in-app disclosure and obtain explicit consent for any sensitive data \\\n      collection.\n      \n      **Don'ts:**\n      \n      - Use `VpnService` for purposes other than core VPN or specified exceptions.\n      - Collect personal and sensitive user data without prominent disclosure and consent.\n      - Redirect or manipulate user traffic from other apps on a device for monetization purposes \\\n      (for example, redirecting ads traffic through a country different than that of the user).\n      \n      **Helpful Links:**\n\n      See Policy page: https://goo.gle/play-policy-vpn \n      See developer guidance: https://goo.gle/dac-vpn \n      See Declaration form:  https://goo.gle/play-permission-decl-form\n      \n      Always review the full policy in the Policy Center to ensure compliance.\n    ";
    @NotNull
    private static final String URL = "https://support.google.com/googleplay/android-developer/answer/9888170?hl=en#:~:text=vpn%20service";
    @NotNull
    private static final String MESSAGE = "`VpnService` class enables apps with core VPN functionality or those falling under specific \\\nexceptions to create their own VPN solutions.";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    public void visitElement(@NotNull XmlContext context, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Attr nameNode = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "permission");
        Attr attr = nameNode;
        if (CollectionsKt.contains((Iterable)PERMISSIONS, (Object)(attr != null ? attr.getValue() : null))) {
            Node node = element;
            Intrinsics.checkNotNull((Object)nameNode);
            XmlContext.report$default((XmlContext)context, (Issue)ISSUE, (Node)node, (Location)context.getLocation((Node)nameNode), (String)MESSAGE, null, (int)16, null);
        }
    }

    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)VPN_SERVICE);
    }

    public void visitClass(@NotNull JavaContext context, @NotNull UClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        PsiClass psiClass = declaration.getJavaPsi().getSuperClass();
        if (psiClass == null) {
            return;
        }
        PsiClass superCls = psiClass;
        if (Intrinsics.areEqual((Object)superCls.getQualifiedName(), (Object)VPN_SERVICE)) {
            context.report(ISSUE, declaration, context.getNameLocation(declaration), MESSAGE);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.Companion.create("Play Policy", 84);
        Severity severity = Severity.WARNING;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(VpnServicePolicyDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)ID, (String)DESCRIPTION, (String)EXPLANATION, (Implementation)implementation, null, (Category)category, (int)6, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/google/play/policy/insights/VpnServicePolicyDetector$Companion;", "", "<init>", "()V", "PERMISSIONS", "", "", "getPERMISSIONS", "()Ljava/util/List;", "VPN_SERVICE", "ID", "DESCRIPTION", "EXPLANATION", "URL", "getURL", "()Ljava/lang/String;", "MESSAGE", "getMESSAGE", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "policyinsights"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPERMISSIONS() {
            return PERMISSIONS;
        }

        @NotNull
        public final String getURL() {
            return URL;
        }

        @NotNull
        public final String getMESSAGE() {
            return MESSAGE;
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

