/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.ui.properties;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit2.ui.actions.RerunFailedTestsAction;
import com.intellij.execution.testframework.JavaAwareTestConsoleProperties;
import com.intellij.execution.testframework.JavaTestLocator;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.actions.AbstractRerunFailedTestsAction;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitConsoleProperties
extends JavaAwareTestConsoleProperties<JUnitConfiguration> {
    public JUnitConsoleProperties(@NotNull JUnitConfiguration configuration, Executor executor) {
        if (configuration == null) {
            JUnitConsoleProperties.$$$reportNull$$$0(0);
        }
        super("JUnit", (RunConfiguration)configuration, executor);
    }

    @NotNull
    protected GlobalSearchScope initScope() {
        JUnitConfiguration.Data persistentData = ((JUnitConfiguration)this.getConfiguration()).getPersistentData();
        String testObject = persistentData.TEST_OBJECT;
        if ("category".equals(testObject) || "pattern".equals(testObject) || "package".equals(testObject)) {
            SourceScope sourceScope = persistentData.getScope().getSourceScope(this.getConfiguration());
            GlobalSearchScope globalSearchScope = sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)this.getProject());
            if (globalSearchScope == null) {
                JUnitConsoleProperties.$$$reportNull$$$0(1);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.initScope();
        if (globalSearchScope == null) {
            JUnitConsoleProperties.$$$reportNull$$$0(2);
        }
        return globalSearchScope;
    }

    public void appendAdditionalActions(DefaultActionGroup actionGroup, JComponent parent, TestConsoleProperties target) {
        super.appendAdditionalActions(actionGroup, parent, target);
        actionGroup.addSeparator();
        actionGroup.add((AnAction)this.createIncludeNonStartedInRerun(target));
    }

    public SMTestLocator getTestLocator() {
        return JavaTestLocator.INSTANCE;
    }

    @Nullable
    public AbstractRerunFailedTestsAction createRerunFailedTestsAction(ConsoleView consoleView) {
        return new RerunFailedTestsAction((ComponentContainer)consoleView, (TestConsoleProperties)this);
    }

    public boolean isUndefined() {
        String mode = ((JUnitConfiguration)this.getConfiguration()).getRepeatMode();
        return "Until Stopped".equals(mode) || "Until Failure".equals(mode) || "Until Success".equals(mode);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit2/ui/properties/JUnitConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit2/ui/properties/JUnitConsoleProperties";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

