/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.VcsSymlinkResolver;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DefaultVcsSymlinkResolver
implements VcsSymlinkResolver {
    private static final Logger LOG = Logger.getInstance(DefaultVcsSymlinkResolver.class);
    private final Project myProject;
    private final Mode myMode;
    private boolean mySymlinkMappingWasUsed;

    public DefaultVcsSymlinkResolver(@NotNull Project project) {
        if (project == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(0);
        }
        this.mySymlinkMappingWasUsed = false;
        this.myProject = project;
        RegistryValue value = Registry.get((String)"vcs.resolve.symlinks.for.vcs.operations");
        this.myMode = switch (value.asString()) {
            case "force_target" -> Mode.FORCE_TARGET;
            case "prefer_target" -> Mode.PREFER_TARGET;
            case "fallback_target" -> Mode.FALLBACK_TARGET;
            default -> Mode.DISABLED;
        };
    }

    public boolean isEnabled() {
        return this.myMode != Mode.DISABLED;
    }

    @Nullable
    public VirtualFile resolveSymlink(@NotNull VirtualFile file) {
        VirtualFile canonicalFile;
        if (file == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(1);
        }
        if ((canonicalFile = this.resolveFile(file)) != null) {
            this.logSymlinkMappingWasUsed(file, canonicalFile);
        }
        return canonicalFile;
    }

    @Nullable
    private VirtualFile resolveFile(@NotNull VirtualFile file) {
        if (file == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(2);
        }
        if (this.myMode == Mode.DISABLED) {
            return null;
        }
        VirtualFile canonicalFile = file.getCanonicalFile();
        if (canonicalFile == null || file.equals(canonicalFile)) {
            return null;
        }
        if (this.myMode == Mode.FORCE_TARGET) {
            return canonicalFile;
        }
        if (this.myMode == Mode.PREFER_TARGET ? ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(canonicalFile) != null : this.myMode == Mode.FALLBACK_TARGET && ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file) == null && ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(canonicalFile) != null) {
            return canonicalFile;
        }
        return null;
    }

    private void logSymlinkMappingWasUsed(@NotNull VirtualFile file, @NotNull VirtualFile canonicalFile) {
        if (file == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(3);
        }
        if (canonicalFile == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(4);
        }
        if (this.mySymlinkMappingWasUsed) {
            return;
        }
        this.mySymlinkMappingWasUsed = true;
        LOG.info("Symlink mapping for VCS is used, original file: " + file + ", canonical file: " + canonicalFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/DefaultVcsSymlinkResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSymlink";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "logSymlinkMappingWasUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Mode {
        FORCE_TARGET,
        PREFER_TARGET,
        FALLBACK_TARGET,
        DISABLED;

    }
}

