/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.utp;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/utp/TaskOutputLineProcessor;", "Ljava/io/Closeable;", "lineProcessor", "Lcom/android/tools/utp/TaskOutputLineProcessor$LineProcessor;", "<init>", "(Lcom/android/tools/utp/TaskOutputLineProcessor$LineProcessor;)V", "getLineProcessor", "()Lcom/android/tools/utp/TaskOutputLineProcessor$LineProcessor;", "setLineProcessor", "stringBuffer", "Ljava/lang/StringBuffer;", "append", "", "text", "", "close", "LineProcessor", "utp"})
public final class TaskOutputLineProcessor
implements Closeable {
    @NotNull
    private LineProcessor lineProcessor;
    @NotNull
    private final StringBuffer stringBuffer;

    public TaskOutputLineProcessor(@NotNull LineProcessor lineProcessor) {
        Intrinsics.checkNotNullParameter((Object)lineProcessor, (String)"lineProcessor");
        this.lineProcessor = lineProcessor;
        this.stringBuffer = new StringBuffer();
    }

    @NotNull
    public final LineProcessor getLineProcessor() {
        return this.lineProcessor;
    }

    public final void setLineProcessor(@NotNull LineProcessor lineProcessor) {
        Intrinsics.checkNotNullParameter((Object)lineProcessor, (String)"<set-?>");
        this.lineProcessor = lineProcessor;
    }

    public final void append(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.stringBuffer.append(text);
        while (true) {
            int lineBreakIndex = -1;
            int lineBreakLength = 0;
            int n = ((CharSequence)this.stringBuffer).length();
            block4: for (int i = 0; i < n; ++i) {
                char c = this.stringBuffer.charAt(i);
                switch (c) {
                    case '\n': 
                    case '\r': {
                        lineBreakIndex = i;
                        lineBreakLength = 1;
                        if (c != '\r' || i + 1 >= this.stringBuffer.length() || this.stringBuffer.charAt(i + 1) != '\n') break block4;
                        ++lineBreakLength;
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
            if (lineBreakIndex == -1) {
                return;
            }
            String line = this.stringBuffer.substring(0, lineBreakIndex);
            this.stringBuffer.delete(0, lineBreakIndex + lineBreakLength);
            Intrinsics.checkNotNull((Object)line);
            this.lineProcessor.processLine(line);
        }
    }

    @Override
    public void close() {
        if (((CharSequence)this.stringBuffer).length() > 0) {
            String string = this.stringBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            this.lineProcessor.processLine(string);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/utp/TaskOutputLineProcessor$LineProcessor;", "", "processLine", "", "line", "", "utp"})
    public static interface LineProcessor {
        public void processLine(@NotNull String var1);
    }
}

