/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.game;

import com.android.tools.game.AvdManagerServiceImpl;
import com.android.tools.game.CommonService;
import com.android.tools.game.DeviceFileExplorerServiceImpl;
import com.android.tools.game.LogcatServiceImpl;
import com.android.tools.game.ProfilerService;
import com.android.tools.game.ProfilerServiceImpl;
import com.android.tools.game.SdkManagerServiceImpl;
import com.android.tools.game.protos.CreateProjectRequest;
import com.android.tools.game.protos.CreateWindowRequest;
import com.android.tools.game.protos.GameToolsGrpc;
import com.android.tools.game.protos.Project;
import com.android.tools.game.protos.StartProfilingRequest;
import com.android.tools.game.protos.StartProfilingResponse;
import com.android.tools.game.protos.Window;
import com.android.tools.idea.io.grpc.BindableService;
import com.android.tools.idea.io.grpc.Server;
import com.android.tools.idea.io.grpc.Status;
import com.android.tools.idea.io.grpc.netty.NettyServerBuilder;
import com.android.tools.idea.io.grpc.stub.StreamObserver;
import com.android.tools.idea.io.grpc.util.TransmitStatusRuntimeExceptionInterceptor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001c2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016J\u001e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020 0\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/game/GameToolsServer;", "Lcom/android/tools/game/protos/GameToolsGrpc$GameToolsImplBase;", "project", "Lcom/intellij/openapi/project/Project;", "port", "", "profilerService", "Lcom/android/tools/game/ProfilerService;", "sdkManagerService", "Lcom/android/tools/game/CommonService;", "avdManagerService", "deviceFileExplorerService", "logcatService", "<init>", "(Lcom/intellij/openapi/project/Project;ILcom/android/tools/game/ProfilerService;Lcom/android/tools/game/CommonService;Lcom/android/tools/game/CommonService;Lcom/android/tools/game/CommonService;Lcom/android/tools/game/CommonService;)V", "server", "Lcom/android/tools/idea/io/grpc/Server;", "kotlin.jvm.PlatformType", "start", "", "shutdown", "createProject", "request", "Lcom/android/tools/game/protos/CreateProjectRequest;", "responseObserver", "Lcom/android/tools/idea/io/grpc/stub/StreamObserver;", "Lcom/android/tools/game/protos/Project;", "createWindow", "Lcom/android/tools/game/protos/CreateWindowRequest;", "Lcom/android/tools/game/protos/Window;", "startProfiling", "Lcom/android/tools/game/protos/StartProfilingRequest;", "Lcom/android/tools/game/protos/StartProfilingResponse;", "android.game-tools.main"})
@SourceDebugExtension(value={"SMAP\nGameToolsServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameToolsServer.kt\ncom/android/tools/game/GameToolsServer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n15#2:97\n1#3:98\n*S KotlinDebug\n*F\n+ 1 GameToolsServer.kt\ncom/android/tools/game/GameToolsServer\n*L\n49#1:97\n*E\n"})
public final class GameToolsServer
extends GameToolsGrpc.GameToolsImplBase {
    @NotNull
    private final com.intellij.openapi.project.Project project;
    @NotNull
    private final ProfilerService profilerService;
    @NotNull
    private final CommonService sdkManagerService;
    @NotNull
    private final CommonService avdManagerService;
    @NotNull
    private final CommonService deviceFileExplorerService;
    @NotNull
    private final CommonService logcatService;
    private final Server server;

    public GameToolsServer(@NotNull com.intellij.openapi.project.Project project, int port, @NotNull ProfilerService profilerService, @NotNull CommonService sdkManagerService, @NotNull CommonService avdManagerService, @NotNull CommonService deviceFileExplorerService, @NotNull CommonService logcatService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)profilerService, (String)"profilerService");
        Intrinsics.checkNotNullParameter((Object)sdkManagerService, (String)"sdkManagerService");
        Intrinsics.checkNotNullParameter((Object)avdManagerService, (String)"avdManagerService");
        Intrinsics.checkNotNullParameter((Object)deviceFileExplorerService, (String)"deviceFileExplorerService");
        Intrinsics.checkNotNullParameter((Object)logcatService, (String)"logcatService");
        this.project = project;
        this.profilerService = profilerService;
        this.sdkManagerService = sdkManagerService;
        this.avdManagerService = avdManagerService;
        this.deviceFileExplorerService = deviceFileExplorerService;
        this.logcatService = logcatService;
        this.server = ((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forPort((int)port).addService((BindableService)this)).intercept(TransmitStatusRuntimeExceptionInterceptor.instance())).build();
    }

    public /* synthetic */ GameToolsServer(com.intellij.openapi.project.Project project, int n, ProfilerService profilerService, CommonService commonService, CommonService commonService2, CommonService commonService3, CommonService commonService4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            profilerService = new ProfilerServiceImpl();
        }
        if ((n2 & 8) != 0) {
            commonService = new SdkManagerServiceImpl();
        }
        if ((n2 & 0x10) != 0) {
            commonService2 = new AvdManagerServiceImpl();
        }
        if ((n2 & 0x20) != 0) {
            commonService3 = new DeviceFileExplorerServiceImpl();
        }
        if ((n2 & 0x40) != 0) {
            commonService4 = new LogcatServiceImpl();
        }
        this(project, n, profilerService, commonService, commonService2, commonService3, commonService4);
    }

    public final void start() {
        this.server.start();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GameToolsServer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("GameToolsServer started at port " + this.server.getPort());
    }

    public final void shutdown() {
        this.server.shutdown();
        this.server.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public void createProject(@NotNull CreateProjectRequest request, @NotNull StreamObserver<Project> responseObserver) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        String it = string2 = request.getProject().getName();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        String string3 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        if (string3 == null) {
            throw Status.INVALID_ARGUMENT.withDescription("'project.name' field is required.").asRuntimeException();
        }
        String name = string3;
        String it2 = string = request.getProject().getPath();
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it2);
        String string4 = !StringsKt.isBlank((CharSequence)it2) ? string : null;
        if (string4 == null) {
            throw Status.INVALID_ARGUMENT.withDescription("'project.path' field is required.").asRuntimeException();
        }
        String path = string4;
        String string5 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        String projectId = string5;
        responseObserver.onNext((Object)Project.newBuilder().setProjectId(projectId).setName(name).setPath(path).build());
        responseObserver.onCompleted();
    }

    public void createWindow(@NotNull CreateWindowRequest request, @NotNull StreamObserver<Window> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        Window.WindowType windowType = request.getWindow().getType();
        CommonService service = switch (windowType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[windowType.ordinal()]) {
            case 1 -> this.profilerService;
            case 2 -> this.sdkManagerService;
            case 3 -> this.avdManagerService;
            case 4 -> this.deviceFileExplorerService;
            case 5 -> this.logcatService;
            default -> throw Status.INVALID_ARGUMENT.withDescription("Unknown window type '" + request.getWindow().getType() + "'.").asRuntimeException();
        };
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String windowId = string;
        service.createWindow(windowId, this.project);
        responseObserver.onNext((Object)Window.newBuilder().setWindowId(windowId).setType(request.getWindow().getType()).build());
        responseObserver.onCompleted();
    }

    public void startProfiling(@NotNull StartProfilingRequest request, @NotNull StreamObserver<StartProfilingResponse> responseObserver) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(responseObserver, (String)"responseObserver");
        this.profilerService.startProfiler(request);
        responseObserver.onNext((Object)StartProfilingResponse.getDefaultInstance());
        responseObserver.onCompleted();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Window.WindowType.values().length];
            try {
                nArray[Window.WindowType.PROFILER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Window.WindowType.SDK_MANAGER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Window.WindowType.AVD_MANAGER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Window.WindowType.DEVICE_FILE_EXPLORER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Window.WindowType.LOGCAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

