/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.reload;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.google.common.base.Strings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static boolean isApkProject(@NotNull Project project) {
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (ApkFacet.getInstance((Module)module) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isFileInDir(@NotNull VirtualFile dir, @NotNull VirtualFile file) {
        String dirPath = dir.getCanonicalPath();
        String path = file.getCanonicalPath();
        while (!Strings.isNullOrEmpty((String)path)) {
            if (path.equals(dirPath)) {
                return true;
            }
            path = PathUtil.getParentPath((String)path);
        }
        return false;
    }

    public static <T> T invokeAndWait(@NotNull Computable<T> computable) throws ProcessCanceledException {
        Ref result = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> result.set(computable.compute()));
        return (T)result.get();
    }

    @Nullable
    public static ApkFacet findApkFacet(@NotNull Project project, @NotNull VirtualFile apkFile) {
        Module[] modules;
        String apkFilePath = apkFile.getPath();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            ApkFacet apkFacet = ApkFacet.getInstance((Module)module);
            if (apkFacet == null || !apkFilePath.equals(((ApkFacetConfiguration)apkFacet.getConfiguration()).APK_PATH)) continue;
            return apkFacet;
        }
        return null;
    }
}

