/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.AwtFontInteropKt;
import androidx.compose.ui.unit.TextUnitKt;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.JewelBridgeException;
import org.jetbrains.jewel.foundation.ExperimentalJewelApi;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0006\u0010\u0007\u001a\u00020\u0003\u001a\u0006\u0010\b\u001a\u00020\u0003\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"KEY_LABEL_FONT", "", "retrieveDefaultTextStyle", "Landroidx/compose/ui/text/TextStyle;", "lineHeightMultiplier", "", "EDITOR_LINE_HEIGHT_FACTOR", "retrieveEditorTextStyle", "retrieveConsoleTextStyle", "image", "Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/annotations/NotNull;", "computeBaseLineHeightFor", "", "font", "Ljava/awt/Font;", "intellij.platform.jewel.ideLafBridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridgeText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridgeText.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextKt\n+ 2 JewelBridgeException.kt\norg/jetbrains/jewel/bridge/JewelBridgeExceptionKt\n*L\n1#1,118:1\n16#2:119\n*S KotlinDebug\n*F\n+ 1 IntUiBridgeText.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeTextKt\n*L\n39#1:119\n*E\n"})
public final class IntUiBridgeTextKt {
    @NotNull
    private static final String KEY_LABEL_FONT = "Label.font";
    private static final float EDITOR_LINE_HEIGHT_FACTOR = 0.85f;
    @NotNull
    private static final BufferedImage image;

    @NotNull
    public static final TextStyle retrieveDefaultTextStyle() {
        return IntUiBridgeTextKt.retrieveDefaultTextStyle(1.0f);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalJewelApi
    @NotNull
    public static final TextStyle retrieveDefaultTextStyle(float lineHeightMultiplier) {
        Font font = UIManager.getFont(KEY_LABEL_FONT);
        if (font == null) {
            void key$iv;
            String string = KEY_LABEL_FONT;
            String type$iv = "Font";
            boolean $i$f$keyNotFound = false;
            throw new JewelBridgeException.KeyNotFoundException((String)key$iv, type$iv);
        }
        Font lafFont = font;
        JBFont jBFont = JBFont.create((Font)lafFont, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)jBFont, (String)"create(...)");
        JBFont font2 = jBFont;
        int baseLineHeight = IntUiBridgeTextKt.computeBaseLineHeightFor((Font)font2);
        TextStyle textStyle = BridgeUtilsKt.retrieveTextStyle-tD9LlGs$default(KEY_LABEL_FONT, "Label.foreground", 0L, false, 0, 0L, 60, null);
        return TextStyle.copy-p1EtxEg$default((TextStyle)textStyle, (long)0L, (long)0L, null, null, null, null, null, (long)0L, null, null, null, (long)0L, null, null, null, (int)0, (int)0, (long)TextUnitKt.getSp((float)((float)baseLineHeight * lineHeightMultiplier)), null, null, null, (int)0, (int)0, null, (int)0xFDFFFF, null);
    }

    @NotNull
    public static final TextStyle retrieveEditorTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        Font font = editorColorScheme.getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        int baseLineHeight = IntUiBridgeTextKt.computeBaseLineHeightFor(font2);
        float computedLineHeight = (float)baseLineHeight * editorColorScheme.getLineSpacing();
        TextStyle textStyle = IntUiBridgeTextKt.retrieveDefaultTextStyle();
        Color color = editorColorScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        long l = BridgeUtilsKt.toComposeColor(color);
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily((Font)font2);
        long l2 = TextUnitKt.getSp((int)editorColorScheme.getEditorFontSize());
        long l3 = TextUnitKt.getSp((float)RangesKt.coerceAtLeast((float)(computedLineHeight * 0.85f), (float)1.0f));
        String string = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default((TextStyle)textStyle, (long)l, (long)l2, null, null, null, (FontFamily)fontFamily, (String)string, (long)0L, null, null, null, (long)0L, null, null, null, (int)0, (int)0, (long)l3, null, null, null, (int)0, (int)0, null, (int)16646044, null);
    }

    @NotNull
    public static final TextStyle retrieveConsoleTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        if (editorColorScheme.isUseEditorFontPreferencesInConsole()) {
            return IntUiBridgeTextKt.retrieveEditorTextStyle();
        }
        long fontSize = TextUnitKt.getSp((int)BridgeUtilsKt.safeValue$default(editorColorScheme.getConsoleFontSize(), 0, 1, null));
        Color color = editorColorScheme.getColor(ColorKey.createColorKey((String)"BLOCK_TERMINAL_DEFAULT_FOREGROUND"));
        if (color == null) {
            Color color2 = editorColorScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        Color fontColor = color;
        Font font = editorColorScheme.getFont(EditorFontType.CONSOLE_PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font font2 = font;
        int baseLineHeight = IntUiBridgeTextKt.computeBaseLineHeightFor(font2);
        TextStyle textStyle = IntUiBridgeTextKt.retrieveDefaultTextStyle();
        long l = BridgeUtilsKt.toComposeColor(fontColor);
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily((Font)font2);
        long l2 = TextUnitKt.getSp((float)RangesKt.coerceAtLeast((float)((float)baseLineHeight * editorColorScheme.getLineSpacing()), (float)1.0f));
        String string = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default((TextStyle)textStyle, (long)l, (long)fontSize, null, null, null, (FontFamily)fontFamily, (String)string, (long)0L, null, null, null, (long)0L, null, null, null, (int)0, (int)0, (long)l2, null, null, null, (int)0, (int)0, null, (int)16646044, null);
    }

    public static final int computeBaseLineHeightFor(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Graphics2D graphics2D = image.createGraphics();
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)graphics2D.getFontRenderContext());
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        FontMetrics fm = fontMetrics;
        return FontLayoutService.Companion.getInstance().getHeight(fm);
    }

    static {
        BufferedImage bufferedImage = ImageUtil.createImage((int)1, (int)1, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        image = bufferedImage;
    }
}

