/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.HorizontalScrollView;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.CommonButton;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedToolbar
extends JPanel {
    private final JPanel myActionPanel = new JPanel();
    private final JPanel myTabsPanel = new JPanel();
    @Nullable
    private TabLabel myActiveTab;
    @Nullable
    private TabLabel myMouseOverTab;
    private final HorizontalScrollView myTabScrollView = new HorizontalScrollView(this.myTabsPanel);
    private List<Runnable> mySelectionActions = new ArrayList<Runnable>();

    public TabbedToolbar(@NotNull JComponent title) {
        this.myTabsPanel.setLayout(new FlowLayout(3, 0, 0));
        this.setLayout(new TabularLayout("Fit,5px,*,Fit", "*"));
        this.add((Component)title, new TabularLayout.Constraint(0, 0));
        this.add((Component)this.myTabScrollView, new TabularLayout.Constraint(0, 2));
        this.add((Component)this.myActionPanel, new TabularLayout.Constraint(0, 3));
    }

    public void addAction(@NotNull Icon actionIcon, @NotNull ActionListener actionListener) {
        CommonButton action = new CommonButton(actionIcon);
        action.addActionListener(actionListener);
        this.myActionPanel.add(action);
    }

    public void addTab(String name, TabListener selectedListener) {
        this.addTab(name, selectedListener, null);
    }

    public void addTab(@NotNull String name, final @NotNull TabListener selectedListener, @Nullable TabListener closedListener) {
        final TabLabel tab = new TabLabel(name, closedListener);
        final Runnable selectTabAction = () -> {
            this.selectTab(tab, selectedListener);
            this.repaint();
        };
        tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                selectTabAction.run();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                TabbedToolbar.this.myMouseOverTab = tab;
                TabbedToolbar.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                TabbedToolbar.this.myMouseOverTab = null;
                TabbedToolbar.this.repaint();
            }
        });
        tab.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TabbedToolbar.this.myMouseOverTab = tab;
            }

            @Override
            public void focusLost(FocusEvent e) {
                TabbedToolbar.this.myMouseOverTab = null;
            }
        });
        tab.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TabbedToolbar.this.selectTab(tab, selectedListener);
                }
            }
        });
        this.myTabsPanel.add(tab);
        this.mySelectionActions.add(selectTabAction);
        this.myTabScrollView.scrollTo(this.myTabsPanel.getWidth());
    }

    public void clearTabs() {
        this.myTabsPanel.removeAll();
        this.mySelectionActions.clear();
    }

    public int countTabs() {
        return this.mySelectionActions.size();
    }

    public void selectTab(int tabIndex) {
        this.mySelectionActions.get(tabIndex).run();
    }

    private void selectTab(@NotNull TabLabel tab, @NotNull TabListener listener2) {
        this.myActiveTab = tab;
        listener2.doAction();
    }

    @NotNull
    @VisibleForTesting
    public JComponent getTabsPanel() {
        return this.myTabsPanel;
    }

    public static interface TabListener {
        public void doAction();
    }

    private class TabLabel
    extends JPanel {
        private Color myFocusedColor = StudioColorsKt.getTabbedPaneFocus();
        private Color myHighlightColor = StudioColorsKt.getTabbedPaneHoverHighlight();

        TabLabel(@Nullable String name, final TabListener onClosed) {
            this.setLayout(new BorderLayout());
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
            this.setFocusable(true);
            this.add((Component)new JLabel(name), "Center");
            if (onClosed != null) {
                CommonButton closeButton = new CommonButton(StudioIcons.Common.CLOSE);
                closeButton.addActionListener(e -> onClosed.doAction());
                this.add((Component)closeButton, "East");
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (SwingUtilities.isMiddleMouseButton(e)) {
                            onClosed.doAction();
                        }
                    }
                });
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            GraphicsUtil.setAntialiasingType((JComponent)this, (Object)AntialiasingType.getAATextInfoForSwingComponent());
            if (TabbedToolbar.this.myMouseOverTab == this) {
                this.setBackground(this.myHighlightColor);
            } else {
                this.setBackground(this.getParent().getBackground());
            }
            super.paintComponent(g);
            if (TabbedToolbar.this.myActiveTab == this) {
                Rectangle bounds = this.getBounds();
                int selectedHeight = JBUIScale.scale((int)2);
                g.setColor(this.myFocusedColor);
                g.fillRect(0, bounds.height - selectedHeight, bounds.width, selectedHeight);
            }
        }
    }
}

