/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.device;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.adtui.device.AnchoredImage;
import com.android.tools.adtui.device.SkinButton;
import com.android.tools.adtui.util.AwtUtilsKt;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010\u0012J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"J8\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u0004\u0018\u00010\f2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/android/tools/adtui/device/SkinLayout;", "", "displaySize", "Ljava/awt/Dimension;", "displayCornerSize", "frameRectangle", "Ljava/awt/Rectangle;", "frameImages", "", "Lcom/android/tools/adtui/device/AnchoredImage;", "maskImages", "buttons", "Lcom/android/tools/adtui/device/SkinButton;", "<init>", "(Ljava/awt/Dimension;Ljava/awt/Dimension;Ljava/awt/Rectangle;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "width", "", "height", "(II)V", "getDisplaySize", "()Ljava/awt/Dimension;", "getDisplayCornerSize", "getFrameRectangle", "()Ljava/awt/Rectangle;", "getFrameImages", "()Ljava/util/List;", "getMaskImages", "getButtons", "drawFrameAndMask", "", "g", "Ljava/awt/Graphics2D;", "displayRectangle", "highlightedButtonKey", "", "drawImage", "anchoredImage", "scaleX", "", "scaleY", "transform", "Ljava/awt/geom/AffineTransform;", "findSkinButtonContaining", "x", "y", "intellij.android.adt.ui"})
@SourceDebugExtension(value={"SMAP\nSkinLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkinLayout.kt\ncom/android/tools/adtui/device/SkinLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class SkinLayout {
    @NotNull
    private final Dimension displaySize;
    @NotNull
    private final Dimension displayCornerSize;
    @NotNull
    private final Rectangle frameRectangle;
    @NotNull
    private final List<AnchoredImage> frameImages;
    @NotNull
    private final List<AnchoredImage> maskImages;
    @NotNull
    private final List<SkinButton> buttons;

    public SkinLayout(@NotNull Dimension displaySize, @NotNull Dimension displayCornerSize, @NotNull Rectangle frameRectangle, @NotNull List<AnchoredImage> frameImages, @NotNull List<AnchoredImage> maskImages, @NotNull List<SkinButton> buttons) {
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        Intrinsics.checkNotNullParameter((Object)displayCornerSize, (String)"displayCornerSize");
        Intrinsics.checkNotNullParameter((Object)frameRectangle, (String)"frameRectangle");
        Intrinsics.checkNotNullParameter(frameImages, (String)"frameImages");
        Intrinsics.checkNotNullParameter(maskImages, (String)"maskImages");
        Intrinsics.checkNotNullParameter(buttons, (String)"buttons");
        this.displaySize = displaySize;
        this.displayCornerSize = displayCornerSize;
        this.frameRectangle = frameRectangle;
        this.frameImages = frameImages;
        this.maskImages = maskImages;
        this.buttons = buttons;
    }

    @NotNull
    public final Dimension getDisplaySize() {
        return this.displaySize;
    }

    @NotNull
    public final Dimension getDisplayCornerSize() {
        return this.displayCornerSize;
    }

    @NotNull
    public final Rectangle getFrameRectangle() {
        return this.frameRectangle;
    }

    @NotNull
    public final List<AnchoredImage> getFrameImages() {
        return this.frameImages;
    }

    @NotNull
    public final List<AnchoredImage> getMaskImages() {
        return this.maskImages;
    }

    @NotNull
    public final List<SkinButton> getButtons() {
        return this.buttons;
    }

    public SkinLayout(int width, int height) {
        this(new Dimension(width, height), new Dimension(0, 0), new Rectangle(0, 0, width, height), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.emptyList());
    }

    public final void drawFrameAndMask(@NotNull Graphics2D g, @NotNull Rectangle displayRectangle, @Nullable String highlightedButtonKey) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)displayRectangle, (String)"displayRectangle");
        if (!((Collection)this.frameImages).isEmpty() || !((Collection)this.maskImages).isEmpty()) {
            double scaleX = (double)displayRectangle.width / (double)this.displaySize.width;
            double scaleY = (double)displayRectangle.height / (double)this.displaySize.height;
            AffineTransform transform = new AffineTransform();
            for (AnchoredImage image : this.frameImages) {
                this.drawImage(g, image, displayRectangle, scaleX, scaleY, transform);
            }
            for (AnchoredImage image : this.maskImages) {
                this.drawImage(g, image, displayRectangle, scaleX, scaleY, transform);
            }
            if (highlightedButtonKey != null) {
                Object v0;
                block6: {
                    Iterable iterable = this.buttons;
                    for (Object t : iterable) {
                        SkinButton it = (SkinButton)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getKeyName(), (Object)highlightedButtonKey)) continue;
                        v0 = t;
                        break block6;
                    }
                    v0 = null;
                }
                SkinButton highlightedButton = v0;
                if (highlightedButton != null) {
                    this.drawImage(g, highlightedButton.getImage(), displayRectangle, scaleX, scaleY, transform);
                }
            }
        }
    }

    public static /* synthetic */ void drawFrameAndMask$default(SkinLayout skinLayout, Graphics2D graphics2D, Rectangle rectangle, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        skinLayout.drawFrameAndMask(graphics2D, rectangle, string);
    }

    private final void drawImage(Graphics2D g, AnchoredImage anchoredImage, Rectangle displayRectangle, double scaleX, double scaleY, AffineTransform transform) {
        int x = displayRectangle.x + anchoredImage.getAnchorPoint().getX() * displayRectangle.width + AwtUtilsKt.scaled(anchoredImage.getOffset().x, scaleX);
        int y = displayRectangle.y + anchoredImage.getAnchorPoint().getY() * displayRectangle.height + AwtUtilsKt.scaled(anchoredImage.getOffset().y, scaleY);
        transform.setToTranslation(x, y);
        transform.scale(scaleX, scaleY);
        g.drawImage(anchoredImage.getImage(), transform, null);
    }

    @Nullable
    public final SkinButton findSkinButtonContaining(int x, int y) {
        for (SkinButton button : this.buttons) {
            int relativeY;
            AnchoredImage anchoredImage = button.getImage();
            int relativeX = x - anchoredImage.getOffset().x - anchoredImage.getAnchorPoint().getX() * this.displaySize.width;
            if (relativeX < 0 || relativeX >= anchoredImage.getSize().width || (relativeY = y - anchoredImage.getOffset().y - anchoredImage.getAnchorPoint().getY() * this.displaySize.height) < 0 || relativeY >= anchoredImage.getSize().height || ImageUtils.isTransparentPixel(anchoredImage.getImage(), relativeX, relativeY)) continue;
            return button;
        }
        return null;
    }
}

