/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.instructions;

import com.android.tools.adtui.instructions.RenderInstruction;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconInstruction
extends RenderInstruction {
    @NotNull
    private final Icon myIcon;
    private final int myPadding;
    @Nullable
    private final Color myBgColor;
    @NotNull
    private final Dimension mySize;

    public IconInstruction(@NotNull Icon icon, int padding, @Nullable Color bgColor) {
        this.myIcon = icon;
        this.myPadding = padding;
        this.myBgColor = bgColor;
        this.mySize = new Dimension(this.myIcon.getIconWidth() + 2 * this.myPadding, this.myIcon.getIconHeight() + 2 * this.myPadding);
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return this.mySize;
    }

    @NotNull
    @VisibleForTesting
    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public void render(@NotNull JComponent c, @NotNull Graphics2D g2d, @NotNull Rectangle bounds) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        assert (this.mySize.height <= bounds.height && this.mySize.width <= bounds.width);
        if (this.myBgColor != null) {
            g2d.setColor(this.myBgColor);
            g2d.fillRoundRect(bounds.x, bounds.y, this.mySize.width, this.mySize.height, 5, 5);
        }
        int iconY = bounds.y + (bounds.height - this.myIcon.getIconHeight()) / 2;
        this.myIcon.paintIcon(c, g2d, bounds.x + this.myPadding, iconY);
    }
}

