/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;

public class EaseOutModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final Updater myUpdater;
    private final long myEaseOutStartTimeNs;
    private long myTimeRemainingUntilEaseOut;
    private float myRatio;

    public EaseOutModel(@NotNull Updater updater, long easeOutStartTimeNs) {
        assert (easeOutStartTimeNs >= 0L);
        this.myUpdater = updater;
        this.myRatio = 0.0f;
        this.myTimeRemainingUntilEaseOut = this.myEaseOutStartTimeNs = easeOutStartTimeNs;
        this.myUpdater.register(this);
    }

    public void setCurrentRatio(float ratio) {
        assert (ratio >= 0.0f && ratio <= 1.0f);
        this.myRatio = ratio;
        this.changed(Aspect.EASING);
        if (this.myRatio >= 1.0f) {
            this.myUpdater.unregister(this);
        }
    }

    @Override
    public void update(long elapsedNs) {
        this.myTimeRemainingUntilEaseOut -= elapsedNs;
        if (this.myTimeRemainingUntilEaseOut < 0L) {
            this.myRatio = Updater.lerp(this.myRatio, 1.0f, 0.99f, elapsedNs, 0.01f);
        }
        this.changed(Aspect.EASING);
        if (this.myRatio >= 1.0f) {
            this.myUpdater.unregister(this);
        }
    }

    public float getRatioComplete() {
        return this.myRatio;
    }

    public static enum Aspect {
        EASING;

    }
}

