/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.model.stdui.CommonComboBoxModel;
import com.android.tools.adtui.model.stdui.CommonElementSelectability;
import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.stdui.CommonComboBoxRenderer;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.adtui.stdui.KeyBindingKt;
import com.android.tools.adtui.stdui.KeyStrokes;
import com.android.tools.adtui.stdui.Lookup;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0010\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0010\b\u0001\u0010\u0002 \u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0003()*B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002J\b\u0010$\u001a\u00020\u0018H\u0016J\r\u0010%\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\u0018H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox;", "E", "M", "Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;", "Lcom/intellij/openapi/ui/ComboBox;", "model", "<init>", "(Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;)V", "actionOnKeyNavigation", "", "getActionOnKeyNavigation", "()Z", "setActionOnKeyNavigation", "(Z)V", "value", "", "logicalSelectionIndex", "getLogicalSelectionIndex", "()I", "setLogicalSelectionIndex", "(I)V", "textField", "Lcom/android/tools/adtui/stdui/CommonTextField;", "updateFromModel", "", "acceptChosenItem", "item", "", "setFromModel", "consumeKeyNavigation", "getConsumeKeyNavigation", "togglePopup", "moveNext", "movePrevious", "moveNextPage", "movePreviousPage", "updateUI", "getModel", "()Lcom/android/tools/adtui/model/stdui/CommonComboBoxModel;", "installDefaultRenderer", "CommonComboBoxEditor", "TextFieldForComboBox", "MyPopupListSelectionModel", "intellij.android.adt.ui"})
public class CommonComboBox<E, M extends CommonComboBoxModel<E>>
extends ComboBox<E> {
    private boolean actionOnKeyNavigation;
    @Nullable
    private CommonTextField<?> textField;

    public CommonComboBox(@NotNull M model2) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        super((ComboBoxModel)model2);
        this.actionOnKeyNavigation = !UIManager.getBoolean("ComboBox.noActionOnKeyNavigation");
        super.setEditor((ComboBoxEditor)new CommonComboBoxEditor((CommonTextFieldModel)model2, this));
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonComboBox._init_$lambda$0(this), KeyStrokes.INSTANCE.getDOWN(), "moveNext", () -> CommonComboBox._init_$lambda$1(this), 0, 16, null);
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonComboBox._init_$lambda$2(this), KeyStrokes.INSTANCE.getUP(), "movePrevious", () -> CommonComboBox._init_$lambda$3(this), 0, 16, null);
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonComboBox._init_$lambda$4(this), KeyStrokes.INSTANCE.getPAGE_DOWN(), "moveNextPage", () -> CommonComboBox._init_$lambda$5(this), 0, 16, null);
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonComboBox._init_$lambda$6(this), KeyStrokes.INSTANCE.getPAGE_UP(), "movePreviousPage", () -> CommonComboBox._init_$lambda$7(this), 0, 16, null);
        KeyBindingKt.registerActionKey$default((JComponent)((Object)this), () -> CommonComboBox._init_$lambda$8(this), KeyStrokes.INSTANCE.getALT_DOWN(), "toggle", null, 0, 24, null);
        Component component = this.editor.getEditorComponent();
        Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type com.android.tools.adtui.stdui.CommonTextField<*>");
        this.textField = (CommonTextField)((Object)component);
        CommonTextField<?> commonTextField = this.textField;
        if (commonTextField != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField), () -> CommonComboBox._init_$lambda$9(this), KeyStrokes.INSTANCE.getDOWN(), "moveNext", () -> CommonComboBox._init_$lambda$10(this), 0, 16, null);
        }
        CommonTextField<?> commonTextField2 = this.textField;
        if (commonTextField2 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField2), () -> CommonComboBox._init_$lambda$11(this), KeyStrokes.INSTANCE.getUP(), "movePrevious", () -> CommonComboBox._init_$lambda$12(this), 0, 16, null);
        }
        CommonTextField<?> commonTextField3 = this.textField;
        if (commonTextField3 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField3), () -> CommonComboBox._init_$lambda$13(this), KeyStrokes.INSTANCE.getPAGE_DOWN(), "moveNextPage", () -> CommonComboBox._init_$lambda$14(this), 0, 16, null);
        }
        CommonTextField<?> commonTextField4 = this.textField;
        if (commonTextField4 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField4), () -> CommonComboBox._init_$lambda$15(this), KeyStrokes.INSTANCE.getPAGE_UP(), "movePreviousPage", () -> CommonComboBox._init_$lambda$16(this), 0, 16, null);
        }
        CommonTextField<?> commonTextField5 = this.textField;
        if (commonTextField5 != null) {
            KeyBindingKt.registerActionKey$default((JComponent)((Object)commonTextField5), () -> CommonComboBox._init_$lambda$17(this), KeyStrokes.INSTANCE.getALT_DOWN(), "toggle", null, 0, 24, null);
        }
        this.setFromModel();
        ((CommonTextFieldModel)model2).addListener(() -> CommonComboBox._init_$lambda$18(this));
    }

    public final boolean getActionOnKeyNavigation() {
        return this.actionOnKeyNavigation;
    }

    public final void setActionOnKeyNavigation(boolean bl) {
        this.actionOnKeyNavigation = bl;
    }

    private final int getLogicalSelectionIndex() {
        Object object;
        return this.actionOnKeyNavigation ? this.getSelectedIndex() : ((object = this.getPopup()) != null && (object = object.getList()) != null ? ((JList)object).getSelectedIndex() : -1);
    }

    private final void setLogicalSelectionIndex(int value) {
        if (this.actionOnKeyNavigation) {
            this.setSelectedIndex(value);
        } else {
            Object object = this.getPopup();
            if (object == null || (object = object.getList()) == null) {
                return;
            }
            Object list = object;
            ((JList)list).setSelectedIndex(value);
            ((JList)list).ensureIndexIsVisible(value);
        }
    }

    protected void updateFromModel() {
        this.setFromModel();
    }

    protected boolean acceptChosenItem(@Nullable Object item) {
        return true;
    }

    private final void setFromModel() {
        this.setEnabled(((CommonTextFieldModel)((Object)this.getModel())).getEnabled());
        if (this.isEditable != ((CommonTextFieldModel)((Object)this.getModel())).getEditable()) {
            super.setEditable(((CommonTextFieldModel)((Object)this.getModel())).getEditable());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getConsumeKeyNavigation() {
        if (this.isPopupVisible()) return true;
        CommonTextField<?> commonTextField = this.textField;
        Object object = commonTextField;
        if (commonTextField == null) return false;
        Lookup<?> lookup = ((CommonTextField)((Object)object)).getLookup();
        object = lookup;
        if (lookup == null) return false;
        if (!((Lookup)object).isVisible()) return false;
        return true;
    }

    private final void togglePopup() {
        Object object = this.textField;
        boolean bl = object != null && (object = object.getLookup()) != null ? ((Lookup)object).isVisible() : false;
        if (bl) {
            return;
        }
        if (!this.isPopupVisible()) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    private final void moveNext() {
        Object object = this.textField;
        boolean bl = object != null && (object = object.getLookup()) != null ? ((Lookup)object).isVisible() : false;
        if (bl) {
            Object object2 = this.textField;
            if (object2 != null && (object2 = object2.getLookup()) != null) {
                ((Lookup)object2).selectNext();
            }
        } else if (!this.isPopupVisible()) {
            this.showPopup();
        } else {
            int size = this.dataModel.getSize();
            int index = this.getLogicalSelectionIndex();
            this.setLogicalSelectionIndex(Integer.min(index + 1, size - 1));
        }
    }

    private final void movePrevious() {
        Object object = this.textField;
        boolean bl = object != null && (object = object.getLookup()) != null ? ((Lookup)object).isVisible() : false;
        if (bl) {
            Object object2 = this.textField;
            if (object2 != null && (object2 = object2.getLookup()) != null) {
                ((Lookup)object2).selectPrevious();
            }
        } else if (this.isPopupVisible()) {
            int minValue = this.dataModel.getSize() == 0 ? -1 : 0;
            int index = this.getLogicalSelectionIndex();
            this.setLogicalSelectionIndex(Integer.max(index - 1, minValue));
        }
    }

    private final void moveNextPage() {
        Object object = this.textField;
        boolean bl = object != null && (object = object.getLookup()) != null ? ((Lookup)object).isVisible() : false;
        if (bl) {
            Object object2 = this.textField;
            if (object2 != null && (object2 = object2.getLookup()) != null) {
                ((Lookup)object2).selectNextPage();
            }
        } else if (this.isPopupVisible()) {
            int size = this.dataModel.getSize();
            int index = this.getLogicalSelectionIndex();
            this.setLogicalSelectionIndex(Integer.min(index + this.maximumRowCount, size - 1));
        }
    }

    private final void movePreviousPage() {
        Object object = this.textField;
        boolean bl = object != null && (object = object.getLookup()) != null ? ((Lookup)object).isVisible() : false;
        if (bl) {
            Object object2 = this.textField;
            if (object2 != null && (object2 = object2.getLookup()) != null) {
                ((Lookup)object2).selectPreviousPage();
            }
        } else if (this.isPopupVisible()) {
            int minValue = this.dataModel.getSize() == 0 ? -1 : 0;
            int index = this.getLogicalSelectionIndex();
            this.setLogicalSelectionIndex(Integer.max(index - this.maximumRowCount, minValue));
        }
    }

    public void updateUI() {
        super.updateUI();
        Object object = this.getPopup();
        if (object != null && (object = object.getList()) != null) {
            ((JList)object).setSelectionModel(new MyPopupListSelectionModel(this.getModel()));
        }
        this.installDefaultRenderer();
    }

    @NotNull
    public M getModel() {
        ComboBoxModel comboBoxModel = super.getModel();
        Intrinsics.checkNotNull((Object)comboBoxModel, (String)"null cannot be cast to non-null type M of com.android.tools.adtui.stdui.CommonComboBox");
        return (M)((CommonComboBoxModel)comboBoxModel);
    }

    private final void installDefaultRenderer() {
        ListCellRenderer renderer = this.getRenderer();
        if (renderer == null || renderer instanceof UIResource) {
            this.setRenderer(new CommonComboBoxRenderer.UIResource());
        }
    }

    private static final Unit _init_$lambda$0(CommonComboBox this$0) {
        this$0.moveNext();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$1(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$2(CommonComboBox this$0) {
        this$0.movePrevious();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$3(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$4(CommonComboBox this$0) {
        this$0.moveNextPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$5(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$6(CommonComboBox this$0) {
        this$0.movePreviousPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$7(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$8(CommonComboBox this$0) {
        this$0.togglePopup();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$9(CommonComboBox this$0) {
        this$0.moveNext();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$10(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$11(CommonComboBox this$0) {
        this$0.movePrevious();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$12(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$13(CommonComboBox this$0) {
        this$0.moveNextPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$14(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$15(CommonComboBox this$0) {
        this$0.movePreviousPage();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$16(CommonComboBox this$0) {
        return this$0.getConsumeKeyNavigation();
    }

    private static final Unit _init_$lambda$17(CommonComboBox this$0) {
        this$0.togglePopup();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$18(CommonComboBox this$0) {
        this$0.updateFromModel();
        this$0.repaint();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\n\b\u0003\u0010\u0002 \u0001*\u00020\u00032\u00020\u0004B!\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00028\u0002\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox$CommonComboBoxEditor;", "E", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Ljavax/swing/plaf/basic/BasicComboBoxEditor;", "model", "comboBox", "Lcom/android/tools/adtui/stdui/CommonComboBox;", "<init>", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;Lcom/android/tools/adtui/stdui/CommonComboBox;)V", "createEditorComponent", "Ljavax/swing/JTextField;", "setItem", "", "item", "", "intellij.android.adt.ui"})
    private static final class CommonComboBoxEditor<E, M extends CommonTextFieldModel>
    extends BasicComboBoxEditor {
        @NotNull
        private final CommonComboBox<E, ?> comboBox;

        public CommonComboBoxEditor(@NotNull M model2, @NotNull CommonComboBox<E, ?> comboBox) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            Intrinsics.checkNotNullParameter(comboBox, (String)"comboBox");
            this.comboBox = comboBox;
            this.editor = (JTextField)((Object)new TextFieldForComboBox(model2, (JComboBox)((Object)this.comboBox)));
            this.editor.setBorder((Border)JBUI.Borders.empty());
        }

        @Override
        @Nullable
        protected JTextField createEditorComponent() {
            return null;
        }

        @Override
        public void setItem(@Nullable Object item) {
            if (this.comboBox.acceptChosenItem(item)) {
                super.setItem(item);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\u00020\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox$MyPopupListSelectionModel;", "E", "Ljavax/swing/DefaultListSelectionModel;", "model", "Ljavax/swing/ListModel;", "<init>", "(Ljavax/swing/ListModel;)V", "setSelectionInterval", "", "index0", "", "index1", "findFirstSelectableIndex", "start", "intellij.android.adt.ui"})
    private static final class MyPopupListSelectionModel<E>
    extends DefaultListSelectionModel {
        @NotNull
        private final ListModel<E> model;

        public MyPopupListSelectionModel(@NotNull ListModel<E> model2) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            this.model = model2;
        }

        @Override
        public void setSelectionInterval(int index0, int index1) {
            int index = this.findFirstSelectableIndex(index0);
            super.setSelectionInterval(index, index);
        }

        private final int findFirstSelectableIndex(int start) {
            int index = start;
            if (index < 0) {
                return -1;
            }
            while (index < this.model.getSize()) {
                E element = this.model.getElementAt(index);
                CommonElementSelectability commonElementSelectability = element instanceof CommonElementSelectability ? (CommonElementSelectability)element : null;
                if (commonElementSelectability == null) {
                    return index;
                }
                CommonElementSelectability selectable = commonElementSelectability;
                if (selectable.isSelectable()) {
                    return index;
                }
                ++index;
            }
            return -1;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u0001*\n\b\u0003\u0010\u0002 \u0001*\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00028\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/adtui/stdui/CommonComboBox$TextFieldForComboBox;", "E", "M", "Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;", "Lcom/android/tools/adtui/stdui/CommonTextField;", "model", "comboBox", "Ljavax/swing/JComboBox;", "<init>", "(Lcom/android/tools/adtui/model/stdui/CommonTextFieldModel;Ljavax/swing/JComboBox;)V", "getToolTipText", "", "event", "Ljava/awt/event/MouseEvent;", "showLookupCompletions", "", "forText", "intellij.android.adt.ui"})
    private static final class TextFieldForComboBox<E, M extends CommonTextFieldModel>
    extends CommonTextField<M> {
        @NotNull
        private final JComboBox<E> comboBox;

        public TextFieldForComboBox(@NotNull M model2, @NotNull JComboBox<E> comboBox) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            Intrinsics.checkNotNullParameter(comboBox, (String)"comboBox");
            super(model2);
            this.comboBox = comboBox;
        }

        @Nullable
        public String getToolTipText() {
            return this.comboBox.getToolTipText();
        }

        @Nullable
        public String getToolTipText(@Nullable MouseEvent event) {
            return this.comboBox.getToolTipText(event);
        }

        @Override
        protected void showLookupCompletions(@NotNull String forText) {
            Intrinsics.checkNotNullParameter((Object)forText, (String)"forText");
            if (this.comboBox.isPopupVisible()) {
                this.comboBox.hidePopup();
            }
            super.showLookupCompletions(forText);
        }
    }
}

