/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.adtui.util.ActionToolbarUtil;
import com.android.tools.adtui.workbench.AttachedLocation;
import com.android.tools.adtui.workbench.Layout;
import com.android.tools.adtui.workbench.SideModel;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.adtui.workbench.ToolWindowCallback;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.toolWindow.StripeButtonUi;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.NewUI;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SideBorder;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

class AttachedToolWindow<T>
implements ToolWindowCallback,
Disposable {
    static final String TOOL_WINDOW_PROPERTY_PREFIX = "ATTACHED_TOOL_WINDOW.";
    static final String TOOL_WINDOW_TOOLBAR_PLACE = "TOOL_WINDOW_TOOLBAR";
    static final String LABEL_HEADER = "LABEL";
    static final String SEARCH_HEADER = "SEARCH";
    private final WorkBench<T> myWorkBench;
    private final ToolWindowDefinition<T> myDefinition;
    private final PropertiesComponent myPropertiesComponent;
    private final SideModel<T> myModel;
    private final JPanel myPanel;
    private final MinimizedButton<T> myMinimizedButton;
    private final MinimizedButtonModel myMinimizedButtonModel;
    private MySearchField mySearchField;
    private ButtonDragListener<T> myDragListener;
    private ActionToolbar myActionToolbar;
    private ActionButton mySearchActionButton;
    private boolean myShowSearchField;
    @Nullable
    private ToolContent<T> myContent;
    private boolean myAutoHideOpen;
    private int myToolOrder;

    AttachedToolWindow(@NotNull ToolWindowDefinition<T> definition, @NotNull ButtonDragListener<T> dragListener, @NotNull WorkBench<T> workBench, @NotNull SideModel<T> model2, boolean minimizedByDefault) {
        AnAction globalFindAction;
        Disposer.register(workBench, (Disposable)this);
        this.myWorkBench = workBench;
        this.myDefinition = definition;
        this.myDragListener = dragListener;
        this.myPropertiesComponent = PropertiesComponent.getInstance();
        this.myModel = model2;
        this.myPanel = new AttachedToolWindowPanel(this);
        this.myMinimizedButtonModel = new MinimizedButtonModel();
        this.myMinimizedButton = new MinimizedButton(definition.getTitle(), definition.getIcon(), this, this.myMinimizedButtonModel);
        this.setDefaultProperty(PropertyType.LEFT, definition.getSide().isLeft());
        this.setDefaultProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        this.setDefaultProperty(PropertyType.AUTO_HIDE, definition.getAutoHide().isAutoHide());
        this.setDefaultProperty(PropertyType.MINIMIZED, minimizedByDefault);
        this.updateContent();
        if (this.myDefinition.overrideSide()) {
            this.setProperty(PropertyType.LEFT, definition.getSide().isLeft());
        }
        if (this.myDefinition.overrideSplit()) {
            this.setProperty(PropertyType.SPLIT, definition.getSplit().isBottom());
        }
        if ((globalFindAction = ActionManager.getInstance().getAction("Find")) != null) {
            new FindAction().registerCustomShortcutSet(globalFindAction.getShortcutSet(), this.myPanel, this);
        }
    }

    public void dispose() {
        if (this.myContent != null) {
            this.myContent = null;
            this.myDragListener = null;
            this.myPanel.removeAll();
        }
    }

    @NotNull
    public String getToolName() {
        return this.myDefinition.getName();
    }

    public int getToolOrder() {
        return this.myToolOrder;
    }

    public void setToolOrder(int order) {
        this.myToolOrder = order;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public AbstractButton getMinimizedButton() {
        return this.myMinimizedButton;
    }

    @Nullable
    public T getContext() {
        return this.myModel.getContext();
    }

    public ToolWindowDefinition<T> getDefinition() {
        return this.myDefinition;
    }

    public boolean isMinimized() {
        return this.getProperty(PropertyType.MINIMIZED);
    }

    public void setMinimized(boolean value) {
        this.setProperty(PropertyType.MINIMIZED, value);
    }

    public boolean isLeft() {
        return this.getProperty(PropertyType.LEFT);
    }

    public void setLeft(boolean value) {
        this.setProperty(PropertyType.LEFT, value);
    }

    public boolean isSplit() {
        return this.getProperty(PropertyType.SPLIT);
    }

    public void setSplit(boolean value) {
        this.setProperty(PropertyType.SPLIT, value);
    }

    public boolean isAutoHide() {
        return this.getProperty(PropertyType.AUTO_HIDE);
    }

    public void setAutoHide(boolean value) {
        this.setProperty(PropertyType.AUTO_HIDE, value);
    }

    public boolean isFloating() {
        return this.getProperty(PropertyType.FLOATING) && (Boolean)StudioFlags.DETACHABLE_ATTACHED_TOOLWINDOWS.get() != false;
    }

    public void setFloating(boolean value) {
        this.setProperty(PropertyType.FLOATING, value);
    }

    public boolean isDetached() {
        return this.getProperty(PropertyType.DETACHED) && (Boolean)StudioFlags.DETACHABLE_ATTACHED_TOOLWINDOWS.get() != false;
    }

    public void setDetached(boolean value) {
        this.setProperty(PropertyType.DETACHED, value);
    }

    public boolean getProperty(@NotNull PropertyType property) {
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            return !this.myAutoHideOpen;
        }
        return this.getLayoutProperty(Layout.CURRENT, property);
    }

    public void setProperty(@NotNull PropertyType property, boolean value) {
        if (property == PropertyType.MINIMIZED && this.isAutoHide()) {
            this.myAutoHideOpen = !value;
        } else {
            this.setLayoutProperty(Layout.CURRENT, property, value);
        }
        if (this.myMinimizedButton != null) {
            this.myMinimizedButtonModel.setMinimized(this.isMinimized());
        }
    }

    private boolean getLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property) {
        return this.myPropertiesComponent.getBoolean(this.getPropertyName(layout, property));
    }

    private void setLayoutProperty(@NotNull Layout layout, @NotNull PropertyType property, boolean value) {
        this.myPropertiesComponent.setValue(this.getPropertyName(layout, property), value);
    }

    public void setDefaultProperty(@NotNull PropertyType property, boolean defaultValue) {
        if (!this.myPropertiesComponent.isValueSet(this.getPropertyName(Layout.DEFAULT, property))) {
            this.myPropertiesComponent.setValue(this.getPropertyName(Layout.DEFAULT, property), defaultValue, !defaultValue);
            this.setLayoutProperty(Layout.CURRENT, property, defaultValue);
        }
    }

    private String getPropertyName(@NotNull Layout layout, @NotNull PropertyType property) {
        String context = this.myWorkBench.getContext();
        return String.format("%s%s%s.%s.%s%s%s", TOOL_WINDOW_PROPERTY_PREFIX, layout.getPrefix(), this.myWorkBench.getName(), this.myDefinition.getName(), context, StringUtil.isEmpty((String)context) ? "" : ".", property.name());
    }

    public void setPropertyAndUpdate(@NotNull PropertyType property, boolean value) {
        this.setProperty(property, value);
        if (property == PropertyType.FLOATING && value) {
            property = PropertyType.DETACHED;
            this.setProperty(property, true);
        }
        this.updateContent();
        this.myModel.update(this, property);
        if (property == PropertyType.MINIMIZED && !value && this.myContent != null) {
            this.myContent.getFocusedComponent().requestFocus();
        }
    }

    public void storeDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setLayoutProperty(Layout.DEFAULT, property, this.getLayoutProperty(Layout.CURRENT, property));
        }
    }

    public void restoreDefaultLayout() {
        for (PropertyType property : PropertyType.values()) {
            this.setProperty(property, this.getLayoutProperty(Layout.DEFAULT, property));
        }
        this.updateContent();
        this.myModel.update(this, PropertyType.DETACHED);
    }

    public void setContext(T context) {
        if (this.myContent != null) {
            this.myContent.setToolContext(context);
        }
    }

    @VisibleForTesting
    @Nullable
    public SearchTextField getSearchField() {
        return this.mySearchField;
    }

    @VisibleForTesting
    @Nullable
    ToolContent<T> getContent() {
        return this.myContent;
    }

    private void updateContent() {
        if (this.isDetached() && this.myContent != null) {
            this.myPanel.removeAll();
            this.myContent.setToolContext(null);
            Disposer.dispose(this.myContent);
            this.myContent = null;
            this.myActionToolbar = null;
            this.mySearchActionButton = null;
        } else if (!this.isDetached() && this.myContent == null) {
            this.myContent = this.myDefinition.getFactory().apply(this);
            assert (this.myContent != null);
            this.myContent.setToolContext(this.myModel.getContext());
            this.myContent.registerCallbacks(this);
            this.myPanel.add((Component)this.createHeader(this.myContent), "North");
            this.myPanel.add((Component)this.myContent.getComponent(), "Center");
        }
        this.myPanel.putClientProperty("com.android.tools.adtui.workbench.TOOL_CONTENT", this.myContent);
    }

    public int getHeaderHeight() {
        BorderLayout layout = (BorderLayout)this.myPanel.getLayout();
        return layout.getLayoutComponent("North").getHeight();
    }

    @Override
    public void restore() {
        if (!this.isDetached() && this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, false);
        }
    }

    @Override
    public void autoHide() {
        if (!this.isDetached() && this.isAutoHide() && !this.isMinimized()) {
            this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    @NotNull
    private JComponent createHeader(@NotNull ToolContent<T> content) {
        this.myActionToolbar = this.createToolbar(content);
        this.mySearchActionButton = this.findSearchActionButton(content, this.myActionToolbar);
        JPanel header2 = new JPanel(new BorderLayout());
        header2.add((Component)this.createTitlePanel(this.myDefinition.getTitle(), content.supportsFiltering()), "Center");
        header2.add((Component)this.myActionToolbar.getComponent(), "East");
        header2.setBorder((Border)new SideBorder(JBColor.border(), 8));
        return header2;
    }

    @NotNull
    private JPanel createTitlePanel(@NotNull String title, boolean includeSearchField) {
        CardLayout layout = new CardLayout();
        JPanel titlePanel = new JPanel(layout);
        JBLabel titleLabel = new JBLabel(title){

            public void updateUI() {
                super.updateUI();
                this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            }
        };
        titleLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)5, (int)2, (int)10));
        titlePanel.add((Component)titleLabel, LABEL_HEADER);
        if (includeSearchField) {
            this.mySearchField = new MySearchField(TOOL_WINDOW_PROPERTY_PREFIX + this.myWorkBench.getName() + ".TEXT_SEARCH_HISTORY");
            if (!NewUI.isEnabled() && (this.myDefinition.showGearAction() || this.myDefinition.showHideAction())) {
                this.mySearchField.setPreferredSize(new Dimension(this.mySearchField.getPreferredSize().width, titlePanel.getPreferredSize().height));
            }
            titlePanel.add((Component)((Object)this.mySearchField), SEARCH_HEADER);
        }
        layout.show(titlePanel, LABEL_HEADER);
        return titlePanel;
    }

    private void showSearchField(boolean show2) {
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        Container parent = this.mySearchField.getParent();
        CardLayout layout = (CardLayout)parent.getLayout();
        this.myShowSearchField = show2;
        if (show2) {
            layout.show(parent, SEARCH_HEADER);
            this.mySearchField.requestFocus();
        } else {
            layout.show(parent, LABEL_HEADER);
        }
        this.updateActions();
    }

    @Override
    public void startFiltering(@NotNull String initialSearchString) {
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        this.mySearchField.setText(initialSearchString);
        this.showSearchField(true);
    }

    @Override
    public void stopFiltering() {
        if (this.myContent == null || this.mySearchField == null) {
            return;
        }
        this.mySearchField.setText("");
        this.showSearchField(false);
    }

    @NotNull
    private ActionToolbar createToolbar(@NotNull ToolContent<T> content) {
        DefaultActionGroup rightGroup = new DefaultActionGroup();
        if (content.supportsFiltering()) {
            rightGroup.add((AnAction)new SearchAction());
        }
        if (!content.getAdditionalActions().isEmpty()) {
            rightGroup.addAll(content.getAdditionalActions());
            rightGroup.add((AnAction)Separator.getInstance());
        }
        if (this.myDefinition.showGearAction()) {
            rightGroup.add((AnAction)new GearAction());
        }
        if (this.myDefinition.showHideAction()) {
            rightGroup.add((AnAction)new HideAction());
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("AttachedToolWindow", (ActionGroup)rightGroup, true);
        ActionToolbarUtil.makeToolbarNavigable(actionToolbar);
        actionToolbar.setMinimumButtonSize(this.myDefinition.getButtonSize());
        actionToolbar.setTargetComponent((JComponent)this.myPanel);
        actionToolbar.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        return actionToolbar;
    }

    @Nullable
    private ActionButton findSearchActionButton(@NotNull ToolContent<T> content, @NotNull ActionToolbar actionToolbar) {
        if (!content.supportsFiltering()) {
            return null;
        }
        if (actionToolbar.getActions().isEmpty()) {
            return null;
        }
        return ActionToolbarUtil.findActionButton(actionToolbar, (AnAction)actionToolbar.getActions().get(0));
    }

    @Override
    public void updateActions() {
        if (this.myActionToolbar != null) {
            this.myActionToolbar.updateActionsAsync();
        }
    }

    private void showGearPopup(@NotNull Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        this.addGearPopupActions(group);
        DataContext context = DataManager.getInstance().getDataContext(component);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, null, -1, null, "popup");
        popup.show(new RelativePoint(component, new Point(x, y)));
    }

    private void addGearPopupActions(@NotNull DefaultActionGroup group) {
        List<AnAction> myExtraGearActions;
        if (this.myContent != null && !(myExtraGearActions = this.myContent.getGearActions()).isEmpty()) {
            group.addAll(myExtraGearActions);
            group.addSeparator();
        }
        DefaultActionGroup attachedLocation = DefaultActionGroup.createPopupGroup(() -> "Attached to");
        if (this.myDefinition.isSplitModeChangesAllowed()) {
            attachedLocation.add((AnAction)new AttachedLocationAction(AttachedLocation.LeftTop));
            attachedLocation.add((AnAction)new AttachedLocationAction(AttachedLocation.LeftBottom));
            attachedLocation.add((AnAction)new AttachedLocationAction(AttachedLocation.RightTop));
            attachedLocation.add((AnAction)new AttachedLocationAction(AttachedLocation.RightBottom));
        } else {
            attachedLocation.add((AnAction)new TogglePropertyTypeAction(PropertyType.LEFT, "Left"));
            attachedLocation.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.LEFT, "Right"));
        }
        attachedLocation.add((AnAction)new SwapAction());
        if (this.myDefinition.isFloatingAllowed() && ((Boolean)StudioFlags.DETACHABLE_ATTACHED_TOOLWINDOWS.get()).booleanValue()) {
            attachedLocation.add((AnAction)new TogglePropertyTypeAction(PropertyType.DETACHED, "None"));
        }
        group.add((AnAction)attachedLocation);
        ActionManager manager = ActionManager.getInstance();
        if (this.myDefinition.isAutoHideAllowed()) {
            group.add((AnAction)new ToggleOppositePropertyTypeAction(PropertyType.AUTO_HIDE, manager.getAction("ToggleDockMode")));
        }
        if (this.myDefinition.isFloatingAllowed() && ((Boolean)StudioFlags.DETACHABLE_ATTACHED_TOOLWINDOWS.get()).booleanValue()) {
            group.add((AnAction)new TogglePropertyTypeAction(PropertyType.FLOATING, manager.getAction("ToggleFloatingMode")));
        }
    }

    @VisibleForTesting
    void fireButtonDragged(@NotNull DragEvent event) {
        this.myDragListener.buttonDragged(this, event);
    }

    @VisibleForTesting
    void fireButtonDropped(@NotNull DragEvent event) {
        this.myDragListener.buttonDropped(this, event);
    }

    public void setActive(boolean isActive) {
        this.myMinimizedButtonModel.setActive(isActive);
        this.myMinimizedButton.setActive(isActive);
    }

    static interface ButtonDragListener<T> {
        public void buttonDragged(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);

        public void buttonDropped(@NotNull AttachedToolWindow<T> var1, @NotNull DragEvent var2);
    }

    static final class AttachedToolWindowPanel
    extends JPanel {
        private final AttachedToolWindow<?> myToolWindow;

        @VisibleForTesting
        AttachedToolWindowPanel(@NotNull AttachedToolWindow<?> toolWindow) {
            super(new BorderLayout());
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
            this.myToolWindow = toolWindow;
        }

        @TestOnly
        public AttachedToolWindow<?> getToolWindow() {
            return this.myToolWindow;
        }

        public void setActive(boolean isActive) {
            this.myToolWindow.setActive(isActive);
        }
    }

    private static class MinimizedButtonModel
    extends JToggleButton.ToggleButtonModel {
        private boolean myIsActive;
        private boolean myIsMinimized;

        private MinimizedButtonModel() {
        }

        public void setActive(boolean isActive) {
            if (isActive != this.myIsActive) {
                this.myIsActive = isActive;
                this.fireStateChanged();
            }
        }

        public void setMinimized(boolean isMinimized) {
            if (isMinimized != this.myIsMinimized) {
                this.myIsMinimized = isMinimized;
                this.fireStateChanged();
            }
        }

        @Override
        public void setSelected(boolean isSelected) {
            this.setMinimized(!isSelected);
        }

        @Override
        public boolean isSelected() {
            return NewUI.isEnabled() ? this.myIsActive : !this.myIsMinimized;
        }

        @Override
        public boolean isRollover() {
            return NewUI.isEnabled() ? !this.myIsMinimized : super.isRollover();
        }
    }

    private static class MinimizedButton<T>
    extends AnchoredButton {
        private final AttachedToolWindow<T> myToolWindow;
        private final Icon myIcon;
        private JLabel myDragImage;
        private Point myStartDragPosition;

        private MinimizedButton(@NotNull String title, @NotNull Icon icon, @NotNull AttachedToolWindow<T> toolWindow, @NotNull ButtonModel model2) {
            super(title, icon);
            this.setModel(model2);
            this.myToolWindow = toolWindow;
            this.myIcon = icon;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(false);
            this.setBackground(null);
            MouseInputAdapter listener2 = new MouseInputAdapter(){

                @Override
                public void mouseDragged(@NotNull MouseEvent event) {
                    this.handleDragging(event);
                }

                @Override
                public void mouseReleased(@NotNull MouseEvent event) {
                    this.stopDragging(event);
                }

                @Override
                public void mouseClicked(@NotNull MouseEvent event) {
                    if ((event.getModifiersEx() & 0x100) == 0) {
                        this.setSelected(false);
                        myToolWindow.setPropertyAndUpdate(PropertyType.MINIMIZED, !myToolWindow.isMinimized());
                    } else {
                        myToolWindow.showGearPopup((Component)((Object)this), event.getX(), event.getY());
                    }
                }
            };
            this.addMouseListener(listener2);
            this.addMouseMotionListener(listener2);
            this.setSelected(!toolWindow.isMinimized());
            this.setIcon(this.myIcon);
        }

        public void setActive(boolean isActive) {
            this.setIcon(isActive ? ColoredIconGenerator.generateWhiteIcon(this.myIcon) : this.myIcon);
        }

        public void updateUI() {
            this.setUI((ButtonUI)new StripeButtonUi());
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public void paint(@NotNull Graphics graphics) {
            if (this.isDragging()) {
                return;
            }
            if (!this.myToolWindow.isLeft()) {
                super.paint(graphics);
                return;
            }
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(JBUI.scale((int)1), 0);
                super.paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }

        public int getMnemonic2() {
            return 0;
        }

        public ToolWindowAnchor getAnchor() {
            return this.myToolWindow.isLeft() ? ToolWindowAnchor.LEFT : ToolWindowAnchor.RIGHT;
        }

        private boolean isDragging() {
            return this.myDragImage != null;
        }

        private void handleDragging(@NotNull MouseEvent event) {
            if (!this.isDragging()) {
                this.startDragging(event);
            }
            this.myToolWindow.fireButtonDragged(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
        }

        private void stopDragging(@NotNull MouseEvent event) {
            if (this.isDragging()) {
                this.myToolWindow.fireButtonDropped(new DragEvent(event, this.myDragImage, this.myStartDragPosition));
                this.myDragImage = null;
                this.myStartDragPosition = null;
            }
        }

        private void startDragging(@NotNull MouseEvent event) {
            BufferedImage image = ImageUtil.createImage((int)this.getWidth(), (int)this.getHeight(), (int)2);
            Graphics graphics = image.getGraphics();
            this.paint(graphics);
            graphics.dispose();
            this.myDragImage = new JBLabel((Icon)new JBImageIcon((Image)image));
            this.myStartDragPosition = event.getPoint();
        }
    }

    static enum PropertyType {
        AUTO_HIDE,
        MINIMIZED,
        LEFT,
        SPLIT,
        DETACHED,
        FLOATING;

    }

    private final class FindAction
    extends DumbAwareAction {
        private FindAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.showSearchField(true);
        }
    }

    private class MySearchField
    extends SearchTextField
    implements KeyListener {
        private Component myOldFocusComponent;

        private MySearchField(String propertyName) {
            super(propertyName);
            this.addKeyboardListener(this);
            this.addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (AttachedToolWindow.this.myContent != null) {
                        AttachedToolWindow.this.myContent.setFilter(MySearchField.this.getText().trim());
                    }
                }
            });
            this.getTextEditor().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(@NotNull FocusEvent event) {
                    MySearchField.this.myOldFocusComponent = event.getOppositeComponent();
                }
            });
        }

        public void removeNotify() {
            super.removeNotify();
            this.putClientProperty(AnAction.ACTIONS_KEY, null);
        }

        protected void onFocusLost() {
            Component focusedDescendant = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)((Object)this));
            if (focusedDescendant == null && this.getText().trim().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
            }
            this.myOldFocusComponent = null;
            super.onFocusLost();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyTyped(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyPressed(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
            if (event.getKeyCode() == 27 && this.getText().isEmpty()) {
                AttachedToolWindow.this.showSearchField(false);
                if (this.myOldFocusComponent != null) {
                    this.myOldFocusComponent.requestFocus();
                } else if (AttachedToolWindow.this.myContent != null) {
                    AttachedToolWindow.this.myContent.getFocusedComponent().requestFocus();
                } else if (AttachedToolWindow.this.mySearchActionButton != null) {
                    AttachedToolWindow.this.mySearchActionButton.requestFocus();
                }
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent event) {
            if (AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.getFilterKeyListener() != null) {
                AttachedToolWindow.this.myContent.getFilterKeyListener().keyReleased(event);
                if (event.isConsumed()) {
                    this.addCurrentTextToHistory();
                }
            }
        }
    }

    private class SearchAction
    extends DumbAwareAction {
        private SearchAction() {
            super("Search", null, AllIcons.Actions.Find);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void update(@NotNull AnActionEvent event) {
            Presentation presentation = event.getPresentation();
            presentation.setVisible(!AttachedToolWindow.this.myShowSearchField);
            presentation.setEnabled(AttachedToolWindow.this.myContent != null && AttachedToolWindow.this.myContent.isFilteringActive());
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.showSearchField(true);
        }
    }

    private class GearAction
    extends DumbAwareAction {
        private GearAction() {
            super("More Options", null, AllIcons.General.GearPlain);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            int x = 0;
            int y = 0;
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            AttachedToolWindow.this.showGearPopup(inputEvent.getComponent(), x, y);
        }
    }

    private class HideAction
    extends DumbAwareAction {
        private HideAction() {
            super(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]), null, AllIcons.General.HideToolWindow);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.MINIMIZED, true);
        }
    }

    private class AttachedLocationAction
    extends AnAction {
        private final AttachedLocation myLocation;

        private AttachedLocationAction(AttachedLocation location) {
            super(location.getTitle(), null, location.getIcon());
            this.myLocation = location;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent event) {
            boolean isCurrentLocation = this.myLocation.isLeft() == AttachedToolWindow.this.getProperty(PropertyType.LEFT) && this.myLocation.isBottom() == AttachedToolWindow.this.getProperty(PropertyType.SPLIT);
            event.getPresentation().setEnabled(!isCurrentLocation);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.setProperty(PropertyType.LEFT, this.myLocation.isLeft());
            AttachedToolWindow.this.setPropertyAndUpdate(PropertyType.SPLIT, this.myLocation.isBottom());
        }
    }

    private class TogglePropertyTypeAction
    extends DumbAwareToggleAction {
        private final PropertyType myProperty;

        private TogglePropertyTypeAction(@NotNull PropertyType property, String text) {
            super(text);
            this.myProperty = property;
        }

        private TogglePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            this.myProperty = property;
            this.copyFrom(action);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return AttachedToolWindow.this.getProperty(this.myProperty);
        }

        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            AttachedToolWindow.this.setPropertyAndUpdate(this.myProperty, state);
        }
    }

    private class ToggleOppositePropertyTypeAction
    extends TogglePropertyTypeAction {
        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, String text) {
            super(property, text);
        }

        private ToggleOppositePropertyTypeAction(@NotNull PropertyType property, AnAction action) {
            super(property, action);
        }

        @Override
        public boolean isSelected(@NotNull AnActionEvent event) {
            return !super.isSelected(event);
        }

        @Override
        public void setSelected(@NotNull AnActionEvent event, boolean state) {
            super.setSelected(event, !state);
        }
    }

    private class SwapAction
    extends DumbAwareAction {
        private SwapAction() {
            super("Swap");
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            AttachedToolWindow.this.myModel.swap();
        }
    }

    static class DragEvent {
        private final MouseEvent myMouseEvent;
        private final Component myDragImage;
        private final Point myDragPoint;

        DragEvent(@NotNull MouseEvent mouseEvent, @NotNull Component dragImage, @NotNull Point dragPoint) {
            this.myMouseEvent = mouseEvent;
            this.myDragImage = dragImage;
            this.myDragPoint = dragPoint;
        }

        @NotNull
        public Point getMousePoint() {
            return this.myMouseEvent.getPoint();
        }

        @NotNull
        public Component getDragImage() {
            return this.myDragImage;
        }

        @NotNull
        public Point getDragPoint() {
            return this.myDragPoint;
        }
    }
}

